/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBMissingParameterException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBParameterMetaData;
import org.firebirdsql.jdbc.FBResultSetMetaData;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdParameterMetaData;
import org.firebirdsql.jdbc.FirebirdPreparedStatement;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FBWorkaroundStringField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public abstract class AbstractPreparedStatement
extends AbstractStatement
implements FirebirdPreparedStatement {
    static final String METHOD_NOT_SUPPORTED = "This method is only supported on Statement and not supported on PreparedStatement and CallableStatement";
    private boolean metaDataQuery;
    private boolean standaloneStatement;
    private boolean generatedKeys;
    protected boolean[] isParamSet;
    private FBField[] fields = null;
    private boolean isExecuteProcedureStatement;
    private boolean trimStrings;
    private FBObjectListener.BlobListener blobListener;
    protected final List batchList = new LinkedList();

    protected AbstractPreparedStatement(GDSHelper c, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener, FBObjectListener.BlobListener blobListener) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability, statementListener);
        this.blobListener = blobListener;
    }

    protected AbstractPreparedStatement(GDSHelper c, String sql, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener, FBObjectListener.BlobListener blobListener, boolean metaDataQuery, boolean standaloneStatement, boolean generatedKeys) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability, statementListener);
        this.blobListener = blobListener;
        this.metaDataQuery = metaDataQuery;
        this.standaloneStatement = standaloneStatement;
        this.generatedKeys = generatedKeys;
        try {
            this.notifyStatementStarted();
            this.prepareFixedStatement(sql, true);
        }
        catch (GDSException ge) {
            this.notifyStatementCompleted(false);
            throw new FBSQLException(ge);
        }
        catch (SQLException sqle) {
            this.notifyStatementCompleted(false);
            throw sqle;
        }
        catch (RuntimeException e) {
            this.notifyStatementCompleted(false);
            throw e;
        }
    }

    public void completeStatement(AbstractStatement.CompletionReason reason) throws SQLException {
        if (!this.metaDataQuery) {
            super.completeStatement(reason);
        } else if (!this.completed) {
            this.notifyStatementCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void notifyStatementCompleted(boolean success) throws SQLException {
        try {
            super.notifyStatementCompleted(success);
            Object var3_2 = null;
            if (!this.metaDataQuery) return;
            if (!this.standaloneStatement) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!this.metaDataQuery || !this.standaloneStatement) throw throwable;
            this.close();
            throw throwable;
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            if (!this.internalExecute(this.isExecuteProcedureStatement)) {
                throw new FBSQLException("No resultset for sql", "07005");
            }
            return this.getResultSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            int n;
            this.notifyStatementStarted();
            try {
                if (this.internalExecute(this.isExecuteProcedureStatement) && !this.generatedKeys) {
                    throw new FBSQLException("Update statement returned results.");
                }
                n = this.getUpdateCount();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.notifyStatementCompleted();
                throw throwable;
            }
            this.notifyStatementCompleted();
            return n;
        }
    }

    public FirebirdParameterMetaData getFirebirdParameterMetaData() throws SQLException {
        return new FBParameterMetaData(this.fixedStmt.getInSqlda().sqlvar, this.gdsHelper);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getField(parameterIndex).setNull();
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.getField(parameterIndex).setBinaryStream(inputStream, length);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new FBDriverNotCapableException("Only length <= Integer.MAX_VALUE supported");
        }
        this.setBinaryStream(parameterIndex, x, (int)length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getField(parameterIndex).setBytes(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getField(parameterIndex).setBoolean(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getField(parameterIndex).setByte(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getField(parameterIndex).setDate(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getField(parameterIndex).setDouble(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getField(parameterIndex).setFloat(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getField(parameterIndex).setInteger(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getField(parameterIndex).setLong(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getField(parameterIndex).setObject(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getField(parameterIndex).setShort(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.getField(parameterIndex).setString(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setStringForced(int parameterIndex, String x) throws SQLException {
        FBField field = this.getField(parameterIndex);
        if (field instanceof FBWorkaroundStringField) {
            ((FBWorkaroundStringField)field).setStringForced(x);
        } else {
            field.setString(x);
        }
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getField(parameterIndex).setTime(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getField(parameterIndex).setTimestamp(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getField(parameterIndex).setBigDecimal(x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    protected XSQLVAR getXsqlvar(int columnIndex) {
        return this.fixedStmt.getInSqlda().sqlvar[columnIndex - 1];
    }

    protected FBField getField(int columnIndex) throws SQLException {
        if (columnIndex > this.fields.length) {
            throw new FBSQLException("Invalid column index.", "HY002");
        }
        return this.fields[columnIndex - 1];
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setURL(int parameterIndex, URL url) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void clearParameters() throws SQLException {
        if (this.isParamSet == null) {
            return;
        }
        for (int i = 0; i < this.isParamSet.length; ++i) {
            this.isParamSet[i] = false;
        }
        XSQLVAR[] xsqlvar = this.fixedStmt.getInSqlda().sqlvar;
        for (int i = 0; i < xsqlvar.length; ++i) {
            xsqlvar[i].sqldata = null;
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
        this.isParamSet[parameterIndex - 1] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            boolean hasResultSet = this.internalExecute(this.isExecuteProcedureStatement);
            if (!hasResultSet) {
                this.notifyStatementCompleted();
            }
            return hasResultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet executeMetaDataQuery() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            boolean hasResultSet = this.internalExecute(this.isExecuteProcedureStatement);
            if (!hasResultSet) {
                throw new FBSQLException("No result set is available.");
            }
            return this.getResultSet(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean internalExecute(boolean sendOutParams) throws SQLException {
        Object syncObject;
        boolean canExecute = true;
        for (int i = 0; i < this.isParamSet.length; ++i) {
            canExecute = canExecute && this.isParamSet[i];
        }
        if (!canExecute) {
            throw new FBMissingParameterException("Not all parameters were set.", this.isParamSet);
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.flushFields();
            try {
                try {
                    this.gdsHelper.executeStatement(this.fixedStmt, sendOutParams);
                    this.isResultSet = this.fixedStmt.getOutSqlda().sqld > 0;
                    boolean bl = this.fixedStmt.getOutSqlda().sqld > 0;
                    Object var7_8 = null;
                    this.hasMoreResults = true;
                    return bl;
                }
                catch (GDSException ge) {
                    throw new FBSQLException(ge);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.hasMoreResults = true;
                throw throwable;
            }
        }
    }

    private void flushFields() throws SQLException {
        for (int i = 0; i < this.isParamSet.length; ++i) {
            FBField field = this.getField(i + 1);
            if (!(field instanceof FBFlushableField)) continue;
            ((FBFlushableField)((Object)field)).flushCachedData();
        }
    }

    public void addBatch() throws SQLException {
        boolean allParamsSet = true;
        for (int i = 0; i < this.isParamSet.length; ++i) {
            allParamsSet &= this.isParamSet[i];
        }
        if (!allParamsSet) {
            throw new FBSQLException("Not all parameters set.");
        }
        XSQLVAR[] oldXsqlvar = this.fixedStmt.getInSqlda().sqlvar;
        XSQLVAR[] newXsqlvar = new XSQLVAR[oldXsqlvar.length];
        for (int i = 0; i < newXsqlvar.length; ++i) {
            newXsqlvar[i] = oldXsqlvar[i].deepCopy();
            FBField field = this.getField(i + 1);
            if (!(field instanceof FBFlushableField)) continue;
            newXsqlvar[i].cachedobject = ((FBFlushableField)((Object)field)).getCachedObject();
        }
        this.batchList.add(newXsqlvar);
    }

    public void clearBatch() throws SQLException {
        this.batchList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            Iterator iter;
            ArrayList<Integer> results;
            boolean commit = false;
            try {
                this.notifyStatementStarted();
                results = new ArrayList<Integer>(this.batchList.size());
                iter = this.batchList.iterator();
                try {}
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    this.clearBatch();
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                this.notifyStatementCompleted(commit);
                throw throwable;
            }
            while (true) {
                XSQLVAR[] vars;
                XSQLVAR[] data;
                if (iter.hasNext()) {
                    data = (XSQLVAR[])iter.next();
                    vars = this.fixedStmt.getInSqlda().sqlvar;
                } else {
                    commit = true;
                    int[] nArray = this.toArray(results);
                    Object var11_11 = null;
                    this.clearBatch();
                    Object var13_13 = null;
                    this.notifyStatementCompleted(commit);
                    return nArray;
                }
                for (int i = 0; i < vars.length; ++i) {
                    FBField field = this.getField(i + 1);
                    if (field instanceof FBFlushableField) {
                        vars[i].copyFrom(data[i], false);
                        ((FBFlushableField)((Object)field)).setCachedObject((FBFlushableField.CachedObject)data[i].cachedobject);
                    } else {
                        vars[i].copyFrom(data[i], true);
                    }
                    this.isParamSet[i] = true;
                }
                try {
                    if (this.internalExecute(this.isExecuteProcedureStatement)) {
                        throw new BatchUpdateException(this.toArray(results));
                    }
                    int updateCount = this.getUpdateCount();
                    results.add(new Integer(updateCount));
                }
                catch (SQLException ex) {
                    throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), this.toArray(results));
                }
            }
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getField(parameterIndex).setCharacterStream(reader, length);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new FBDriverNotCapableException("Only length <= Integer.MAX_VALUE supported");
        }
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        if (!(blob instanceof FBBlob)) {
            FBBlob fbb = new FBBlob(this.gdsHelper, this.blobListener);
            fbb.copyStream(blob.getBinaryStream());
            blob = fbb;
        }
        this.getField(parameterIndex).setBlob((FBBlob)blob);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper, this.blobListener);
        blob.copyStream(inputStream);
        this.setBlob(parameterIndex, blob);
    }

    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        if (!(clob instanceof FBClob)) {
            FBClob fbc = new FBClob(new FBBlob(this.gdsHelper, this.blobListener));
            fbc.copyCharacterStream(clob.getCharacterStream());
            clob = fbc;
        }
        this.getField(parameterIndex).setClob((FBClob)clob);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        FBClob clob = new FBClob(new FBBlob(this.gdsHelper, this.blobListener));
        clob.copyCharacterStream(reader);
        this.setClob(parameterIndex, clob);
    }

    public void setArray(int i, Array x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new FBResultSetMetaData(this.fixedStmt.getOutSqlda().sqlvar, this.gdsHelper);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setDate(x, cal);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setTime(x, cal);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setTimestamp(x, cal);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    protected void prepareFixedStatement(String sql, boolean describeBind) throws GDSException, SQLException {
        super.prepareFixedStatement(sql, describeBind);
        XSQLDA inSqlda = this.fixedStmt.getInSqlda();
        if (!describeBind && inSqlda == null) {
            inSqlda = new XSQLDA();
            inSqlda.sqln = 0;
            inSqlda.sqlvar = new XSQLVAR[0];
        }
        this.isParamSet = new boolean[inSqlda.sqln];
        this.fields = new FBField[inSqlda.sqln];
        for (int i = 0; i < this.isParamSet.length; ++i) {
            final int fieldPos = i;
            FieldDataProvider dataProvider = new FieldDataProvider(){

                public byte[] getFieldData() {
                    return AbstractPreparedStatement.this.getXsqlvar((int)(fieldPos + 1)).sqldata;
                }

                public void setFieldData(byte[] data) {
                    AbstractPreparedStatement.this.getXsqlvar((int)(fieldPos + 1)).sqldata = data;
                }
            };
            this.fields[i] = FBField.createField(this.getXsqlvar(i + 1), dataProvider, this.gdsHelper, false);
            if (!(this.fields[i] instanceof FBWorkaroundStringField)) continue;
            ((FBWorkaroundStringField)this.fields[i]).setTrimString(this.trimStrings);
        }
        this.isExecuteProcedureStatement = this.fixedStmt.getStatementType() == 8;
    }

    public String getExecutionPlan() throws FBSQLException {
        return super.getExecutionPlan();
    }

    public int getStatementType() throws FBSQLException {
        return super.getStatementType();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new FBParameterMetaData(this.fixedStmt.getInSqlda().sqlvar, this.gdsHelper);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    public int executeUpdate(String sql) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    public boolean execute(String sql) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    public void addBatch(String sql) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    public int executeUpdate(String sql, int[] columnIndex) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }
}

