/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBEscapedParser;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdRowUpdater;
import org.firebirdsql.jdbc.FirebirdStatement;
import org.firebirdsql.jdbc.Synchronizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStatement
implements FirebirdStatement,
Synchronizable {
    protected GDSHelper gdsHelper;
    protected FBObjectListener.StatementListener statementListener;
    protected AbstractIscStmtHandle fixedStmt;
    private FBResultSet currentRs;
    private boolean closed;
    protected boolean completed = true;
    private boolean escapedProcessing = true;
    private volatile boolean closeOnCompletion = false;
    protected SQLWarning firstWarning = null;
    protected boolean isResultSet;
    protected boolean hasMoreResults;
    protected int maxRows = 0;
    protected int fetchSize = 0;
    private int maxFieldSize = 0;
    private int queryTimeout = 0;
    private String cursorName;
    private int rsConcurrency;
    private int rsType;
    private int rsHoldability = 2;
    private FBObjectListener.ResultSetListener resultSetListener = new RSListener();
    private AbstractConnection connection;
    private static final int INSERTED_ROWS_COUNT = 1;
    private static final int UPDATED_ROWS_COUNT = 2;
    private static final int DELETED_ROWS_COUNT = 3;
    private LinkedList batchList = new LinkedList();

    protected AbstractStatement(GDSHelper c, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener) throws SQLException {
        this.gdsHelper = c;
        this.rsConcurrency = rsConcurrency;
        this.rsType = rsType;
        this.rsHoldability = rsHoldability;
        this.statementListener = statementListener;
        this.connection = statementListener != null ? statementListener.getConnection() : null;
        this.closed = false;
    }

    String getCursorName() {
        return this.cursorName;
    }

    @Override
    public boolean isValid() {
        return !this.closed && (this.fixedStmt == null || this.fixedStmt.isValid());
    }

    @Override
    public Object getSynchronizationObject() throws SQLException {
        if (this.connection == null) {
            return this;
        }
        if (this.connection.getAutoCommit()) {
            return this.connection;
        }
        return this;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
    }

    public void completeStatement() throws SQLException {
        this.completeStatement(CompletionReason.OTHER);
    }

    public void completeStatement(CompletionReason reason) throws SQLException {
        if (this.currentRs != null && (reason != CompletionReason.COMMIT || this.currentRs.getHoldability() == 2)) {
            this.closeResultSet(false);
        }
        if (!this.completed) {
            this.notifyStatementCompleted();
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        Object syncObject;
        this.checkValidity();
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            try {
                if (!this.internalExecute(sql)) {
                    throw new FBSQLException("Query did not return a result set.", "07005");
                }
                return this.getResultSet();
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
    }

    protected void notifyStatementStarted() throws SQLException {
        this.notifyStatementStarted(true);
    }

    protected void notifyStatementStarted(boolean closeResultSet) throws SQLException {
        if (closeResultSet) {
            this.closeResultSet(false);
        }
        this.statementListener.executionStarted(this);
        this.completed = false;
    }

    protected void notifyStatementCompleted() throws SQLException {
        this.notifyStatementCompleted(true);
    }

    protected void notifyStatementCompleted(boolean success) throws SQLException {
        this.completed = true;
        this.statementListener.statementCompleted(this, success);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        Object syncObject;
        this.checkValidity();
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            try {
                if (this.internalExecute(sql)) {
                    throw new FBSQLException("Update statement returned results.");
                }
                int n = this.getUpdateCount();
                return n;
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            finally {
                this.notifyStatementCompleted();
            }
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.execute(sql, autoGeneratedKeys);
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.execute(sql, columnIndexes);
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.execute(sql, columnNames);
        return this.getUpdateCount();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkValidity();
        if (autoGeneratedKeys == 1) {
            this.connection.checkAutoGeneratedKeysSupport();
        }
        AbstractConnection abstractConnection = this.connection;
        abstractConnection.getClass();
        AbstractConnection.GeneratedKeysQuery query = abstractConnection.new AbstractConnection.GeneratedKeysQuery(sql, autoGeneratedKeys);
        return this.execute(query.getQueryString());
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkValidity();
        this.connection.checkAutoGeneratedKeysSupport();
        AbstractConnection abstractConnection = this.connection;
        abstractConnection.getClass();
        AbstractConnection.GeneratedKeysQuery query = abstractConnection.new AbstractConnection.GeneratedKeysQuery(sql, columnIndexes);
        return this.execute(query.getQueryString());
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkValidity();
        this.connection.checkAutoGeneratedKeysSupport();
        AbstractConnection abstractConnection = this.connection;
        abstractConnection.getClass();
        AbstractConnection.GeneratedKeysQuery query = abstractConnection.new AbstractConnection.GeneratedKeysQuery(sql, columnNames);
        return this.execute(query.getQueryString());
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkValidity();
        ResultSet rs = this.getResultSet();
        if (rs == null) {
            rs = new FBResultSet(new XSQLVAR[0], new ArrayList());
        }
        return rs;
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean ignoreAlreadyClosed) throws SQLException {
        Object syncObject;
        if (this.isClosed()) {
            if (ignoreAlreadyClosed) {
                return;
            }
            throw new FBSQLException("This statement is already closed.");
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            if (this.fixedStmt != null) {
                try {
                    try {
                        this.closeResultSet(false);
                    }
                    finally {
                        if (this.fixedStmt.isValid()) {
                            this.gdsHelper.closeStatement(this.fixedStmt, true);
                        }
                    }
                }
                catch (GDSException ge) {
                    throw new FBSQLException(ge);
                }
                finally {
                    this.fixedStmt = null;
                }
            }
        }
        this.closed = true;
        this.statementListener.statementClosed(this);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw new FBSQLException("Can't set max field size negative", "HY009");
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new FBSQLException("Max rows can't be less than 0", "HY009");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapedProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new FBSQLException("Can't set query timeout negative", "HY009");
        }
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.gdsHelper.cancelOperation();
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.cursorName = name;
    }

    boolean isUpdatableCursor() {
        return this.cursorName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        Object syncObject;
        this.checkValidity();
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            boolean hasResultSet = false;
            try {
                try {
                    hasResultSet = this.internalExecute(sql);
                }
                catch (GDSException ge) {
                    throw new FBSQLException(ge);
                }
            }
            finally {
                if (!hasResultSet) {
                    this.notifyStatementCompleted();
                }
            }
            return hasResultSet;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(false);
    }

    public ResultSet getResultSet(boolean metaDataQuery) throws SQLException {
        try {
            if (this.cursorName != null) {
                this.gdsHelper.setCursorName(this.fixedStmt, this.cursorName);
            }
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
        if (this.currentRs != null) {
            throw new FBSQLException("Only one resultset at a time/statement.");
        }
        if (this.fixedStmt == null) {
            throw new FBSQLException("No statement was executed.");
        }
        if (this.isResultSet) {
            this.currentRs = new FBResultSet(this.gdsHelper, this, this.fixedStmt, this.resultSetListener, metaDataQuery, this.rsType, this.rsConcurrency, this.rsHoldability, false);
            return this.currentRs;
        }
        return null;
    }

    @Override
    public boolean hasOpenResultSet() {
        return this.currentRs != null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isResultSet || !this.hasMoreResults) {
            return -1;
        }
        try {
            this.gdsHelper.getSqlCounts(this.fixedStmt);
            int insCount = this.fixedStmt.getInsertCount();
            int updCount = this.fixedStmt.getUpdateCount();
            int delCount = this.fixedStmt.getDeleteCount();
            int resCount = updCount > delCount ? updCount : delCount;
            int n = resCount = resCount > insCount ? resCount : insCount;
            return n;
        }
        catch (GDSException ge) {
            throw new FBSQLException(ge);
        }
        finally {
            this.hasMoreResults = false;
        }
    }

    private int getChangedRowsCount(int type) throws SQLException {
        if (this.isResultSet || !this.hasMoreResults) {
            return -1;
        }
        try {
            this.gdsHelper.getSqlCounts(this.fixedStmt);
            switch (type) {
                case 1: {
                    return this.fixedStmt.getInsertCount();
                }
                case 2: {
                    return this.fixedStmt.getUpdateCount();
                }
                case 3: {
                    return this.fixedStmt.getDeleteCount();
                }
            }
            throw new IllegalArgumentException("Specified type is unknown.");
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public int getDeletedRowsCount() throws SQLException {
        return this.getChangedRowsCount(3);
    }

    @Override
    public int getInsertedRowsCount() throws SQLException {
        return this.getChangedRowsCount(1);
    }

    @Override
    public int getUpdatedRowsCount() throws SQLException {
        return this.getChangedRowsCount(2);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public boolean getMoreResults(int mode) throws SQLException {
        boolean closeResultSet;
        this.hasMoreResults = false;
        boolean bl = closeResultSet = mode == 3 || mode == 1;
        if (closeResultSet && this.currentRs != null) {
            this.closeResultSet(true);
        }
        return this.hasMoreResults;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new FBDriverNotCapableException();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new FBSQLException("Can't set negative fetch size", "HY009");
        }
        if (this.maxRows > 0 && rows > this.maxRows) {
            throw new FBSQLException("Can't set fetch size > maxRows", "HY009");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.rsType;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.rsHoldability;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.batchList.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkValidity();
        if (this.statementListener.getConnection().getAutoCommit()) {
            this.addWarning(new SQLWarning("Batch updates should be run with auto-commit disabled.", "1000"));
        }
        Object syncObject = this.getSynchronizationObject();
        this.notifyStatementStarted();
        Object object = syncObject;
        synchronized (object) {
            boolean success = false;
            try {
                int[] nArray;
                LinkedList<Integer> responses = new LinkedList<Integer>();
                try {
                    for (String sql : this.batchList) {
                        try {
                            boolean hasResultSet = this.internalExecute(sql);
                            if (hasResultSet) {
                                throw new BatchUpdateException(this.toArray(responses));
                            }
                            responses.add(new Integer(this.getUpdateCount()));
                        }
                        catch (GDSException ge) {
                            throw new BatchUpdateException(ge.getMessage(), "HY000", ge.getFbErrorCode(), this.toArray(responses));
                        }
                    }
                    success = true;
                    nArray = this.toArray(responses);
                }
                catch (Throwable throwable) {
                    this.clearBatch();
                    throw throwable;
                }
                this.clearBatch();
                return nArray;
            }
            finally {
                this.notifyStatementCompleted(success);
            }
        }
    }

    protected int[] toArray(Collection list) {
        int[] result = new int[list.size()];
        int counter = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            result[counter++] = (Integer)iter.next();
        }
        return result;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkValidity();
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeResultSet(boolean notifyListener) throws SQLException {
        block7: {
            boolean wasCompleted = this.completed;
            try {
                if (this.currentRs == null) break block7;
                try {
                    this.currentRs.close(notifyListener);
                }
                finally {
                    this.currentRs = null;
                }
            }
            finally {
                if (notifyListener && !wasCompleted) {
                    this.statementListener.statementCompleted(this);
                }
            }
        }
    }

    public void forgetResultSet() {
        this.currentRs = null;
        if (this.fixedStmt != null) {
            this.fixedStmt.clearRows();
        }
    }

    @Override
    public ResultSet getCurrentResultSet() throws SQLException {
        return this.currentRs;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkValidity();
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkValidity();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new FBDriverNotCapableException();
        }
        return iface.cast(this);
    }

    @Override
    public void closeOnCompletion() {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() {
        return this.closeOnCompletion;
    }

    protected boolean isExecuteProcedureStatement(String sql) throws SQLException {
        String trimmedSql = this.nativeSQL(sql).trim();
        return trimmedSql.startsWith("EXECUTE");
    }

    protected boolean internalExecute(String sql) throws GDSException, SQLException {
        if (this.closed) {
            throw new FBSQLException("Statement is already closed.");
        }
        this.prepareFixedStatement(sql, false);
        this.gdsHelper.executeStatement(this.fixedStmt, this.fixedStmt.getStatementType() == 8);
        this.hasMoreResults = true;
        this.isResultSet = this.fixedStmt.getOutSqlda().sqld > 0;
        return this.isResultSet;
    }

    protected void prepareFixedStatement(String sql, boolean describeBind) throws GDSException, SQLException {
        if (this.fixedStmt == null) {
            this.fixedStmt = this.gdsHelper.allocateStatement();
        }
        if (!this.fixedStmt.isValid()) {
            throw new FBSQLException("Corresponding connection is not valid.", "08007");
        }
        this.gdsHelper.prepareStatement(this.fixedStmt, this.escapedProcessing ? this.nativeSQL(sql) : sql, describeBind);
    }

    protected void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            SQLWarning lastWarning = this.firstWarning;
            while (lastWarning.getNextWarning() != null) {
                lastWarning = lastWarning.getNextWarning();
            }
            lastWarning.setNextWarning(warning);
        }
    }

    protected String nativeSQL(String sql) throws SQLException {
        DatabaseParameterBuffer dpb = this.gdsHelper.getDatabaseParameterBuffer();
        int mode = 0;
        if (dpb.hasArgument(134)) {
            mode = 1;
        }
        return new FBEscapedParser(mode).parse(sql);
    }

    String getExecutionPlan() throws FBSQLException {
        this.populateStatementInfo();
        return this.fixedStmt.getExecutionPlan();
    }

    @Override
    public String getLastExecutionPlan() throws SQLException {
        this.checkValidity();
        if (this.fixedStmt == null) {
            throw new FBSQLException("No statement was executed, plan cannot be obtained.");
        }
        return this.getExecutionPlan();
    }

    int getStatementType() throws FBSQLException {
        this.populateStatementInfo();
        return this.fixedStmt.getStatementType();
    }

    private void populateStatementInfo() throws FBSQLException {
        if (this.fixedStmt.getExecutionPlan() == null) {
            try {
                this.gdsHelper.populateStatementInfo(this.fixedStmt);
            }
            catch (GDSException ex) {
                throw new FBSQLException(ex);
            }
        }
    }

    protected void checkValidity() throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("Statement is already closed.", "26000");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum CompletionReason {
        COMMIT,
        OTHER;

    }

    private class RSListener
    implements FBObjectListener.ResultSetListener {
        private RSListener() {
        }

        public void resultSetClosed(ResultSet rs) throws SQLException {
            AbstractStatement.this.currentRs = null;
            AbstractStatement.this.notifyStatementCompleted();
            if (AbstractStatement.this.closeOnCompletion) {
                AbstractStatement.this.close();
            }
        }

        public void allRowsFetched(ResultSet rs) throws SQLException {
            if (AbstractStatement.this.statementListener.getConnection().getAutoCommit()) {
                rs.close();
            }
        }

        public void executionCompleted(FirebirdRowUpdater updater, boolean success) throws SQLException {
            AbstractStatement.this.notifyStatementCompleted(success);
        }

        public void executionStarted(FirebirdRowUpdater updater) throws SQLException {
            AbstractStatement.this.notifyStatementStarted(false);
        }
    }
}

