/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.FBBlobInputStream;
import org.firebirdsql.jdbc.FBBlobOutputStream;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.jdbc.Synchronizable;

public class FBBlob
implements FirebirdBlob,
Synchronizable {
    public static final boolean SEGMENTED = true;
    public static final int READ_FULLY_BUFFER_SIZE = 32768;
    final int bufferlength;
    boolean isNew;
    long blob_id;
    final GDSHelper gdsHelper;
    private final FBObjectListener.BlobListener blobListener;
    Collection inputStreams = new HashSet();
    private FBBlobOutputStream blobOut = null;
    public static final byte[] BLOB_LENGTH_REQUEST = new byte[]{6};

    private FBBlob(GDSHelper c, boolean isNew, FBObjectListener.BlobListener blobListener) {
        this.gdsHelper = c;
        this.isNew = isNew;
        this.bufferlength = c.getBlobBufferLength();
        this.blobListener = blobListener;
    }

    public FBBlob(GDSHelper c, FBObjectListener.BlobListener blobListener) {
        this(c, true, blobListener);
    }

    public FBBlob(GDSHelper c) {
        this(c, null);
    }

    public FBBlob(GDSHelper c, long blob_id, FBObjectListener.BlobListener blobListener) {
        this(c, false, blobListener);
        this.blob_id = blob_id;
    }

    public FBBlob(GDSHelper c, long blob_id) {
        this(c, blob_id, null);
    }

    public Object getSynchronizationObject() {
        return this.gdsHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            IOException error = null;
            Iterator i = this.inputStreams.iterator();
            while (i.hasNext()) {
                try {
                    ((FBBlobInputStream)i.next()).close();
                }
                catch (IOException ex) {
                    error = ex;
                }
            }
            this.inputStreams.clear();
            if (error != null) {
                throw error;
            }
        }
    }

    public void free() throws SQLException {
        try {
            this.close();
        }
        catch (IOException ex) {
            throw new FBSQLException(ex);
        }
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    /*
     * Exception decompiling
     */
    public byte[] getInfo(byte[] items, int buffer_length) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long length() throws SQLException {
        byte[] info = this.getInfo(BLOB_LENGTH_REQUEST, 20);
        return this.interpretLength(info, 0);
    }

    public static long interpretLength(GDSHelper gdsHelper, byte[] info, int position) throws SQLException {
        if (info[position] != 6) {
            throw new FBSQLException("Length is not available.");
        }
        int dataLength = gdsHelper.iscVaxInteger(info, position + 1, 2);
        return gdsHelper.iscVaxInteger(info, position + 3, dataLength);
    }

    long interpretLength(byte[] info, int position) throws SQLException {
        return FBBlob.interpretLength(this.gdsHelper, info, position);
    }

    public boolean isSegmented() throws SQLException {
        byte[] info = this.getInfo(new byte[]{7}, 20);
        if (info[0] != 7) {
            throw new FBSQLException("Cannot determine BLOB type");
        }
        int dataLength = this.gdsHelper.iscVaxInteger(info, 1, 2);
        int type = this.gdsHelper.iscVaxInteger(info, 3, dataLength);
        return type == 0;
    }

    public FirebirdBlob detach() throws SQLException {
        return new FBBlob(this.gdsHelper, this.blob_id, this.blobListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(long pos, int length) throws SQLException {
        Object syncObject;
        if (pos < 1L) {
            throw new FBSQLException("Blob position should be >= 1");
        }
        if (pos > Integer.MAX_VALUE) {
            throw new FBSQLException("Blob position is limited to 2^31 - 1 due to isc_seek_blob limitations.", "HY009");
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            if (this.blobListener != null) {
                this.blobListener.executionStarted(this);
            }
            try {
                try {
                    byte[] byArray;
                    FirebirdBlob.BlobInputStream in = (FirebirdBlob.BlobInputStream)((Object)this.getBinaryStream());
                    try {
                        byte[] result = new byte[length];
                        if (pos != 1L) {
                            in.seek((int)pos - 1);
                        }
                        in.readFully(result);
                        byArray = result;
                        Object var10_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_10 = null;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                    Object var12_11 = null;
                    if (this.blobListener == null) return byArray;
                    this.blobListener.executionCompleted(this);
                    return byArray;
                }
                catch (IOException ex) {
                    throw new FBSQLException(ex);
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (this.blobListener == null) throw throwable;
                this.blobListener.executionCompleted(this);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            FBBlobInputStream blobstream = new FBBlobInputStream(this);
            this.inputStreams.add(blobstream);
            return blobstream;
        }
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void truncate(long param1) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public int setBytes(long param1, byte[] param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public int setBytes(long param1, byte[] param2, int param3, int param4) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (this.blobListener != null) {
            this.blobListener.executionStarted(this);
        }
        if (this.blobOut != null) {
            throw new FBSQLException("Only one blob output stream open at a time!");
        }
        if (pos < 1L) {
            throw new FBSQLException("You can't start before the beginning of the blob", "HY009");
        }
        if (this.isNew && pos > 1L) {
            throw new FBSQLException("Previous value was null, you must start at position 1", "HY009");
        }
        this.blobOut = new FBBlobOutputStream(this);
        if (pos > 1L) {
            throw new FBDriverNotCapableException("Offset start positions are not yet supported.");
        }
        return this.blobOut;
    }

    public long getBlobId() throws SQLException {
        if (this.isNew) {
            throw new FBSQLException("No Blob ID is available in new Blob object.");
        }
        return this.blob_id;
    }

    void setBlobId(long blob_id) {
        this.blob_id = blob_id;
        this.isNew = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyBytes(byte[] bytes, int pos, int len) throws SQLException {
        OutputStream out = this.setBinaryStream(1L);
        try {
            try {
                out.write(bytes, pos, len);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                out.close();
                throw throwable;
            }
            out.close();
            {
            }
        }
        catch (IOException ex) {
            throw new FBSQLException(ex);
        }
    }

    public void copyStream(InputStream inputStream, int length) throws SQLException {
        OutputStream os = this.setBinaryStream(1L);
        byte[] buffer = new byte[Math.min(this.bufferlength, length)];
        try {
            int chunk;
            while (length > 0 && (chunk = inputStream.read(buffer, 0, length < this.bufferlength ? length : this.bufferlength)) != -1) {
                os.write(buffer, 0, chunk);
                length -= chunk;
            }
            os.flush();
            os.close();
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    public void copyStream(InputStream inputStream) throws SQLException {
        OutputStream os = this.setBinaryStream(1L);
        try {
            int chunk = 0;
            byte[] buffer = new byte[this.bufferlength];
            while ((chunk = inputStream.read(buffer)) != -1) {
                os.write(buffer, 0, chunk);
            }
            os.flush();
            os.close();
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    public void copyCharacterStream(Reader inputStream, int length, String encoding) throws SQLException {
        OutputStream os = this.setBinaryStream(1L);
        try {
            OutputStreamWriter osw = encoding != null ? new OutputStreamWriter(os, encoding) : new OutputStreamWriter(os);
            char[] buffer = new char[Math.min(this.bufferlength, length)];
            try {
                int chunk;
                while (length > 0 && (chunk = inputStream.read(buffer, 0, length < this.bufferlength ? length : this.bufferlength)) != -1) {
                    osw.write(buffer, 0, chunk);
                    length -= chunk;
                }
                osw.flush();
                os.flush();
                os.close();
            }
            catch (IOException ioe) {
                throw new FBSQLException(ioe);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new FBSQLException("Cannot set character stream because the unsupported encoding is detected in the JVM: " + encoding + ". Please report this to the driver developers.");
        }
    }
}

