/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBSQLException;

public class FBClob
implements Clob {
    private FBBlob wrappedBlob;

    public FBClob(FBBlob blob) {
        this.wrappedBlob = blob;
    }

    public long length() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void truncate(long param1) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSubString(long pos, int length) throws SQLException {
        String string;
        Reader reader = this.getCharacterStream();
        try {
            try {
                int n;
                for (long toSkip = pos - 1L; toSkip > 0L; toSkip -= reader.skip(toSkip)) {
                }
                char[] buffer = new char[1024];
                StringBuffer stringBuffer = new StringBuffer();
                while (length > 0 && (n = reader.read(buffer, 0, Math.min(length, buffer.length))) != -1) {
                    stringBuffer.append(buffer, 0, Math.min(n, length));
                    length -= n;
                }
                string = stringBuffer.toString();
                Object var12_10 = null;
            }
            catch (IOException e) {
                throw new FBSQLException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new FBSQLException(e2);
            }
        }
        try {}
        catch (IOException e2) {
            throw new FBSQLException(e2);
        }
        reader.close();
        return string;
    }

    public Reader getCharacterStream() throws SQLException {
        String encoding = this.getWrappedBlob().gdsHelper.getJavaEncoding();
        InputStream inputStream = this.wrappedBlob.getBinaryStream();
        if (encoding == null) {
            return new InputStreamReader(inputStream);
        }
        try {
            return new InputStreamReader(this.wrappedBlob.getBinaryStream(), encoding);
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        InputStream inputStream = null;
        if (this.wrappedBlob != null) {
            inputStream = this.wrappedBlob.getBinaryStream();
        }
        return inputStream;
    }

    public long position(String searchstr, long start) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public long position(Clob searchstr, long start) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public int setString(long start, String searchString) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public int setString(long param1, String param2, int param3, int param4) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        return this.wrappedBlob.setBinaryStream(pos);
    }

    public Writer setCharacterStream(long position) throws SQLException {
        String encoding = this.wrappedBlob.gdsHelper.getJavaEncoding();
        OutputStream outputStream = this.wrappedBlob.setBinaryStream(position);
        if (encoding == null) {
            return new OutputStreamWriter(outputStream);
        }
        try {
            return new OutputStreamWriter(outputStream, encoding);
        }
        catch (UnsupportedEncodingException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    public void free() throws SQLException {
        this.wrappedBlob.free();
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        InputStream inputStream = this.wrappedBlob.getBinaryStream(pos, length);
        String encoding = this.getWrappedBlob().gdsHelper.getJavaEncoding();
        if (encoding == null) {
            return new InputStreamReader(inputStream);
        }
        try {
            return new InputStreamReader(inputStream, encoding);
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    public void copyCharacterStream(Reader characterStream) throws SQLException {
        Writer writer = this.setCharacterStream(1L);
        try {
            int chunk = 0;
            char[] buffer = new char[1024];
            while ((chunk = characterStream.read(buffer)) != -1) {
                writer.write(buffer, 0, chunk);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    public FBBlob getWrappedBlob() throws SQLException {
        return this.wrappedBlob;
    }
}

