/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBStatementFetcher;
import org.firebirdsql.jdbc.Synchronizable;

public class FBUpdatableCursorFetcher
extends FBStatementFetcher {
    FBUpdatableCursorFetcher(GDSHelper gdsHelper, Synchronizable syncProvider, AbstractIscStmtHandle stmth, FBObjectListener.FetcherListener fetcherListener, int maxRows, int fetchSize) throws SQLException {
        super(gdsHelper, syncProvider, stmth, fetcherListener, maxRows, fetchSize);
    }

    public boolean next() throws SQLException {
        boolean maxRowReached;
        if (this.isBeforeFirst()) {
            this.setIsBeforeFirst(false);
            this.setIsEmpty(false);
            this.setIsFirst(true);
            this.setRowNum(this.getRowNum() + 1);
            this.fetcherListener.rowChanged(this, this.getNextRow());
            return true;
        }
        this.setIsBeforeFirst(false);
        this.setIsFirst(false);
        this.setIsLast(false);
        this.setIsAfterLast(false);
        if (this.isEmpty()) {
            return false;
        }
        if (this.getNextRow() == null || this.maxRows != 0 && this.getRowNum() == this.maxRows) {
            this.setIsAfterLast(true);
            this.setRowNum(0);
            return false;
        }
        this.fetch();
        boolean bl = maxRowReached = this.maxRows != 0 && this.getRowNum() == this.maxRows;
        if (this.getNextRow() == null || maxRowReached) {
            this.setIsAfterLast(true);
            return false;
        }
        this.fetcherListener.rowChanged(this, this.getNextRow());
        this.setRowNum(this.getRowNum() + 1);
        return true;
    }

    public boolean isLast() throws SQLException {
        throw new FBDriverNotCapableException("isLast() operation is not defined in case of updatable cursors, because server cannot determine cursor position without additional fetch.");
    }
}

