/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public class FBNullField
extends FBField {
    private static final String NULL_CONVERSION_ERROR = "Received non-NULL value of a NULL field.";
    private static final byte[] DUMMY_OBJECT = new byte[0];

    public FBNullField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    public Object getObject() throws SQLException {
        if (this.getFieldData() != null) {
            throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
        }
        return OBJECT_NULL_VALUE;
    }

    public void setObject(Object value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.setFieldData(DUMMY_OBJECT);
        }
    }

    public byte getByte() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public short getShort() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public int getInt() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public long getLong() throws SQLException {
        if (this.getFieldData() == null) {
            return 0L;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public BigDecimal getBigDecimal() throws SQLException {
        if (this.getFieldData() == null) {
            return BIGDECIMAL_NULL_VALUE;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public float getFloat() throws SQLException {
        if (this.getFieldData() == null) {
            return 0.0f;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public double getDouble() throws SQLException {
        if (this.getFieldData() == null) {
            return 0.0;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public boolean getBoolean() throws SQLException {
        if (this.getFieldData() == null) {
            return false;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public String getString() throws SQLException {
        if (this.getFieldData() == null) {
            return STRING_NULL_VALUE;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.getFieldData() == null) {
            return STREAM_NULL_VALUE;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public InputStream getUnicodeStream() throws SQLException {
        if (this.getFieldData() == null) {
            return STREAM_NULL_VALUE;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.getFieldData() == null) {
            return STREAM_NULL_VALUE;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public byte[] getBytes() throws SQLException {
        if (this.getFieldData() == null) {
            return BYTES_NULL_VALUE;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public Date getDate(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return DATE_NULL_VALUE;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public Date getDate() throws SQLException {
        if (this.getFieldData() == null) {
            return DATE_NULL_VALUE;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public Time getTime(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return TIME_NULL_VALUE;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public Time getTime() throws SQLException {
        if (this.getFieldData() == null) {
            return TIME_NULL_VALUE;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public Timestamp getTimestamp() throws SQLException {
        if (this.getFieldData() == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        throw (SQLException)FBNullField.createException(NULL_CONVERSION_ERROR);
    }

    public void setByte(byte value) throws SQLException {
        this.setObject(DUMMY_OBJECT);
    }

    public void setShort(short value) throws SQLException {
        this.setObject(DUMMY_OBJECT);
    }

    public void setInteger(int value) throws SQLException {
        this.setObject(DUMMY_OBJECT);
    }

    public void setLong(long value) throws SQLException {
        this.setObject(DUMMY_OBJECT);
    }

    public void setFloat(float value) throws SQLException {
        this.setObject(DUMMY_OBJECT);
    }

    public void setDouble(double value) throws SQLException {
        this.setObject(DUMMY_OBJECT);
    }

    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == BIGDECIMAL_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setObject(DUMMY_OBJECT);
    }

    public void setBoolean(boolean value) throws SQLException {
        this.setObject(DUMMY_OBJECT);
    }

    public void setAsciiStream(InputStream in, int length) throws SQLException {
        this.setObject(DUMMY_OBJECT);
    }

    public void setUnicodeStream(InputStream in, int length) throws SQLException {
        this.setObject(DUMMY_OBJECT);
    }

    public void setBinaryStream(InputStream in, int length) throws SQLException {
        if (in == STREAM_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setObject(DUMMY_OBJECT);
    }

    public void setCharacterStream(Reader in, int length) throws SQLException {
        if (in == READER_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setObject(DUMMY_OBJECT);
    }

    public void setBytes(byte[] value) throws SQLException {
        if (value == BYTES_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setObject(DUMMY_OBJECT);
    }

    public void setDate(Date value, Calendar cal) throws SQLException {
        if (value == DATE_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setObject(DUMMY_OBJECT);
    }

    public void setDate(Date value) throws SQLException {
        if (value == DATE_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setObject(DUMMY_OBJECT);
    }

    public void setTime(Time value, Calendar cal) throws SQLException {
        if (value == TIME_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setObject(DUMMY_OBJECT);
    }

    public void setTime(Time value) throws SQLException {
        if (value == TIME_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setObject(DUMMY_OBJECT);
    }

    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setObject(DUMMY_OBJECT);
    }

    public void setTimestamp(Timestamp value) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setObject(DUMMY_OBJECT);
    }

    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setObject(DUMMY_OBJECT);
    }
}

