/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public class FBStringField
extends FBField {
    static final String SHORT_TRUE = "Y";
    static final String SHORT_FALSE = "N";
    static final String LONG_TRUE = "true";
    static final String LONG_FALSE = "false";
    static final String SHORT_TRUE_2 = "T";
    static final String SHORT_TRUE_3 = "1";
    protected int possibleCharLength;
    protected int bytesPerCharacter = 1;

    FBStringField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
        this.possibleCharLength = field.sqllen / this.bytesPerCharacter;
    }

    public void setConnection(GDSHelper gdsHelper) {
        super.setConnection(gdsHelper);
        this.bytesPerCharacter = EncodingFactory.getIscEncodingSize(this.iscEncoding);
        this.possibleCharLength = this.field.sqllen / this.bytesPerCharacter;
    }

    public byte getByte() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        try {
            return Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBStringField.createException(BYTE_CONVERSION_ERROR + " " + this.getString().trim()).fillInStackTrace();
        }
    }

    public short getShort() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        try {
            return Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBStringField.createException(SHORT_CONVERSION_ERROR + " " + this.getString().trim()).fillInStackTrace();
        }
    }

    public int getInt() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        try {
            return Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBStringField.createException(INT_CONVERSION_ERROR + " " + this.getString().trim()).fillInStackTrace();
        }
    }

    public long getLong() throws SQLException {
        if (this.getFieldData() == null) {
            return 0L;
        }
        try {
            return Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBStringField.createException(LONG_CONVERSION_ERROR + " " + this.getString().trim()).fillInStackTrace();
        }
    }

    public BigDecimal getBigDecimal() throws SQLException {
        if (this.getFieldData() == null) {
            return BIGDECIMAL_NULL_VALUE;
        }
        return new BigDecimal(this.getString().trim());
    }

    public float getFloat() throws SQLException {
        if (this.getFieldData() == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.getString().trim());
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBStringField.createException(FLOAT_CONVERSION_ERROR + " " + this.getString().trim()).fillInStackTrace();
        }
    }

    public double getDouble() throws SQLException {
        if (this.getFieldData() == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.getString().trim());
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBStringField.createException(DOUBLE_CONVERSION_ERROR + " " + this.getString().trim()).fillInStackTrace();
        }
    }

    public boolean getBoolean() throws SQLException {
        if (this.getFieldData() == null) {
            return false;
        }
        String trimmedValue = this.getString().trim();
        return trimmedValue.equalsIgnoreCase(LONG_TRUE) || trimmedValue.equalsIgnoreCase(SHORT_TRUE) || trimmedValue.equalsIgnoreCase(SHORT_TRUE_2) || trimmedValue.equalsIgnoreCase(SHORT_TRUE_3);
    }

    public String getString() throws SQLException {
        if (this.getFieldData() == null) {
            return STRING_NULL_VALUE;
        }
        return this.field.decodeString(this.getFieldData(), this.javaEncoding, this.mappingPath);
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.getFieldData() == null) {
            return STREAM_NULL_VALUE;
        }
        return new ByteArrayInputStream(this.getFieldData());
    }

    public InputStream getUnicodeStream() throws SQLException {
        if (this.getFieldData() == null) {
            return STREAM_NULL_VALUE;
        }
        return this.getBinaryStream();
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.getFieldData() == null) {
            return STREAM_NULL_VALUE;
        }
        return this.getBinaryStream();
    }

    public byte[] getBytes() throws SQLException {
        if (this.getFieldData() == null) {
            return BYTES_NULL_VALUE;
        }
        return this.getFieldData();
    }

    public Date getDate(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return DATE_NULL_VALUE;
        }
        return this.field.decodeDate(this.getDate(), cal);
    }

    public Date getDate() throws SQLException {
        if (this.getFieldData() == null) {
            return DATE_NULL_VALUE;
        }
        return Date.valueOf(this.getString().trim());
    }

    public Time getTime(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return TIME_NULL_VALUE;
        }
        return this.field.decodeTime(this.getTime(), cal, this.isInvertTimeZone());
    }

    public Time getTime() throws SQLException {
        if (this.getFieldData() == null) {
            return TIME_NULL_VALUE;
        }
        return Time.valueOf(this.getString().trim());
    }

    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        return this.field.decodeTimestamp(this.getTimestamp(), cal, this.isInvertTimeZone());
    }

    public Timestamp getTimestamp() throws SQLException {
        if (this.getFieldData() == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        return Timestamp.valueOf(this.getString().trim());
    }

    public void setByte(byte value) throws SQLException {
        this.setString(Byte.toString(value));
    }

    public void setShort(short value) throws SQLException {
        this.setString(Short.toString(value));
    }

    public void setInteger(int value) throws SQLException {
        this.setString(Integer.toString(value));
    }

    public void setLong(long value) throws SQLException {
        this.setString(Long.toString(value));
    }

    public void setFloat(float value) throws SQLException {
        this.setString(Float.toString(value));
    }

    public void setDouble(double value) throws SQLException {
        this.setString(Double.toString(value));
    }

    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == BIGDECIMAL_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setString(value.toString());
    }

    public void setBoolean(boolean value) throws SQLException {
        if (this.possibleCharLength > 4) {
            this.setString(value ? LONG_TRUE : LONG_FALSE);
        } else if (this.possibleCharLength >= 1) {
            this.setString(value ? SHORT_TRUE : SHORT_FALSE);
        }
    }

    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeString(value, this.javaEncoding, this.mappingPath));
    }

    public void setAsciiStream(InputStream in, int length) throws SQLException {
        this.setBinaryStream(in, length);
    }

    public void setUnicodeStream(InputStream in, int length) throws SQLException {
        this.setBinaryStream(in, length);
    }

    public void setBinaryStream(InputStream in, int length) throws SQLException {
        if (in == STREAM_NULL_VALUE) {
            this.setNull();
            return;
        }
        if (length > this.field.sqllen) {
            throw new DataTruncation(-1, true, false, length, this.field.sqllen);
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buff = new byte[4096];
            int counter = 0;
            int toRead = length;
            while ((counter = in.read(buff, 0, toRead > buff.length ? buff.length : toRead)) != -1) {
                out.write(buff, 0, counter);
                toRead -= counter;
            }
            this.setBytes(out.toByteArray());
        }
        catch (IOException ioex) {
            throw (SQLException)FBStringField.createException(BINARY_STREAM_CONVERSION_ERROR).fillInStackTrace();
        }
    }

    public void setCharacterStream(Reader in, int length) throws SQLException {
        if (in == READER_NULL_VALUE) {
            this.setNull();
            return;
        }
        try {
            StringWriter out = new StringWriter();
            char[] buff = new char[4096];
            int counter = 0;
            while ((counter = in.read(buff)) != -1) {
                out.write(buff, 0, counter);
            }
            String outString = out.toString();
            this.setString(outString.substring(0, length));
        }
        catch (IOException ioex) {
            throw (SQLException)FBStringField.createException(CHARACTER_STREAM_CONVERSION_ERROR).fillInStackTrace();
        }
    }

    public void setBytes(byte[] value) throws SQLException {
        if (value == BYTES_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(value);
        if (value.length > this.field.sqllen) {
            throw new DataTruncation(-1, true, false, value.length, this.field.sqllen);
        }
    }

    public void setDate(Date value, Calendar cal) throws SQLException {
        if (value == DATE_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setDate(this.field.encodeDate(value, cal));
    }

    public void setDate(Date value) throws SQLException {
        if (value == DATE_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setString(value.toString());
    }

    public void setTime(Time value, Calendar cal) throws SQLException {
        if (value == TIME_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTime(this.field.encodeTime(value, cal, this.isInvertTimeZone()));
    }

    public void setTime(Time value) throws SQLException {
        if (value == TIME_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setString(value.toString());
    }

    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTimestamp(this.field.encodeTimestamp(value, cal, this.isInvertTimeZone()));
    }

    public void setTimestamp(Timestamp value) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setString(value.toString());
    }
}

