/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBTimeField
extends FBField {
    FBTimeField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    public String getString() throws SQLException {
        if (this.getFieldData() == null) {
            return STRING_NULL_VALUE;
        }
        return String.valueOf(this.field.decodeTime(this.getFieldData()));
    }

    public Time getTime(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return TIME_NULL_VALUE;
        }
        return this.field.decodeTimeCalendar(this.getFieldData(), cal);
    }

    public Time getTime() throws SQLException {
        if (this.getFieldData() == null) {
            return TIME_NULL_VALUE;
        }
        return this.field.decodeTime(this.getFieldData());
    }

    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        return new Timestamp(this.field.decodeTimeCalendar(this.getFieldData(), cal).getTime());
    }

    public Timestamp getTimestamp() throws SQLException {
        if (this.getFieldData() == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        return new Timestamp(this.getTime().getTime());
    }

    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTime(Time.valueOf(value));
    }

    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeTimeCalendar(new Time(value.getTime()), cal));
    }

    public void setTimestamp(Timestamp value) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTime(new Time(value.getTime()));
    }

    public void setTime(Time value, Calendar cal) throws SQLException {
        if (value == TIME_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeTimeCalendar(value, cal));
    }

    public void setTime(Time value) throws SQLException {
        if (value == TIME_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeTime(value));
    }
}

