/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBTimestampField
extends FBField {
    FBTimestampField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    public String getString() throws SQLException {
        if (this.getFieldData() == null) {
            return STRING_NULL_VALUE;
        }
        return String.valueOf(this.field.decodeTimestamp(this.getFieldData()));
    }

    public Date getDate(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return DATE_NULL_VALUE;
        }
        return new Date(this.field.decodeTimestampCalendar(this.getFieldData(), cal).getTime());
    }

    public Date getDate() throws SQLException {
        if (this.getFieldData() == null) {
            return DATE_NULL_VALUE;
        }
        return new Date(this.getTimestamp().getTime());
    }

    public Time getTime(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return TIME_NULL_VALUE;
        }
        return new Time(this.field.decodeTimestampCalendar(this.getFieldData(), cal).getTime());
    }

    public Time getTime() throws SQLException {
        if (this.getFieldData() == null) {
            return TIME_NULL_VALUE;
        }
        return new Time(this.getTimestamp().getTime());
    }

    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        return this.field.decodeTimestampCalendar(this.getFieldData(), cal);
    }

    public Timestamp getTimestamp() throws SQLException {
        if (this.getFieldData() == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        return this.field.decodeTimestamp(this.getFieldData());
    }

    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTimestamp(Timestamp.valueOf(value));
    }

    public void setDate(Date value, Calendar cal) throws SQLException {
        if (value == DATE_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeTimestampCalendar(new Timestamp(value.getTime()), cal));
    }

    public void setDate(Date value) throws SQLException {
        if (value == DATE_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTimestamp(new Timestamp(value.getTime()));
    }

    public void setTime(Time value, Calendar cal) throws SQLException {
        if (value == TIME_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeTimestampCalendar(new Timestamp(value.getTime()), cal));
    }

    public void setTime(Time value) throws SQLException {
        if (value == TIME_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTimestamp(new Timestamp(value.getTime()));
    }

    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeTimestampCalendar(value, cal));
    }

    public void setTimestamp(Timestamp value) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeTimestamp(value));
    }
}

