/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.NBackupManager;

public class FBNBackupManager
extends FBServiceManager
implements NBackupManager {
    private ArrayList backupFiles = new ArrayList();
    private int backupLevel = 0;
    private boolean noDBTriggers = false;

    public FBNBackupManager() {
    }

    public FBNBackupManager(String gdsType) {
        super(gdsType);
    }

    public FBNBackupManager(GDSType gdsType) {
        super(gdsType);
    }

    public void setBackupFile(String backupFile) {
        this.addBackupFile(backupFile);
    }

    public void addBackupFile(String backupFile) {
        this.backupFiles.add(backupFile);
    }

    public void clearBackupFiles() {
        this.backupFiles.clear();
    }

    public void setDatabase(String database) {
        super.setDatabase(database);
    }

    public void backupDatabase() throws SQLException {
        this.executeServicesOperation(this.getBackupSRB());
    }

    private ServiceRequestBuffer getBackupSRB() throws SQLException {
        ServiceRequestBuffer backupSPB = this.getGds().createServiceRequestBuffer(20);
        backupSPB.addArgument(106, this.getDatabase());
        Iterator it = this.backupFiles.iterator();
        if (it.hasNext()) {
            String backupFile = (String)it.next();
            backupSPB.addArgument(6, backupFile);
            backupSPB.addArgument(5, this.backupLevel);
            if (this.noDBTriggers) {
                backupSPB.addArgument(108, 1);
            }
        } else {
            throw new FBSQLException("No backup file specified");
        }
        return backupSPB;
    }

    public void restoreDatabase() throws SQLException {
        this.executeServicesOperation(this.getRestoreSRB());
    }

    private ServiceRequestBuffer getRestoreSRB() throws SQLException {
        GDS gds = this.getGds();
        ServiceRequestBuffer restoreSPB = gds.createServiceRequestBuffer(21);
        restoreSPB.addArgument(106, this.getDatabase());
        Iterator it = this.backupFiles.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String backupFile = (String)it.next();
                restoreSPB.addArgument(6, backupFile);
            }
        } else {
            throw new FBSQLException("No backup file specified");
        }
        return restoreSPB;
    }

    public void setBackupLevel(int backupLevel) {
        this.backupLevel = backupLevel;
    }

    public void setNoDBTriggers(boolean noDBTriggers) {
        this.noDBTriggers = noDBTriggers;
    }
}

