/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.io.IOException;
import java.io.OutputStream;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscSvcHandle;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.management.ServiceManager;

public class FBServiceManager
implements ServiceManager {
    private String user;
    private String password;
    private String database;
    private String host;
    private int port = 3050;
    private OutputStream logger;
    private GDS gds;
    public static final int BUFFER_SIZE = 1024;

    protected FBServiceManager() {
        this.gds = GDSFactory.getGDSForType(GDSFactory.getDefaultGDSType());
    }

    protected FBServiceManager(String gdsType) {
        this.gds = GDSFactory.getGDSForType(GDSType.getType(gdsType));
    }

    protected FBServiceManager(GDSType gdsType) {
        this.gds = GDSFactory.getGDSForType(gdsType);
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public synchronized OutputStream getLogger() {
        return this.logger;
    }

    public synchronized void setLogger(OutputStream logger) {
        this.logger = logger;
    }

    public GDS getGds() {
        return this.gds;
    }

    public String getServiceName() {
        StringBuffer sb = new StringBuffer();
        if (this.getHost() != null) {
            sb.append(this.getHost());
            if (this.getPort() != 3050) {
                sb.append("/");
                sb.append(this.getPort());
            }
            sb.append(":");
        }
        sb.append("service_mgr");
        return sb.toString();
    }

    public IscSvcHandle attachServiceManager(GDS gds) throws GDSException {
        ServiceParameterBuffer serviceParameterBuffer = gds.createServiceParameterBuffer();
        if (this.getUser() != null) {
            serviceParameterBuffer.addArgument(28, this.getUser());
        }
        if (this.getPassword() != null) {
            serviceParameterBuffer.addArgument(29, this.getPassword());
        }
        serviceParameterBuffer.addArgument(58, new byte[]{120, 10, 0, 0});
        IscSvcHandle handle = gds.createIscSvcHandle();
        gds.iscServiceAttach(this.getServiceName(), handle, serviceParameterBuffer);
        return handle;
    }

    public void detachServiceManager(GDS gds, IscSvcHandle handle) throws GDSException {
        gds.iscServiceDetach(handle);
    }

    public void queueService(GDS gds, IscSvcHandle handle) throws GDSException, FBSQLException, IOException {
        OutputStream currentLogger = this.getLogger();
        ServiceRequestBuffer infoSRB = gds.createServiceRequestBuffer(63);
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        boolean processing = true;
        while (processing) {
            gds.iscServiceQuery(handle, gds.createServiceParameterBuffer(), infoSRB, buffer);
            switch (buffer[0]) {
                case 63: {
                    int dataLength = buffer[1] & 0xFF | (buffer[2] & 0xFF) << 8;
                    if (dataLength == 0) {
                        if (buffer[3] != 1) {
                            throw new FBSQLException("Unexpected end of stream reached.");
                        }
                        processing = false;
                        break;
                    }
                    if (currentLogger == null) break;
                    currentLogger.write(buffer, 3, dataLength);
                    break;
                }
                case 2: {
                    buffer = new byte[bufferSize *= 2];
                    break;
                }
                case 1: {
                    processing = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeServicesOperation(ServiceRequestBuffer srb) throws FBSQLException {
        try {
            IscSvcHandle svcHandle = this.attachServiceManager(this.gds);
            try {
                this.gds.iscServiceStart(svcHandle, srb);
                this.queueService(this.gds, svcHandle);
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.detachServiceManager(this.gds, svcHandle);
                throw throwable;
            }
            this.detachServiceManager(this.gds, svcHandle);
            {
            }
        }
        catch (GDSException gdse) {
            throw new FBSQLException(gdse);
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    protected ServiceRequestBuffer createRequestBuffer(int operation, int options) {
        ServiceRequestBuffer srb = this.gds.createServiceRequestBuffer(operation);
        srb.addArgument(106, this.getDatabase());
        srb.addArgument(108, options);
        return srb;
    }
}

