/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.sql.SQLException;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.StatisticsManager;

public class FBStatisticsManager
extends FBServiceManager
implements StatisticsManager {
    private static final int possibleStatistics = 57;

    public FBStatisticsManager() {
    }

    public FBStatisticsManager(String gdsType) {
        super(gdsType);
    }

    public FBStatisticsManager(GDSType gdsType) {
        super(gdsType);
    }

    public void getHeaderPage() throws SQLException {
        ServiceRequestBuffer srb = this.createStatsSRB(4);
        this.executeServicesOperation(srb);
    }

    public void getDatabaseStatistics() throws SQLException {
        ServiceRequestBuffer srb = this.createDefaultStatsSRB();
        this.executeServicesOperation(srb);
    }

    public void getDatabaseStatistics(int options) throws SQLException {
        if (options != 0 && (options | 0x39) != 57) {
            throw new IllegalArgumentException("options must be 0 or a combination of DATA_TABLE_STATISTICS, SYSTEM_TABLE_STATISTICS, INDEX_STATISTICS, or 0");
        }
        ServiceRequestBuffer srb = this.createStatsSRB(options);
        this.executeServicesOperation(srb);
    }

    public void getTableStatistics(String[] tableNames) throws SQLException {
        ServiceRequestBuffer srb = this.createStatsSRB(64);
        StringBuffer commandLine = new StringBuffer();
        for (int i = 0; i < tableNames.length; ++i) {
            commandLine.append(tableNames[i]);
            if (i >= tableNames.length - 1) continue;
            commandLine.append(' ');
        }
        srb.addArgument(105, commandLine.toString());
        this.executeServicesOperation(srb);
    }

    private ServiceRequestBuffer createDefaultStatsSRB() {
        return this.createStatsSRB(0);
    }

    private ServiceRequestBuffer createStatsSRB(int options) {
        return this.createRequestBuffer(11, options);
    }
}

