/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.pool.AbstractConnectionPool;
import org.firebirdsql.pool.BasicAbstractConnectionPool;
import org.firebirdsql.pool.FBPooledConnection;
import org.firebirdsql.pool.FBPooledDataSourceFactory;
import org.firebirdsql.pool.FirebirdPool;
import org.firebirdsql.pool.PooledConnectionEventListener;
import org.firebirdsql.pool.PooledConnectionManager;
import org.firebirdsql.pool.PooledConnectionQueue;
import org.firebirdsql.pool.PooledObject;
import org.firebirdsql.pool.PooledObjectEvent;

public abstract class AbstractFBConnectionPoolDataSource
extends BasicAbstractConnectionPool
implements ConnectionPoolDataSource,
XADataSource,
PooledConnectionEventListener,
FirebirdPool {
    public static final AbstractConnectionPool.UserPasswordPair EMPTY_USER_PASSWORD = new AbstractConnectionPool.UserPasswordPair();
    private static final String PING_STATEMENT = "SELECT cast(1 AS INTEGER) FROM rdb$database";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFBConnectionPoolDataSource.class, false);
    private transient PrintWriter logWriter;
    private volatile transient FBManagedConnectionFactory mcf;
    private FBConnectionProperties connectionProperties = new FBConnectionProperties();
    protected static final String REF_PROPERTIES = "properties";
    protected static final String REF_NON_STANDARD_PROPERTY = "nonStandard";

    public FBConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(FBConnectionProperties props) {
        if (props == null) {
            throw new NullPointerException();
        }
        this.checkNotStarted();
        this.connectionProperties = props;
    }

    private void checkNotStarted() throws IllegalStateException {
        if (this.mcf != null) {
            throw new IllegalStateException("ManagedConnectionFactory is already instantiated, changing connection properties in bulk is not allowed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FBManagedConnectionFactory getManagedConnectionFactory() {
        if (this.mcf != null) {
            return this.mcf;
        }
        AbstractFBConnectionPoolDataSource abstractFBConnectionPoolDataSource = this;
        synchronized (abstractFBConnectionPoolDataSource) {
            if (this.mcf != null) {
                return this.mcf;
            }
            GDSType gdsType = GDSType.getType(this.getType());
            if (gdsType == null) {
                gdsType = GDSFactory.getDefaultGDSType();
            }
            this.mcf = new FBManagedConnectionFactory(gdsType, this.connectionProperties);
        }
        return this.mcf;
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected PooledConnectionManager getConnectionManager() {
        return new PooledConnectionManagerImpl(this.getManagedConnectionFactory());
    }

    protected String getPoolName() {
        return this.getDatabase();
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    public int getLoginTimeout() {
        return this.getBlockingTimeout() / 1000;
    }

    public void setLoginTimeout(int seconds) {
        this.setBlockingTimeout(seconds * 1000);
    }

    protected PooledObject getPooledConnection(PooledConnectionQueue queue) throws SQLException {
        FBPooledConnection connection = (FBPooledConnection)super.getPooledConnection(queue);
        connection.addConnectionEventListener(this);
        connection.setManagedEnvironment(false);
        return connection;
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return (PooledConnection)((Object)this.getPooledConnection(this.getQueue(EMPTY_USER_PASSWORD)));
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return (PooledConnection)((Object)this.getPooledConnection(this.getQueue(new AbstractConnectionPool.UserPasswordPair(user, password))));
    }

    public XAConnection getXAConnection() throws SQLException {
        FBPooledConnection result = (FBPooledConnection)this.getPooledConnection();
        result.setManagedEnvironment(true);
        return result;
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        FBPooledConnection result = (FBPooledConnection)this.getPooledConnection(user, password);
        result.setManagedEnvironment(true);
        return result;
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource());
        this.pooledObjectReleased(event);
    }

    public void physicalConnectionClosed(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource(), true);
        this.pooledObjectReleased(event);
    }

    public void physicalConnectionDeallocated(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource(), true);
        this.physicalConnectionDeallocated(event);
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        if (this.getLogger() != null) {
            this.getLogger().error("Error occured in connection.", event.getSQLException());
        }
    }

    public int getFreeSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).size();
    }

    public int getTotalSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).totalSize();
    }

    public int getWorkingSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).workingSize();
    }

    public boolean isPingable() {
        return true;
    }

    public String getPingStatement() {
        String pingStatement = super.getPingStatement();
        if (pingStatement != null) {
            return pingStatement;
        }
        return PING_STATEMENT;
    }

    public void setProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.setNonStandardProperty(key, value);
        }
    }

    public String getType() {
        return this.connectionProperties.getType();
    }

    public void setType(String type) {
        this.checkNotStarted();
        this.connectionProperties.setType(type);
    }

    public GDSType getGDSType() {
        return GDSType.getType(this.getType());
    }

    public void setGDSType(GDSType gdsType) {
        this.checkNotStarted();
        this.setType(gdsType.toString());
    }

    public String getNonStandardProperty(String key) {
        return this.connectionProperties.getNonStandardProperty(key);
    }

    public void setNonStandardProperty(String key, String value) {
        this.checkNotStarted();
        this.connectionProperties.setNonStandardProperty(key, value);
    }

    public void setNonStandardProperty(String propertyMapping) {
        this.checkNotStarted();
        this.connectionProperties.setNonStandardProperty(propertyMapping);
    }

    public int getBlobBufferSize() {
        return this.connectionProperties.getBlobBufferSize();
    }

    public void setBlobBufferSize(int blobBufferSize) {
        this.checkNotStarted();
        this.connectionProperties.setBlobBufferSize(blobBufferSize);
    }

    public String getEncoding() {
        return this.connectionProperties.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.checkNotStarted();
        this.connectionProperties.setEncoding(encoding);
    }

    public String getCharSet() {
        return this.connectionProperties.getCharSet();
    }

    public void setCharSet(String charSet) {
        this.checkNotStarted();
        this.connectionProperties.setCharSet(charSet);
    }

    public String getPassword() {
        return this.connectionProperties.getPassword();
    }

    public void setPassword(String password) {
        this.checkNotStarted();
        this.connectionProperties.setPassword(password);
    }

    public int getSocketBufferSize() {
        this.checkNotStarted();
        return this.connectionProperties.getSocketBufferSize();
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.checkNotStarted();
        this.connectionProperties.setSocketBufferSize(socketBufferSize);
    }

    public String getRoleName() {
        return this.connectionProperties.getRoleName();
    }

    public void setRoleName(String roleName) {
        this.checkNotStarted();
        this.connectionProperties.setRoleName(roleName);
    }

    public String getSqlRole() {
        return this.getRoleName();
    }

    public void setSqlRole(String sqlRole) {
        this.setRoleName(sqlRole);
    }

    public String getTpbMapping() {
        return this.connectionProperties.getTpbMapping();
    }

    public void setTpbMapping(String tpbMapping) {
        this.checkNotStarted();
        this.connectionProperties.setTpbMapping(tpbMapping);
    }

    public String getUserName() {
        return this.connectionProperties.getUserName();
    }

    public void setUserName(String userName) {
        this.checkNotStarted();
        this.connectionProperties.setUserName(userName);
    }

    public int getBuffersNumber() {
        return this.connectionProperties.getBlobBufferSize();
    }

    public String getDatabase() {
        return this.connectionProperties.getDatabase();
    }

    public DatabaseParameterBuffer getDatabaseParameterBuffer() throws SQLException {
        return this.connectionProperties.getDatabaseParameterBuffer();
    }

    public String getDefaultIsolation() {
        return this.connectionProperties.getDefaultIsolation();
    }

    public int getDefaultTransactionIsolation() {
        return this.connectionProperties.getDefaultTransactionIsolation();
    }

    public String getSqlDialect() {
        return this.connectionProperties.getSqlDialect();
    }

    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.connectionProperties.getTransactionParameters(isolation);
    }

    public String getUseTranslation() {
        return this.connectionProperties.getUseTranslation();
    }

    public boolean isTimestampUsesLocalTimezone() {
        return this.connectionProperties.isTimestampUsesLocalTimezone();
    }

    public boolean isUseStandardUdf() {
        return this.connectionProperties.isUseStandardUdf();
    }

    public boolean isUseStreamBlobs() {
        return this.connectionProperties.isUseStreamBlobs();
    }

    public void setBuffersNumber(int buffersNumber) {
        this.checkNotStarted();
        this.connectionProperties.setBuffersNumber(buffersNumber);
    }

    public void setDatabase(String database) {
        this.checkNotStarted();
        this.connectionProperties.setDatabase(database);
    }

    public void setDefaultIsolation(String isolation) {
        this.checkNotStarted();
        this.connectionProperties.setDefaultIsolation(isolation);
    }

    public void setDefaultTransactionIsolation(int defaultIsolationLevel) {
        this.checkNotStarted();
        this.connectionProperties.setDefaultTransactionIsolation(defaultIsolationLevel);
    }

    public void setSqlDialect(String sqlDialect) {
        this.checkNotStarted();
        this.connectionProperties.setSqlDialect(sqlDialect);
    }

    public void setTimestampUsesLocalTimezone(boolean timestampUsesLocalTimezone) {
        this.checkNotStarted();
        this.connectionProperties.setTimestampUsesLocalTimezone(timestampUsesLocalTimezone);
    }

    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.checkNotStarted();
        this.connectionProperties.setTransactionParameters(isolation, tpb);
    }

    public void setUseStandardUdf(boolean useStandardUdf) {
        this.checkNotStarted();
        this.connectionProperties.setUseStandardUdf(useStandardUdf);
    }

    public void setUseStreamBlobs(boolean useStreamBlobs) {
        this.checkNotStarted();
        this.connectionProperties.setUseStreamBlobs(useStreamBlobs);
    }

    public void setUseTranslation(String translationPath) {
        this.checkNotStarted();
        this.connectionProperties.setUseTranslation(translationPath);
    }

    public boolean isDefaultResultSetHoldable() {
        return this.connectionProperties.isDefaultResultSetHoldable();
    }

    public void setDefaultResultSetHoldable(boolean isHoldable) {
        this.checkNotStarted();
        this.connectionProperties.setDefaultResultSetHoldable(isHoldable);
    }

    public int getSoTimeout() {
        this.checkNotStarted();
        return this.connectionProperties.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.checkNotStarted();
        this.connectionProperties.setSoTimeout(soTimeout);
    }

    public int getConnectTimeout() {
        return this.connectionProperties.getConnectTimeout();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.checkNotStarted();
        this.connectionProperties.setConnectTimeout(connectTimeout);
    }

    public Reference getDefaultReference() {
        Reference ref = super.getDefaultReference();
        byte[] data = AbstractFBConnectionPoolDataSource.serialize(this.connectionProperties);
        ref.add(new BinaryRefAddr(REF_PROPERTIES, data));
        return ref;
    }

    protected Object processObjectInstance(AbstractFBConnectionPoolDataSource ds, Reference ref) throws Exception {
        if (ds == null) {
            return null;
        }
        for (int i = 0; i < ref.size(); ++i) {
            RefAddr element = ref.get(i);
            String type = element.getType();
            if (REF_NON_STANDARD_PROPERTY.equals(type)) {
                ds.setNonStandardProperty(element.getContent().toString());
                continue;
            }
            if (REF_PROPERTIES.equals(type)) {
                byte[] data = (byte[])element.getContent();
                FBConnectionProperties props = (FBConnectionProperties)AbstractFBConnectionPoolDataSource.deserialize(data);
                ds.setConnectionProperties(props);
                continue;
            }
            if (!(element.getContent() instanceof String)) continue;
            ds.setNonStandardProperty(type, element.getContent().toString());
        }
        return ds;
    }

    protected BasicAbstractConnectionPool createObjectInstance() {
        return FBPooledDataSourceFactory.createFBConnectionPoolDataSource();
    }

    private class PooledConnectionManagerImpl
    implements PooledConnectionManager {
        private final WeakReference<FBManagedConnectionFactory> mcf;

        private PooledConnectionManagerImpl(FBManagedConnectionFactory mcf) {
            this.mcf = new WeakReference<FBManagedConnectionFactory>(mcf);
        }

        public PooledObject allocateConnection(Object key, PooledConnectionQueue queue) throws SQLException {
            if (!(key instanceof AbstractConnectionPool.UserPasswordPair)) {
                throw new SQLException("Incorrect key.");
            }
            AbstractConnectionPool.UserPasswordPair pair = (AbstractConnectionPool.UserPasswordPair)key;
            FBManagedConnectionFactory connectionFactory = (FBManagedConnectionFactory)this.mcf.get();
            if (connectionFactory == null) {
                throw new SQLException("Weak reference to connection factory is null. Underlying connection pool has not been initialized or has been closed.");
            }
            String userName = pair.getUserName();
            String password = pair.getPassword();
            try {
                FBConnectionRequestInfo defaultCri = connectionFactory.getDefaultConnectionRequestInfo();
                if (userName != null) {
                    defaultCri.setUserName(userName);
                }
                if (password != null) {
                    defaultCri.setPassword(password);
                }
                FBManagedConnection managedConnection = (FBManagedConnection)connectionFactory.createManagedConnection(null, defaultCri);
                managedConnection.setConnectionSharing(false);
                managedConnection.setManagedEnvironment(false);
                FBPooledConnection pooledConnection = AbstractFBConnectionPoolDataSource.this.isPingable() ? new FBPooledConnection(managedConnection, defaultCri, AbstractFBConnectionPoolDataSource.this.getPingStatement(), AbstractFBConnectionPoolDataSource.this.getPingInterval(), AbstractFBConnectionPoolDataSource.this.isStatementPooling(), AbstractFBConnectionPoolDataSource.this.getMaxStatements(), AbstractFBConnectionPoolDataSource.this.isKeepStatements(), queue) : new FBPooledConnection(managedConnection, defaultCri, AbstractFBConnectionPoolDataSource.this.isStatementPooling(), AbstractFBConnectionPoolDataSource.this.getMaxStatements(), AbstractFBConnectionPoolDataSource.this.isKeepStatements(), queue);
                return pooledConnection;
            }
            catch (ResourceException ex) {
                throw new FBSQLException(ex);
            }
        }
    }
}

