/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.firebirdsql.ds.ReflectionHelper;
import org.firebirdsql.pool.ObjectCloseTraceException;
import org.firebirdsql.pool.ResultSetHandler;
import org.firebirdsql.pool.XCachablePreparedStatement;
import org.firebirdsql.pool.XPreparedStatementModel;
import org.firebirdsql.pool.XStatementManager;

public class PooledPreparedStatementHandler
implements InvocationHandler {
    private static final boolean TOLERANT_CHECK_MODE = false;
    private static final Method PREPARED_STATEMENT_CLOSE = ReflectionHelper.findMethod(PreparedStatement.class, "close", new Class[0]);
    private static final Method PREPARED_STATEMENT_GET_CONNECTION = ReflectionHelper.findMethod(PreparedStatement.class, "getConnection", new Class[0]);
    private static final Method PREPARED_STATEMENT_FORCE_CLOSE = ReflectionHelper.findMethod(XCachablePreparedStatement.class, "forceClose", new Class[0]);
    private static final Method PREPARED_STATEMENT_SET_CONNECTION = ReflectionHelper.findMethod(XCachablePreparedStatement.class, "setConnection", new Class[]{Connection.class});
    private static final Method PREPARED_STATEMENT_GET_ORIGINAL = ReflectionHelper.findMethod(XCachablePreparedStatement.class, "getOriginal", new Class[0]);
    private static final Method PREPARED_STATEMENT_IS_CACHED = ReflectionHelper.findMethod(XCachablePreparedStatement.class, "isCached", new Class[0]);
    private XPreparedStatementModel key;
    private PreparedStatement preparedStatement;
    private XStatementManager owner;
    private Connection associatedConnection;
    private boolean cached;
    private boolean invalid;
    private ObjectCloseTraceException invalidateStackTrace;

    PooledPreparedStatementHandler(XPreparedStatementModel key, PreparedStatement preparedStatement, XStatementManager owner, boolean cached) {
        this.key = key;
        this.preparedStatement = preparedStatement;
        this.owner = owner;
        this.invalid = false;
        this.cached = cached;
    }

    protected void handleStatementClose(XPreparedStatementModel key, Object proxy) throws SQLException {
        if (this.invalid) {
            throw new SQLException("Statement is already closed.");
        }
        this.owner.statementClosed(key, proxy);
    }

    protected void handleForceClose() throws SQLException {
        this.preparedStatement.close();
        this.associatedConnection = null;
        this.invalid = true;
        this.invalidateStackTrace = new ObjectCloseTraceException();
    }

    protected boolean handleIsCached() throws SQLException {
        return this.cached;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.checkCorrectness(method);
        try {
            if (method.equals(PREPARED_STATEMENT_CLOSE)) {
                this.handleStatementClose(this.key, proxy);
                return Void.TYPE;
            }
            if (method.equals(PREPARED_STATEMENT_GET_CONNECTION)) {
                return this.associatedConnection;
            }
            if (method.equals(PREPARED_STATEMENT_SET_CONNECTION)) {
                this.associatedConnection = (Connection)args[0];
                return Void.TYPE;
            }
            if (method.equals(PREPARED_STATEMENT_GET_ORIGINAL)) {
                return this.preparedStatement;
            }
            if (method.equals(PREPARED_STATEMENT_FORCE_CLOSE)) {
                this.handleForceClose();
                return Void.TYPE;
            }
            if (method.equals(PREPARED_STATEMENT_IS_CACHED)) {
                return this.handleIsCached();
            }
            Object result = method.invoke((Object)this.preparedStatement, args);
            if (result instanceof ResultSet) {
                ResultSetHandler handler = new ResultSetHandler((PreparedStatement)proxy, (ResultSet)result);
                result = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)handler);
            }
            return result;
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    protected void checkCorrectness(Method method) throws SQLException {
        boolean incorrectState;
        String message = "Statemenet has illegal state because it does not have any associated connection at this time. Usually this means that Statement.getConnection() method was called on a closed statement that currently lives in a statement pool. ";
        if (this.invalid) {
            message = message + "See the attached exception for the information where the object was closed.";
        }
        boolean bl = incorrectState = this.associatedConnection == null && method.getDeclaringClass().equals(PreparedStatement.class) || this.invalid;
        if (incorrectState) {
            throw new IllegalStateException(message);
        }
    }
}

