/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.pool.BlockingStack;
import org.firebirdsql.pool.PoolDebugConfiguration;
import org.firebirdsql.pool.XCachablePreparedStatement;
import org.firebirdsql.pool.XPreparedStatementModel;
import org.firebirdsql.pool.XStatementManager;
import org.firebirdsql.util.SQLExceptionChainBuilder;

@Deprecated
class XPreparedStatementCache {
    private static final boolean CACHE_PREPARED_STATEMENTS = true;
    private static final boolean LOG_STATEMENT_IN_POOL = PoolDebugConfiguration.DEBUG_STMT_POOL;
    private static Logger logChannel = LoggerFactory.getLogger(XPreparedStatementCache.class, false);
    private XStatementManager owner;
    private BlockingStack freeReferences = new BlockingStack();
    private HashMap workingReferences = new HashMap();
    private XPreparedStatementModel key;
    private int maxSize;

    public XPreparedStatementCache(XStatementManager owner, XPreparedStatementModel key, int maxSize) {
        this.owner = owner;
        this.maxSize = maxSize;
        if (key == null) {
            throw new NullPointerException("Null objects cannot be guarded.");
        }
        this.key = key;
    }

    synchronized XCachablePreparedStatement take(Connection connection) throws SQLException {
        if (this.key == null) {
            throw new IllegalStateException("This reference guard was already destroyed.");
        }
        try {
            XCachablePreparedStatement result;
            if (this.freeReferences.isEmpty()) {
                if (LOG_STATEMENT_IN_POOL && logChannel != null) {
                    logChannel.info("Found no free prepared statements, preparing new one.");
                }
                result = this.prepareStatement(this.key, this.workingReferences.size() < this.maxSize);
            } else {
                if (LOG_STATEMENT_IN_POOL && logChannel != null) {
                    logChannel.info("Found free prepared statement in pool.");
                }
                result = (XCachablePreparedStatement)this.freeReferences.pop();
            }
            result.setConnection(connection);
            this.workingReferences.put(result.getOriginal(), result);
            return result;
        }
        catch (InterruptedException iex) {
            throw new SQLException("Cannot prepare SQL statement in pool");
        }
    }

    protected XCachablePreparedStatement prepareStatement(XPreparedStatementModel key, boolean cached) throws SQLException {
        return this.owner.prepareStatement(key, cached);
    }

    synchronized void put(Object reference) throws SQLException {
        if (reference == null) {
            throw new NullPointerException();
        }
        try {
            XCachablePreparedStatement statement = (XCachablePreparedStatement)reference;
            if (statement.isCached()) {
                statement.setConnection(null);
                this.freeReferences.push(reference);
            }
            this.workingReferences.remove(statement.getOriginal());
            if (!statement.isCached()) {
                statement.forceClose();
            }
            if (LOG_STATEMENT_IN_POOL && logChannel != null) {
                logChannel.info("Returned prepared statement to pool.");
            }
        }
        catch (InterruptedException ex) {
            logChannel.warn("Could not put statement back to pool.", ex);
        }
    }

    synchronized void invalidate() throws SQLException {
        this.key = null;
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        while (!this.freeReferences.isEmpty()) {
            try {
                XCachablePreparedStatement result = (XCachablePreparedStatement)this.freeReferences.pop();
                result.forceClose();
            }
            catch (InterruptedException ex) {
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        }
        for (Map.Entry entry : this.workingReferences.entrySet()) {
            XCachablePreparedStatement item = (XCachablePreparedStatement)entry.getValue();
            try {
                item.forceClose();
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        }
        this.workingReferences.clear();
        if (chain.hasException()) {
            throw chain.getException();
        }
    }
}

