/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.auth.Subject;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.impl.GDSServerVersion;

public abstract class AbstractIscDbHandle
implements IscDbHandle {
    private volatile boolean invalid;
    private int rdb_id;
    private Subject subject;
    private List rdb_warnings = new ArrayList();
    private int dialect;
    private int protocol;
    private GDSServerVersion serverVersion;
    private int ODSMajorVersion;
    private int ODSMinorVersion;
    private int resp_object;
    private byte[] resp_data;
    protected Collection rdb_transactions = new ArrayList();
    private long resp_blob_id;

    protected AbstractIscDbHandle() {
    }

    protected AbstractIscDbHandle(byte[] defaultResp_data) {
        this.resp_data = defaultResp_data;
    }

    @Override
    public int getDatabaseProductMajorVersion() {
        return this.serverVersion.getMajorVersion();
    }

    @Override
    public int getDatabaseProductMinorVersion() {
        return this.serverVersion.getMinorVersion();
    }

    @Override
    public String getDatabaseProductName() {
        return this.serverVersion.getServerName();
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.serverVersion.getFullVersion();
    }

    @Override
    public int getDialect() {
        return this.dialect;
    }

    @Override
    public void setDialect(int value) {
        this.dialect = value;
    }

    @Override
    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int value) {
        this.protocol = value;
    }

    @Override
    public int getODSMajorVersion() {
        return this.ODSMajorVersion;
    }

    @Override
    public void setODSMajorVersion(int value) {
        this.ODSMajorVersion = value;
    }

    @Override
    public int getODSMinorVersion() {
        return this.ODSMinorVersion;
    }

    @Override
    public void setODSMinorVersion(int value) {
        this.ODSMinorVersion = value;
    }

    @Override
    public String getVersion() {
        return this.serverVersion.toString();
    }

    @Override
    public void setVersion(String version) throws GDSException {
        this.setVersion(new String[]{version});
    }

    @Override
    public void setVersion(String ... version) throws GDSException {
        this.serverVersion = GDSServerVersion.parseRawVersion(version);
    }

    @Override
    public boolean isValid() {
        return !this.invalid;
    }

    protected void checkValidity() {
        if (this.invalid) {
            throw new IllegalStateException("This database handle is invalid and cannot be used anymore.");
        }
    }

    public void setRdbId(int rdb_id) {
        this.checkValidity();
        this.rdb_id = rdb_id;
    }

    public int getRdbId() {
        this.checkValidity();
        return this.rdb_id;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getWarnings() {
        this.checkValidity();
        List list = this.rdb_warnings;
        synchronized (list) {
            return new ArrayList(this.rdb_warnings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWarning(GDSException warning) {
        this.checkValidity();
        List list = this.rdb_warnings;
        synchronized (list) {
            this.rdb_warnings.add(warning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() {
        this.checkValidity();
        List list = this.rdb_warnings;
        synchronized (list) {
            this.rdb_warnings.clear();
        }
    }

    public void setResp_object(int value) {
        this.resp_object = value;
    }

    public int getResp_object() {
        return this.resp_object;
    }

    public void setResp_data(byte[] value) {
        this.resp_data = value;
    }

    public byte[] getResp_data() {
        return this.resp_data;
    }

    public boolean hasTransactions() {
        this.checkValidity();
        return !this.rdb_transactions.isEmpty();
    }

    public Collection getTransactions() {
        return new ArrayList(this.rdb_transactions);
    }

    public int getOpenTransactionCount() {
        this.checkValidity();
        return this.rdb_transactions.size();
    }

    public void setResp_blob_id(long value) {
        this.resp_blob_id = value;
    }

    public long getResp_blob_id() {
        return this.resp_blob_id;
    }

    protected final synchronized void invalidateHandle() {
        this.invalid = true;
    }
}

