/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBEscapedCallParser;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBParameterMetaData;
import org.firebirdsql.jdbc.FBPreparedStatement;
import org.firebirdsql.jdbc.FBProcedureCall;
import org.firebirdsql.jdbc.FBProcedureParam;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdCallableStatement;
import org.firebirdsql.jdbc.StoredProcedureMetaData;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.TypeConversionException;

public abstract class AbstractCallableStatement
extends FBPreparedStatement
implements CallableStatement,
FirebirdCallableStatement {
    static final String NATIVE_CALL_COMMAND = "EXECUTE PROCEDURE ";
    static final String NATIVE_SELECT_COMMAND = "SELECT * FROM ";
    private ResultSet currentRs;
    private ResultSet singletonRs;
    protected boolean selectableProcedure;
    protected FBProcedureCall procedureCall;

    protected AbstractCallableStatement(GDSHelper c, String sql, int rsType, int rsConcurrency, int rsHoldability, StoredProcedureMetaData storedProcMetaData, FBObjectListener.StatementListener statementListener, FBObjectListener.BlobListener blobListener) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability, statementListener, blobListener);
        DatabaseParameterBuffer dpb = c.getDatabaseParameterBuffer();
        int mode = 0;
        if (dpb.hasArgument(134)) {
            mode = 1;
        }
        FBEscapedCallParser parser = new FBEscapedCallParser(mode);
        this.procedureCall = parser.parseCall(this.nativeSQL(sql));
        if (storedProcMetaData.canGetSelectableInformation()) {
            this.setSelectabilityAutomatically(storedProcMetaData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.statementListener.executionStarted(this);
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()), true);
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
        return new FBParameterMetaData(this.fixedStmt.getInSqlda().sqlvar, this.gdsHelper);
    }

    @Override
    public void addBatch() throws SQLException {
        this.procedureCall.checkParameters();
        this.batchList.add(this.procedureCall.clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] executeBatch() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            boolean success = false;
            try {
                int[] nArray;
                this.notifyStatementStarted();
                ArrayList<Integer> results = new ArrayList<Integer>(this.batchList.size());
                Iterator iterator = this.batchList.iterator();
                try {
                    while (iterator.hasNext()) {
                        this.procedureCall = (FBProcedureCall)iterator.next();
                        this.executeSingleForBatch(results);
                    }
                    success = true;
                    nArray = this.toArray(results);
                }
                catch (Throwable throwable) {
                    this.clearBatch();
                    throw throwable;
                }
                this.clearBatch();
                return nArray;
            }
            finally {
                this.notifyStatementCompleted(success);
            }
        }
    }

    private void executeSingleForBatch(List<Integer> results) throws SQLException {
        try {
            this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()), true);
            if (this.internalExecute(!this.isSelectableProcedure())) {
                throw new BatchUpdateException(this.toArray(results));
            }
            results.add(this.getUpdateCount());
        }
        catch (GDSException ex) {
            throw new BatchUpdateException(ex.getMessage(), "", ex.getFbErrorCode(), this.toArray(results));
        }
    }

    @Override
    public void setSelectableProcedure(boolean selectableProcedure) {
        this.selectableProcedure = selectableProcedure;
    }

    @Override
    public boolean isSelectableProcedure() {
        return this.selectableProcedure;
    }

    protected void setRequiredTypes() throws SQLException {
        if (this.singletonRs != null) {
            this.setRequiredTypesInternal((FBResultSet)this.singletonRs);
        }
        this.setRequiredTypesInternal((FBResultSet)this.getCurrentResultSet());
    }

    private void setRequiredTypesInternal(FBResultSet resultSet) throws SQLException {
        for (FBProcedureParam param : this.procedureCall.getOutputParams()) {
            if (param == null) continue;
            FBField field = resultSet.getField(this.procedureCall.mapOutParamIndexToPosition(param.getIndex()), false);
            field.setRequiredType(param.getType());
        }
    }

    @Override
    protected void prepareFixedStatement(String sql, boolean describeBind) throws GDSException, SQLException {
        if (this.fixedStmt != null) {
            return;
        }
        super.prepareFixedStatement(sql, describeBind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.statementListener.executionStarted(this);
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()), true);
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
        return super.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        this.procedureCall.checkParameters();
        boolean hasResultSet = false;
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            try {
                this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()), true);
                hasResultSet = this.internalExecute(!this.isSelectableProcedure());
                if (hasResultSet) {
                    this.setRequiredTypes();
                }
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            finally {
                if (!hasResultSet) {
                    this.notifyStatementCompleted();
                }
            }
            return hasResultSet;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.procedureCall.checkParameters();
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            try {
                this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()), true);
                if (!this.internalExecute(!this.isSelectableProcedure())) {
                    throw new FBSQLException("No resultset for sql", "07005");
                }
                this.getResultSet();
                this.setRequiredTypes();
                return this.getCurrentResultSet();
            }
            catch (GDSException ex) {
                throw new FBSQLException(ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int executeUpdate() throws SQLException {
        this.procedureCall.checkParameters();
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.notifyStatementStarted();
                this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()), true);
                boolean hasResults = this.internalExecute(!this.isSelectableProcedure());
                if (hasResults) {
                    this.setRequiredTypes();
                }
                int n = this.getUpdateCount();
                return n;
            }
            catch (GDSException ex) {
                throw new FBSQLException(ex);
            }
            finally {
                this.notifyStatementCompleted();
            }
        }
    }

    @Override
    protected boolean internalExecute(boolean sendOutParams) throws SQLException {
        byte[][][] rows;
        this.currentRs = null;
        this.singletonRs = null;
        int counter = 0;
        for (FBProcedureParam param : this.procedureCall.getInputParams()) {
            if (param == null || !param.isParam()) continue;
            Object value = param.getValue();
            FBField field = this.getField(++counter);
            if (value == null) {
                field.setNull();
            } else if (value instanceof WrapperWithCalendar) {
                this.setField(field, (WrapperWithCalendar)value);
            } else if (value instanceof WrapperWithInt) {
                this.setField(field, (WrapperWithInt)value);
            } else {
                field.setObject(value);
            }
            this.isParamSet[counter - 1] = true;
        }
        boolean hasResultSet = super.internalExecute(sendOutParams);
        if (hasResultSet && !this.isSelectableProcedure() && (rows = this.fixedStmt.getRows()).length > 0) {
            ArrayList<byte[][]> rowList = new ArrayList<byte[][]>();
            rowList.add(rows[0]);
            this.singletonRs = new FBResultSet(this.fixedStmt.getOutSqlda().sqlvar, this.gdsHelper, rowList, true);
        }
        return hasResultSet;
    }

    private void setField(FBField field, WrapperWithInt value) throws SQLException {
        Object obj = value.getValue();
        if (obj == null) {
            field.setNull();
        } else {
            int intValue = value.getIntValue();
            if (obj instanceof InputStream) {
                field.setBinaryStream((InputStream)obj, intValue);
            } else if (obj instanceof Reader) {
                field.setCharacterStream((Reader)obj, intValue);
            } else {
                throw new TypeConversionException("Cannot convert type " + obj.getClass().getName());
            }
        }
    }

    private void setField(FBField field, WrapperWithCalendar value) throws SQLException {
        Object obj = value.getValue();
        if (obj == null) {
            field.setNull();
        } else {
            Calendar cal = value.getCalendar();
            if (obj instanceof Timestamp) {
                field.setTimestamp((Timestamp)obj, cal);
            } else if (obj instanceof Date) {
                field.setDate((Date)obj, cal);
            } else if (obj instanceof Time) {
                field.setTime((Time)obj, cal);
            } else {
                throw new TypeConversionException("Cannot convert type " + obj.getClass().getName());
            }
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.procedureCall.registerOutParam(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.procedureCall.registerOutParam(parameterIndex, sqlType);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.getAndAssertSingletonResultSet().wasNull();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getString(parameterIndex);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getByte(parameterIndex);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getShort(parameterIndex);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getInt(parameterIndex);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getLong(parameterIndex);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getFloat(parameterIndex);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getDouble(parameterIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getBigDecimal(parameterIndex, scale);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getBytes(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getDate(parameterIndex);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getTimestamp(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getObject(parameterIndex);
    }

    @Override
    public Object getObject(String colName) throws SQLException {
        return this.getObject(this.findOutParameter(colName));
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getObject(parameterIndex, map);
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findOutParameter(colName), map);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return ((FBResultSet)this.getAndAssertSingletonResultSet()).getObject(parameterIndex, type);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getObject(this.findOutParameter(parameterName), type);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getBigDecimal(parameterIndex);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getRef(parameterIndex);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getBlob(parameterIndex);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getClob(parameterIndex);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getArray(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getTimestamp(parameterIndex, cal);
    }

    @Override
    public URL getURL(int colIndex) throws SQLException {
        colIndex = this.procedureCall.mapOutParamIndexToPosition(colIndex);
        return this.getAndAssertSingletonResultSet().getURL(colIndex);
    }

    @Override
    public String getString(String colName) throws SQLException {
        return this.getString(this.findOutParameter(colName));
    }

    @Override
    public boolean getBoolean(String colName) throws SQLException {
        return this.getBoolean(this.findOutParameter(colName));
    }

    @Override
    public byte getByte(String colName) throws SQLException {
        return this.getByte(this.findOutParameter(colName));
    }

    @Override
    public short getShort(String colName) throws SQLException {
        return this.getShort(this.findOutParameter(colName));
    }

    @Override
    public int getInt(String colName) throws SQLException {
        return this.getInt(this.findOutParameter(colName));
    }

    @Override
    public long getLong(String colName) throws SQLException {
        return this.getLong(this.findOutParameter(colName));
    }

    @Override
    public float getFloat(String colName) throws SQLException {
        return this.getFloat(this.findOutParameter(colName));
    }

    @Override
    public double getDouble(String colName) throws SQLException {
        return this.getDouble(this.findOutParameter(colName));
    }

    @Override
    public byte[] getBytes(String colName) throws SQLException {
        return this.getBytes(this.findOutParameter(colName));
    }

    @Override
    public Date getDate(String colName) throws SQLException {
        return this.getDate(this.findOutParameter(colName));
    }

    @Override
    public Time getTime(String colName) throws SQLException {
        return this.getTime(this.findOutParameter(colName));
    }

    @Override
    public Timestamp getTimestamp(String colName) throws SQLException {
        return this.getTimestamp(this.findOutParameter(colName));
    }

    @Override
    public BigDecimal getBigDecimal(String colName) throws SQLException {
        return this.getBigDecimal(this.findOutParameter(colName));
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findOutParameter(colName));
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findOutParameter(colName));
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findOutParameter(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findOutParameter(colName));
    }

    @Override
    public Date getDate(String colName, Calendar cal) throws SQLException {
        return this.getDate(this.findOutParameter(colName), cal);
    }

    @Override
    public Time getTime(String colName, Calendar cal) throws SQLException {
        return this.getTime(this.findOutParameter(colName), cal);
    }

    @Override
    public Timestamp getTimestamp(String colName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findOutParameter(colName), cal);
    }

    @Override
    public URL getURL(String colName) throws SQLException {
        return this.getURL(this.findOutParameter(colName));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getCharacterStream(parameterIndex);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getCharacterStream(this.findOutParameter(parameterName));
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return ((FBResultSet)this.getAndAssertSingletonResultSet()).getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getNCharacterStream(this.findOutParameter(parameterName));
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return ((FBResultSet)this.getAndAssertSingletonResultSet()).getNString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getNString(this.findOutParameter(parameterName));
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void registerOutParameter(String param1, int param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void registerOutParameter(String param1, int param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void registerOutParameter(String param1, int param2, String param3) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setURL(String param1, URL param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setNull(String param1, int param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setBoolean(String param1, boolean param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setByte(String param1, byte param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setShort(String param1, short param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setInt(String param1, int param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setLong(String param1, long param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setFloat(String param1, float param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setDouble(String param1, double param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setBigDecimal(String param1, BigDecimal param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setString(String param1, String param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setBytes(String param1, byte[] param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setDate(String param1, Date param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setTime(String param1, Time param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setTimestamp(String param1, Timestamp param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setAsciiStream(String param1, InputStream param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setBinaryStream(String param1, InputStream param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setObject(String param1, Object param2, int param3, int param4) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setObject(String param1, Object param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setObject(String param1, Object param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setCharacterStream(String param1, Reader param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setDate(String param1, Date param2, Calendar param3) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setTime(String param1, Time param2, Calendar param3) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setTimestamp(String param1, Timestamp param2, Calendar param3) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setNull(String param1, int param2, String param3) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    private void assertHasData(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new SQLException("Current statement has no data to return.", "07005");
        }
        if (rs.getRow() != 0) {
            return;
        }
        rs.next();
        if (rs.getRow() == 0) {
            throw new FBSQLException("Current statement has no data to return.", "07005");
        }
    }

    @Override
    public ResultSet getCurrentResultSet() throws SQLException {
        if (this.currentRs == null) {
            this.currentRs = super.getResultSet();
        }
        return this.currentRs;
    }

    protected ResultSet getAndAssertSingletonResultSet() throws SQLException {
        ResultSet rs = !this.isSelectableProcedure() && this.singletonRs != null ? this.singletonRs : this.getCurrentResultSet();
        this.assertHasData(rs);
        return rs;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getCurrentResultSet();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.procedureCall.getInputParam(i).setValue(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithInt(inputStream, length));
    }

    @Override
    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(blob);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithInt(reader, length));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithCalendar(x, cal));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(Float.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(null);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(null);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithCalendar(x, cal));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithCalendar(x, cal));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    private void setSelectabilityAutomatically(StoredProcedureMetaData storedProcMetaData) throws SQLException {
        this.selectableProcedure = storedProcMetaData.isSelectable(this.procedureCall.getName());
    }

    protected int findOutParameter(String paramName) throws SQLException {
        return this.getAndAssertSingletonResultSet().findColumn(paramName);
    }

    @Override
    public final boolean equals(Object other) {
        if (!(other instanceof AbstractCallableStatement)) {
            return false;
        }
        return super.equals(other);
    }

    private static class WrapperWithInt {
        private final Object value;
        private final int intValue;

        private WrapperWithInt(Object value, int intValue) {
            this.value = value;
            this.intValue = intValue;
        }

        private Object getValue() {
            return this.value;
        }

        private int getIntValue() {
            return this.intValue;
        }
    }

    private static class WrapperWithCalendar {
        private final Object value;
        private final Calendar c;

        private WrapperWithCalendar(Object value, Calendar c) {
            this.value = value;
            this.c = c;
        }

        private Object getValue() {
            return this.value;
        }

        private Calendar getCalendar() {
            return this.c;
        }
    }
}

