/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBDriverConsistencyCheckException;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class FBConnection
extends AbstractConnection {
    private HashSet clientInfoPropNames = new HashSet();
    private static final String GET_CLIENT_INFO_SQL = "SELECT     rdb$get_context('USER_SESSION', ?) session_context   , rdb$get_context('USER_TRANSACTION', ?) tx_context FROM rdb$database";
    private static final String SET_CLIENT_INFO_SQL = "SELECT   rdb$set_context('USER_SESSION', ?, ?) session_context FROM rdb$database";

    public FBConnection(FBManagedConnection mc) {
        super(mc);
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getClientInfo() throws SQLException {
        Properties result = new Properties();
        PreparedStatement stmt = this.prepareStatement(GET_CLIENT_INFO_SQL);
        try {
            for (String propName : this.clientInfoPropNames) {
                result.put(propName, this.getClientInfo(stmt, propName));
            }
        }
        finally {
            stmt.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClientInfo(String name) throws SQLException {
        PreparedStatement stmt = this.prepareStatement(GET_CLIENT_INFO_SQL);
        try {
            String string = this.getClientInfo(stmt, name);
            return string;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getClientInfo(PreparedStatement stmt, String name) throws SQLException {
        stmt.clearParameters();
        stmt.setString(1, name);
        stmt.setString(2, name);
        ResultSet rs = stmt.executeQuery();
        try {
            if (!rs.next()) {
                String string = null;
                return string;
            }
            String sessionContext = rs.getString(1);
            String transactionContext = rs.getString(2);
            if (transactionContext != null) {
                String string = transactionContext;
                return string;
            }
            if (sessionContext != null) {
                String string = sessionContext;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        SQLExceptionChainBuilder<SQLClientInfoException> chain = new SQLExceptionChainBuilder<SQLClientInfoException>();
        try {
            PreparedStatement stmt = this.prepareStatement(SET_CLIENT_INFO_SQL);
            try {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    try {
                        this.setClientInfo(stmt, (String)entry.getKey(), (String)entry.getValue());
                    }
                    catch (SQLClientInfoException ex) {
                        chain.append(ex);
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            throw new SQLClientInfoException(ex.getMessage(), ex.getSQLState(), null, (Throwable)ex);
        }
        if (chain.hasException()) {
            throw (SQLClientInfoException)chain.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            PreparedStatement stmt = this.prepareStatement(SET_CLIENT_INFO_SQL);
            try {
                this.setClientInfo(stmt, name, value);
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            throw new SQLClientInfoException(ex.getMessage(), ex.getSQLState(), null, (Throwable)ex);
        }
    }

    protected void setClientInfo(PreparedStatement stmt, String name, String value) throws SQLException {
        try {
            stmt.clearParameters();
            stmt.setString(1, name);
            stmt.setString(2, value);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new FBDriverConsistencyCheckException("Expected result from RDB$SET_CONTEXT call");
            }
            rs.getInt(1);
        }
        catch (SQLException ex) {
            throw new SQLClientInfoException(null, (Throwable)ex);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkValidity();
        return 0;
    }
}

