/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.DefaultCallableStatementMetaData;
import org.firebirdsql.jdbc.DummyCallableStatementMetaData;
import org.firebirdsql.jdbc.FirebirdDatabaseMetaData;
import org.firebirdsql.jdbc.StoredProcedureMetaData;

public abstract class StoredProcedureMetaDataFactory {
    public static StoredProcedureMetaData getInstance(AbstractConnection connection) throws SQLException {
        StoredProcedureMetaData metaData = StoredProcedureMetaDataFactory.connectionHasProcedureMetadata(connection) ? new DefaultCallableStatementMetaData(connection) : new DummyCallableStatementMetaData();
        return metaData;
    }

    private static boolean connectionHasProcedureMetadata(AbstractConnection connection) throws SQLException {
        FirebirdDatabaseMetaData metaData = (FirebirdDatabaseMetaData)connection.getMetaData();
        return StoredProcedureMetaDataFactory.versionInformationEqualOrAbove(metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion(), 2, 1) && StoredProcedureMetaDataFactory.versionInformationEqualOrAbove(metaData.getOdsMajorVersion(), metaData.getOdsMinorVersion(), 2, 1);
    }

    private static boolean versionInformationEqualOrAbove(int majorVersion, int minorVersion, int requiredMajorVersion, int requiredMinorVersion) {
        return majorVersion > requiredMajorVersion || majorVersion == requiredMajorVersion && minorVersion >= requiredMinorVersion;
    }
}

