/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBDateField
extends FBField {
    FBDateField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        return new Timestamp(this.field.decodeDateCalendar(this.getFieldData(), cal).getTime());
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        if (this.getFieldData() == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        return new Timestamp(this.getDate().getTime());
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return DATE_NULL_VALUE;
        }
        return this.field.decodeDateCalendar(this.getFieldData(), cal);
    }

    @Override
    public Date getDate() throws SQLException {
        if (this.getFieldData() == null) {
            return DATE_NULL_VALUE;
        }
        return this.field.decodeDate(this.getFieldData());
    }

    @Override
    public String getString() throws SQLException {
        if (this.getFieldData() == null) {
            return STRING_NULL_VALUE;
        }
        return this.field.decodeDate(this.getFieldData()).toString();
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setDate(Date.valueOf(value));
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeDateCalendar(new Date(value.getTime()), cal));
    }

    @Override
    public void setTimestamp(Timestamp value) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setDate(new Date(value.getTime()));
    }

    @Override
    public void setDate(Date value, Calendar cal) throws SQLException {
        if (value == DATE_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeDateCalendar(value, cal));
    }

    @Override
    public void setDate(Date value) throws SQLException {
        if (value == DATE_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeDate(value));
    }
}

