/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.TraceManager;

public class FBTraceManager
extends FBServiceManager
implements TraceManager {
    private Map<String, Integer> traceSessions = Collections.synchronizedMap(new HashMap());

    public FBTraceManager() {
    }

    public FBTraceManager(String gdsType) {
        super(gdsType);
    }

    public FBTraceManager(GDSType gdsType) {
        super(gdsType);
    }

    private ServiceRequestBuffer getTraceSPB(int action) throws SQLException {
        ServiceRequestBuffer traceSPB = this.getGds().createServiceRequestBuffer(action);
        return traceSPB;
    }

    private ServiceRequestBuffer getTraceSPB(int action, int traceSessionId) throws SQLException {
        ServiceRequestBuffer traceSPB = this.getTraceSPB(action);
        traceSPB.addArgument(1, traceSessionId);
        return traceSPB;
    }

    private ServiceRequestBuffer getTraceSPB(int action, String traceSessionName, String configuration) throws SQLException {
        ServiceRequestBuffer traceSPB = this.getTraceSPB(action);
        traceSPB.addArgument(2, traceSessionName);
        traceSPB.addArgument(3, configuration);
        return traceSPB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTraceSession(String traceSessionName, String configuration) throws SQLException {
        if (configuration == null || configuration.equals("")) {
            throw new FBSQLException("No configuration provided");
        }
        if (traceSessionName == null) {
            traceSessionName = "";
        }
        FBTraceManager fBTraceManager = this;
        synchronized (fBTraceManager) {
            OutputStream currentLogger = this.getLogger();
            if (currentLogger instanceof TraceStream) {
                currentLogger = ((TraceStream)currentLogger).unwrap();
            }
            this.setLogger(new TraceStream(currentLogger, traceSessionName));
            Thread t = new Thread(new TraceTask(this.getTraceSPB(22, traceSessionName, configuration)));
            t.start();
        }
    }

    @Override
    public void stopTraceSession(int traceSessionId) throws SQLException {
        this.executeServicesOperation(this.getTraceSPB(23, traceSessionId));
    }

    @Override
    public void suspendTraceSession(int traceSessionId) throws SQLException {
        this.executeServicesOperation(this.getTraceSPB(24, traceSessionId));
    }

    @Override
    public void resumeTraceSession(int traceSessionId) throws SQLException {
        this.executeServicesOperation(this.getTraceSPB(25, traceSessionId));
    }

    @Override
    public void listTraceSessions() throws SQLException {
        this.executeServicesOperation(this.getTraceSPB(26));
    }

    @Override
    public Integer getSessionId(String sessionName) {
        return this.traceSessions.get(sessionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String loadConfigurationFromFile(String fileName) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        try {
            String s;
            StringBuilder sb = new StringBuilder(256);
            while ((s = br.readLine()) != null) {
                sb.append(s).append('\n');
            }
            String string = sb.toString();
            return string;
        }
        finally {
            br.close();
        }
    }

    private class TraceStream
    extends FilterOutputStream {
        private static final String START_TEXT = "Trace session ID ";
        private final String sessionName;
        private volatile boolean lookForSessionId;

        public TraceStream(OutputStream out, String sessionName) {
            super(out);
            this.lookForSessionId = true;
            this.sessionName = sessionName;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.lookForSessionId) {
                this.findSessionId(b, off, len);
                this.lookForSessionId = false;
            }
            super.write(b, off, len);
        }

        private void findSessionId(byte[] b, int off, int len) {
            String sessionStart = new String(b, off, len);
            int traceStartIdx = sessionStart.indexOf(START_TEXT);
            int sessionIdStart = -1;
            int sessionIdEnd = -1;
            if (traceStartIdx >= 0 && (sessionIdStart = traceStartIdx + START_TEXT.length()) < sessionStart.length()) {
                sessionIdEnd = sessionStart.indexOf(32, sessionIdStart);
            }
            if (sessionIdStart >= 0 && sessionIdEnd > sessionIdStart && sessionIdEnd < sessionStart.length()) {
                try {
                    int sessionId = Integer.parseInt(sessionStart.substring(sessionIdStart, sessionIdEnd));
                    FBTraceManager.this.traceSessions.put(this.sessionName, sessionId);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }

        public OutputStream unwrap() {
            return this.out;
        }
    }

    private class TraceTask
    implements Runnable {
        private ServiceRequestBuffer srb;

        public TraceTask(ServiceRequestBuffer srb) {
            this.srb = srb;
        }

        @Override
        public void run() {
            try {
                System.out.println("Start trace");
                FBTraceManager.this.executeServicesOperation(this.srb);
                System.out.println("Trace stopped");
            }
            catch (FBSQLException fBSQLException) {
                // empty catch block
            }
        }
    }
}

