/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import javax.resource.ResourceException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.jca.FBResourceException;

public class FBSQLException
extends SQLException {
    private static final long serialVersionUID = 8157410954186424083L;
    public static final String SQL_STATE_INVALID_CONN_ATTR = "01S00";
    public static final String SQL_STATE_NO_ROW_AVAIL = "01S06";
    public static final String SQL_STATE_GENERAL_ERROR = "HY000";
    public static final String SQL_STATE_INVALID_COLUMN = "HY002";
    public static final String SQL_STATE_INVALID_ARG_VALUE = "HY009";
    public static final String SQL_STATE_INVALID_OPTION_IDENTIFIER = "HY092";
    public static final String SQL_STATE_INVALID_PARAM_TYPE = "HY105";
    public static final String SQL_STATE_WRONG_PARAM_NUM = "07001";
    public static final String SQL_STATE_NO_RESULT_SET = "07005";
    public static final String SQL_STATE_INVALID_CONVERSION = "07006";
    public static final String SQL_STATE_INVALID_TX_STATE = "25000";
    public static final String SQL_STATE_INVALID_STATEMENT_ID = "26000";
    public static final String SQL_STATE_CONNECTION_CLOSED = "08003";
    public static final String SQL_STATE_CONNECTION_FAILURE = "08006";
    public static final String SQL_STATE_CONNECTION_FAILURE_IN_TX = "08007";
    public static final String SQL_STATE_COMM_LINK_FAILURE = "08S01";

    public FBSQLException(Exception ex) {
        this("Exception. " + ex.getMessage());
        this.initCause(ex);
    }

    public FBSQLException(GDSException ex) {
        super(FBSQLException.createGDSExceptionMessage(ex), FBSQLException.defaultSQLStateIfNull(ex.getSQLState()), ex.getIntParam());
        this.initCause(ex);
    }

    public FBSQLException(ResourceException ex) {
        super(FBSQLException.createResourceMessage(ex), FBSQLException.defaultSQLStateIfNull(ex.getErrorCode()), FBSQLException.getSqlErrorCode(ex));
        Throwable cause = FBSQLException.resolveCause(ex);
        this.initCause(cause);
    }

    public FBSQLException(String message) {
        super(message, SQL_STATE_GENERAL_ERROR);
    }

    public FBSQLException(String message, SQLException ex) {
        this(message);
        this.setNextException(ex);
    }

    public FBSQLException(String message, String sqlState) {
        super(message, FBSQLException.defaultSQLStateIfNull(sqlState));
    }

    public Exception getInternalException() {
        return (Exception)this.getCause();
    }

    private static String createResourceMessage(ResourceException ex) {
        Throwable cause = FBSQLException.resolveCause(ex);
        if (cause instanceof GDSException) {
            return FBSQLException.createGDSExceptionMessage((GDSException)cause);
        }
        return "Resource Exception. " + ex.getMessage();
    }

    private static String createGDSExceptionMessage(GDSException ex) {
        return "GDS Exception. " + ex.getIntParam() + ". " + ex.getMessage();
    }

    private static int getSqlErrorCode(ResourceException ex) {
        Throwable cause = FBSQLException.resolveCause(ex);
        if (cause instanceof GDSException) {
            return ((GDSException)cause).getIntParam();
        }
        return 0;
    }

    private static Throwable resolveCause(ResourceException ex) {
        if (ex instanceof FBResourceException && ex.getLinkedException() != null) {
            return ex.getLinkedException();
        }
        return ex;
    }

    public static String defaultSQLStateIfNull(String sqlState) {
        return sqlState != null ? sqlState : SQL_STATE_GENERAL_ERROR;
    }
}

