/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import java.io.ByteArrayOutputStream;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.jni.ParameterBufferBase;

class ServiceRequestBufferImp
extends ParameterBufferBase
implements ServiceRequestBuffer {
    private int taskIdentifier;

    ServiceRequestBufferImp(int taskIdentifier) {
        this.taskIdentifier = taskIdentifier;
    }

    @Override
    public void addArgument(int argumentType, String value) {
        this.getArgumentsList().add(new ParameterBufferBase.StringArgument(argumentType, value){

            @Override
            protected void writeLength(int length, ByteArrayOutputStream outputStream) {
                outputStream.write(length);
                outputStream.write(length >> 8);
            }
        });
    }

    @Override
    public void addArgument(int argumentType, int value) {
        this.getArgumentsList().add(new ParameterBufferBase.NumericArgument(argumentType, value){

            @Override
            protected void writeValue(ByteArrayOutputStream outputStream, int value) {
                outputStream.write(value);
                outputStream.write(value >> 8);
                outputStream.write(value >> 16);
                outputStream.write(value >> 24);
            }
        });
    }

    @Override
    public void addArgument(int argumentType, long value) {
        boolean isBigIntSpb;
        boolean bl = isBigIntSpb = argumentType == 49 || argumentType == 50 || argumentType == 51;
        if (isBigIntSpb) {
            this.getArgumentsList().add(new ParameterBufferBase.BigIntArgument(argumentType, value){

                @Override
                protected void writeValue(ByteArrayOutputStream outputStream, long value) {
                    outputStream.write((int)value);
                    outputStream.write((int)(value >> 8));
                    outputStream.write((int)(value >> 16));
                    outputStream.write((int)(value >> 24));
                    outputStream.write((int)(value >> 32));
                    outputStream.write((int)(value >> 40));
                    outputStream.write((int)(value >> 48));
                    outputStream.write((int)(value >> 56));
                }
            });
        } else {
            this.addArgument(argumentType, (int)value);
        }
    }

    @Override
    public void addArgument(int argumentType, byte value) {
        this.getArgumentsList().add(new ParameterBufferBase.NumericArgument(argumentType, value){

            @Override
            protected void writeValue(ByteArrayOutputStream outputStream, int value) {
                outputStream.write(value);
            }
        });
    }

    byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.taskIdentifier);
        super.writeArgumentsTo(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

