/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.impl.wire.Xdrable;

public final class XdrOutputStream
extends OutputStream {
    private static final int BUF_SIZE = Short.MAX_VALUE;
    public static final int SPACE_BYTE = 32;
    public static final int NULL_BYTE = 0;
    private static final int TEXT_PAD_LENGTH = Short.MAX_VALUE;
    private static final byte[] TEXT_PAD = XdrOutputStream.createPadding(Short.MAX_VALUE, 32);
    private static final int ZERO_PAD_LENGTH = 3;
    private static final byte[] ZERO_PADDING = new byte[3];
    private OutputStream out;
    private final byte[] writeBuffer = new byte[8];

    public XdrOutputStream(OutputStream out) {
        this(out, true);
    }

    public XdrOutputStream(OutputStream out, boolean buffered) {
        this.out = buffered ? new BufferedOutputStream(out, Short.MAX_VALUE) : out;
    }

    public void writeAlignment(int length) throws IOException {
        this.out.write(ZERO_PADDING, 0, 4 - length & 3);
    }

    public void writeZeroPadding(int length) throws IOException {
        byte[] padding = length <= 3 ? ZERO_PADDING : new byte[length];
        this.out.write(padding, 0, length);
    }

    public void writeSpacePadding(int length) throws IOException {
        byte[] padding = length <= Short.MAX_VALUE ? TEXT_PAD : XdrOutputStream.createPadding(length, 32);
        this.out.write(padding, 0, length);
    }

    public void writePadding(int length, int padByte) throws IOException {
        byte[] padding = padByte == 32 && length <= TEXT_PAD.length ? TEXT_PAD : (padByte == 0 && length <= ZERO_PADDING.length ? ZERO_PADDING : XdrOutputStream.createPadding(length, (byte)padByte));
        this.out.write(padding, 0, length);
    }

    private static byte[] createPadding(int length, int padByte) {
        byte[] padding = new byte[length];
        Arrays.fill(padding, (byte)padByte);
        return padding;
    }

    public void writeBuffer(byte[] buffer) throws IOException {
        if (buffer == null) {
            this.writeInt(0);
        } else {
            int len = buffer.length;
            this.writeInt(len);
            this.write(buffer, 0, len, 4 - len & 3);
        }
    }

    public void writeString(String s, Encoding encoding) throws IOException {
        if (encoding != null) {
            byte[] buffer = encoding.encodeToCharset(s);
            this.writeBuffer(buffer);
        } else {
            this.writeBuffer(s.getBytes());
        }
    }

    public void writeTyped(int type, Xdrable item) throws IOException {
        int size;
        if (item == null) {
            this.writeInt(1);
            this.write(type);
            size = 1;
        } else {
            size = item.getLength() + 1;
            this.writeInt(size);
            this.write(type);
            item.write(this);
        }
        this.writeAlignment(size);
    }

    public void writeTyped(ParameterBuffer parameterBuffer) throws IOException {
        this.writeTyped(parameterBuffer.getType(), parameterBuffer.toXdrable());
    }

    public void writeLong(long v) throws IOException {
        byte[] buffer = this.writeBuffer;
        buffer[0] = (byte)(v >>> 56);
        buffer[1] = (byte)(v >>> 48);
        buffer[2] = (byte)(v >>> 40);
        buffer[3] = (byte)(v >>> 32);
        buffer[4] = (byte)(v >>> 24);
        buffer[5] = (byte)(v >>> 16);
        buffer[6] = (byte)(v >>> 8);
        buffer[7] = (byte)v;
        this.out.write(buffer, 0, 8);
    }

    public void writeInt(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v & 0xFF);
    }

    public void write(byte[] b, int offset, int len, int pad) throws IOException {
        this.out.write(b, offset, len);
        this.writeSpacePadding(pad);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void setArc4Key(byte[] key) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        if (this.out instanceof CipherOutputStream) {
            throw new IOException("Output stream already encrypted");
        }
        Cipher rc4 = Cipher.getInstance("ARCFOUR");
        SecretKeySpec rc4Key = new SecretKeySpec(key, "ARCFOUR");
        rc4.init(1, rc4Key);
        this.out = new CipherOutputStream(this.out, rc4);
    }
}

