/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ClumpletReader;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.wire.AbstractWireOperations;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.ProtocolCollection;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.gds.ng.wire.crypt.KnownServerKey;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class WireConnection<T extends IAttachProperties<T>, C extends FbWireAttachment>
extends AbstractConnection<T, C>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(WireConnection.class);
    private final ClientAuthBlock clientAuthBlock;
    private final List<KnownServerKey> knownServerKeys = new ArrayList<KnownServerKey>(1);
    private Socket socket;
    private ProtocolCollection protocols;
    private int protocolVersion;
    private int protocolArchitecture;
    private int protocolMinimumType;
    private XdrOutputStream xdrOut;
    private XdrInputStream xdrIn;
    private final XdrStreamAccess streamAccess = new XdrStreamAccess(){

        @Override
        public XdrInputStream getXdrIn() throws SQLException {
            if (WireConnection.this.isConnected() && WireConnection.this.xdrIn != null) {
                return WireConnection.this.xdrIn;
            }
            throw new SQLException("Connection closed or no connection available");
        }

        @Override
        public XdrOutputStream getXdrOut() throws SQLException {
            if (WireConnection.this.isConnected() && WireConnection.this.xdrOut != null) {
                return WireConnection.this.xdrOut;
            }
            throw new SQLException("Connection closed or no connection available");
        }
    };

    protected WireConnection(T attachProperties) throws SQLException {
        this(attachProperties, EncodingFactory.getPlatformDefault(), ProtocolCollection.getDefaultCollection());
    }

    protected WireConnection(T attachProperties, IEncodingFactory encodingFactory, ProtocolCollection protocols) throws SQLException {
        super(attachProperties, encodingFactory);
        this.protocols = protocols;
        this.clientAuthBlock = new ClientAuthBlock(this.attachProperties);
    }

    public final boolean isConnected() {
        return this.socket != null && !this.socket.isClosed();
    }

    public final int getProtocolVersion() {
        return this.protocolVersion;
    }

    public final int getProtocolArchitecture() {
        return this.protocolArchitecture;
    }

    public final int getProtocolMinimumType() {
        return this.protocolMinimumType;
    }

    public final ClientAuthBlock getClientAuthBlock() {
        return this.clientAuthBlock;
    }

    public final void setSoTimeout(int socketTimeout) throws SQLException {
        this.attachProperties.setSoTimeout(socketTimeout);
        this.resetSocketTimeout();
    }

    public final void resetSocketTimeout() throws SQLException {
        if (this.isConnected()) {
            try {
                int desiredTimeout;
                int soTimeout = this.attachProperties.getSoTimeout();
                int n = desiredTimeout = soTimeout != -1 ? soTimeout : 0;
                if (this.socket.getSoTimeout() != desiredTimeout) {
                    this.socket.setSoTimeout(desiredTimeout);
                }
            }
            catch (SocketException e) {
                throw new SQLException("Unable to change socket timeout (SO_TIMEOUT)", e);
            }
        }
    }

    public final void socketConnect() throws SQLException {
        try {
            int socketConnectTimeout;
            this.socket = new Socket();
            this.socket.setTcpNoDelay(true);
            int connectTimeout = this.attachProperties.getConnectTimeout();
            if (connectTimeout != -1) {
                socketConnectTimeout = (int)TimeUnit.SECONDS.toMillis(connectTimeout);
                this.socket.setSoTimeout(socketConnectTimeout);
            } else {
                socketConnectTimeout = 0;
                this.socket.setSoTimeout(Math.max(this.attachProperties.getSoTimeout(), 0));
            }
            int socketBufferSize = this.attachProperties.getSocketBufferSize();
            if (socketBufferSize != -1) {
                this.socket.setReceiveBufferSize(socketBufferSize);
                this.socket.setSendBufferSize(socketBufferSize);
            }
            this.socket.connect(new InetSocketAddress(this.getServerName(), this.getPortNumber()), socketConnectTimeout);
        }
        catch (SocketTimeoutException ste) {
            throw new FbExceptionBuilder().timeoutException(335544721).messageParameter(this.getServerName()).cause(ste).toSQLException();
        }
        catch (IOException ioex) {
            throw new FbExceptionBuilder().nonTransientConnectionException(335544721).messageParameter(this.getServerName()).cause(ioex).toSQLException();
        }
    }

    public final XdrStreamAccess getXdrStreamAccess() {
        return this.streamAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final C identify() throws SQLException {
        try {
            this.xdrIn = new XdrInputStream(this.socket.getInputStream());
            this.xdrOut = new XdrOutputStream(this.socket.getOutputStream());
            this.xdrOut.writeInt(1);
            this.xdrOut.writeInt(19);
            this.xdrOut.writeInt(3);
            this.xdrOut.writeInt(1);
            this.xdrOut.writeString(this.getAttachObjectName(), this.getEncoding());
            this.xdrOut.writeInt(this.protocols.getProtocolCount());
            this.xdrOut.writeBuffer(this.createUserIdentificationBlock());
            for (ProtocolDescriptor protocol : this.protocols) {
                this.xdrOut.writeInt(protocol.getVersion());
                this.xdrOut.writeInt(protocol.getArchitecture());
                this.xdrOut.writeInt(protocol.getMinimumType());
                this.xdrOut.writeInt(protocol.getMaximumType());
                this.xdrOut.writeInt(protocol.getWeight());
            }
            this.xdrOut.flush();
            int operation = this.readNextOperation();
            if (operation == 3 || operation == 98 || operation == 94) {
                FbWireAttachment.AcceptPacket acceptPacket = new FbWireAttachment.AcceptPacket();
                acceptPacket.operation = operation;
                this.protocolVersion = this.xdrIn.readInt();
                this.protocolArchitecture = this.xdrIn.readInt();
                this.protocolMinimumType = this.xdrIn.readInt();
                if (this.protocolVersion < 0) {
                    this.protocolVersion = this.protocolVersion & Short.MAX_VALUE | 0x8000;
                }
                if (operation == 98 || operation == 94) {
                    acceptPacket.p_acpt_data = this.xdrIn.readBuffer();
                    byte[] data = acceptPacket.p_acpt_data;
                    acceptPacket.p_acpt_plugin = this.xdrIn.readString(this.getEncoding());
                    int isAuthenticated = this.xdrIn.readInt();
                    acceptPacket.p_acpt_keys = this.xdrIn.readBuffer();
                    byte[] serverKeys = acceptPacket.p_acpt_keys;
                    this.clientAuthBlock.setServerData(data);
                    this.clientAuthBlock.setAuthComplete(isAuthenticated == 1);
                    this.addServerKeys(serverKeys);
                    this.clientAuthBlock.resetClient(serverKeys);
                    this.clientAuthBlock.switchPlugin(acceptPacket.p_acpt_plugin);
                } else {
                    this.clientAuthBlock.resetClient(null);
                }
                ProtocolDescriptor descriptor = this.protocols.getProtocolDescriptor(this.protocolVersion);
                if (descriptor == null) {
                    throw new SQLException(String.format("Unsupported or unexpected protocol version %d connecting to database %s. Supported version(s): %s", this.protocolVersion, this.getServerName(), this.protocols.getProtocolVersions()));
                }
                C connectionHandle = this.createConnectionHandle(descriptor);
                if (operation == 98) {
                    connectionHandle.authReceiveResponse(acceptPacket);
                }
                return connectionHandle;
            }
            try {
                if (operation == 9) {
                    AbstractWireOperations wireOperations = this.getDefaultWireOperations();
                    wireOperations.processResponse(wireOperations.processOperation(operation));
                }
            }
            finally {
                try {
                    this.close();
                }
                catch (Exception ex) {
                    log.debug("Ignoring exception on disconnect in connect phase of protocol", ex);
                }
            }
            throw new FbExceptionBuilder().exception(335544421).toFlatSQLException();
        }
        catch (SocketTimeoutException ste) {
            throw new FbExceptionBuilder().timeoutException(335544721).messageParameter(this.getServerName()).cause(ste).toSQLException();
        }
        catch (IOException ioex) {
            throw new FbExceptionBuilder().exception(335544721).messageParameter(this.getServerName()).cause(ioex).toSQLException();
        }
    }

    private byte[] createUserIdentificationBlock() throws IOException, SQLException {
        byte[] userBytes = WireConnection.getSystemUserName().getBytes(StandardCharsets.UTF_8);
        byte[] hostBytes = WireConnection.getSystemHostName().getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream userId = new ByteArrayOutputStream();
        this.clientAuthBlock.authenticateStep0();
        this.clientAuthBlock.writePluginDataTo(userId);
        userId.write(11);
        VaxEncoding.encodeVaxInteger(userId, this.attachProperties.getWireCrypt().getWireProtocolCryptLevel());
        userId.write(1);
        int userLength = Math.min(userBytes.length, 255);
        userId.write(userLength);
        userId.write(userBytes, 0, userLength);
        userId.write(4);
        int hostLength = Math.min(hostBytes.length, 255);
        userId.write(hostLength);
        userId.write(hostBytes, 0, hostLength);
        userId.write(6);
        userId.write(0);
        return userId.toByteArray();
    }

    void addServerKeys(byte[] serverKeys) throws SQLException {
        ClumpletReader newKeys = new ClumpletReader(ClumpletReader.Kind.UnTagged, serverKeys);
        newKeys.rewind();
        while (!newKeys.isEof()) {
            if (newKeys.getClumpTag() != 2) {
                int currentTag = newKeys.getClumpTag();
                if (currentTag != 0) {
                    throw new SQLException("Unexpected tag type: " + currentTag);
                }
                String keyType = newKeys.getString(StandardCharsets.US_ASCII);
                newKeys.moveNext();
                if (newKeys.isEof()) break;
                currentTag = newKeys.getClumpTag();
                if (currentTag != 1) {
                    throw new SQLException("Unexpected tag type: " + currentTag);
                }
                String keyPlugins = newKeys.getString(StandardCharsets.US_ASCII);
                this.knownServerKeys.add(new KnownServerKey(keyType, keyPlugins));
            }
            newKeys.moveNext();
        }
    }

    void clearServerKeys() {
        this.knownServerKeys.clear();
    }

    private AbstractWireOperations getDefaultWireOperations() {
        ProtocolDescriptor protocolDescriptor = this.protocols.getProtocolDescriptor(10);
        return (AbstractWireOperations)protocolDescriptor.createWireOperations(this, null, this);
    }

    protected abstract C createConnectionHandle(ProtocolDescriptor var1);

    public final int readNextOperation() throws IOException {
        int op;
        while ((op = this.xdrIn.readInt()) == 71) {
        }
        return op;
    }

    @Override
    public final void close() throws IOException {
        block12: {
            IOException ioex = null;
            try {
                block14: {
                    block13: {
                        if (this.socket == null) break block12;
                        try {
                            if (this.xdrOut != null) {
                                this.xdrOut.close();
                            }
                        }
                        catch (IOException ex) {
                            ioex = ex;
                        }
                        try {
                            if (this.xdrIn != null) {
                                this.xdrIn.close();
                            }
                        }
                        catch (IOException ex) {
                            if (ioex != null) break block13;
                            ioex = ex;
                        }
                    }
                    try {
                        this.socket.close();
                    }
                    catch (IOException ex) {
                        if (ioex != null) break block14;
                        ioex = ex;
                    }
                }
                if (ioex != null) {
                    throw ioex;
                }
            }
            finally {
                this.xdrOut = null;
                this.xdrIn = null;
                this.socket = null;
                this.protocols = null;
            }
        }
    }

    protected final void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private static String getSystemUserName() {
        try {
            return WireConnection.getSystemPropertyPrivileged("user.name");
        }
        catch (SecurityException ex) {
            log.debug("Unable to retrieve user.name property", ex);
            return "jaybird";
        }
    }

    private static String getSystemHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException ex1) {
                return "127.0.0.1";
            }
        }
    }

    private static String getSystemPropertyPrivileged(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
    }

    public final void writeDirect(byte[] data) throws IOException {
        this.xdrOut.writeDirect(data);
    }

    final List<EncryptionIdentifier> getEncryptionIdentifiers() {
        if (this.knownServerKeys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EncryptionIdentifier> encryptionIdentifiers = new ArrayList<EncryptionIdentifier>();
        for (KnownServerKey knownServerKey : this.knownServerKeys) {
            encryptionIdentifiers.addAll(knownServerKey.getIdentifiers());
        }
        return encryptionIdentifiers;
    }
}

