/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.firebirdsql.jdbc.FBSQLException;

public class FBProcedureParam
implements Cloneable {
    private boolean isParam;
    private boolean isLiteral;
    private Object value;
    private String paramValue;
    private int position;
    private int type;
    private int index = -1;
    private boolean valueSet;

    public FBProcedureParam() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public FBProcedureParam(int position, String paramValue) {
        this.position = position;
        this.isLiteral = paramValue.startsWith("'") && paramValue.endsWith("'");
        this.isParam = !this.isLiteral && paramValue.indexOf(63) >= 0;
        this.paramValue = paramValue.trim();
    }

    public boolean isParam() {
        return this.isParam;
    }

    public int getPosition() {
        return this.position;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) throws SQLException {
        if (!this.isParam) {
            throw new FBSQLException("Cannot set parameter, since it is constant.", "HY105");
        }
        this.value = value;
        this.valueSet = true;
    }

    public boolean isValueSet() {
        return this.valueSet;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FBProcedureParam)) {
            return false;
        }
        FBProcedureParam that = (FBProcedureParam)obj;
        return this.position == that.position && this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        int hashCode = 887;
        hashCode = 31 * hashCode + this.position;
        hashCode = 31 * hashCode + (this.value != null ? this.value.hashCode() : 0);
        return hashCode;
    }
}

