/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.Statement;
import org.firebirdsql.pool.PooledConnectionHandler;
import org.firebirdsql.pool.ResultSetHandler;

public class StatementHandler
implements InvocationHandler {
    private static final Method STATEMENT_CLOSE = PooledConnectionHandler.findMethod(Statement.class, "close", new Class[0]);
    private PooledConnectionHandler connectionHandler;
    private Statement wrappedObject;
    private Statement proxy;

    public StatementHandler(PooledConnectionHandler connectionHandler, Statement wrappedObject) {
        this.connectionHandler = connectionHandler;
        this.wrappedObject = wrappedObject;
        this.proxy = (Statement)Proxy.newProxyInstance(wrappedObject.getClass().getClassLoader(), PooledConnectionHandler.getAllInterfaces(wrappedObject.getClass()), (InvocationHandler)this);
    }

    public Statement getProxy() {
        return this.proxy;
    }

    public Statement getWrappedObject() {
        return this.wrappedObject;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (STATEMENT_CLOSE.equals(method)) {
            this.connectionHandler.forgetStatement(this);
        }
        try {
            Object result = method.invoke((Object)this.wrappedObject, args);
            if (result instanceof ResultSet) {
                ResultSetHandler handler = new ResultSetHandler((Statement)proxy, (ResultSet)result);
                result = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)handler);
            }
            return result;
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }
}

