/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.tz;

import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.StringUtils;

public final class TimeZoneMapping {
    private final Logger logger = LoggerFactory.getLogger(TimeZoneMapping.class);
    private static final TimeZoneMapping INSTANCE = new TimeZoneMapping();
    private static final int MAX_ZONE_ID = 65535;
    private static final int MAX_OFFSET = 1439;
    private static final int MIN_OFFSET = -1439;
    private static final int MAX_OFFSET_SUPPORTED = 1080;
    private static final int MIN_OFFSET_SUPPORTED = -1080;
    private static final int MAX_OFFSET_ENCODED = 2878;
    private static final int OFFSET_CORRECTION = 1439;
    private static final int OFFSET_UTC = 0;
    private static final int OFFSET_UTC_ENCODED = 1439;
    private static final int MAX_OFFSET_SUPPORTED_ENCODED = 2519;
    private static final int MIN_OFFSET_SUPPORTED_ENCODED = 359;
    private static final int MAX_CACHED_ZONE_OFFSETS = 24;
    private static final int MAX_CACHED_NAMED_ZONES = 10;
    private static final String FALLBACK_ZONE = "UTC";
    private static final ZoneId FALLBACK_ZONE_ID = ZoneOffset.UTC;
    private static final String KEY_MIN_ZONE_ID = "min_zone_id";
    private static final String FIREBIRD_TIME_ZONE_MAPPING_PROPERTIES = "firebird_time_zone_mapping.properties";
    private final List<String> timeZoneNameById = TimeZoneMapping.loadTimeZoneNameById();
    private final Map<Integer, ZoneOffset> offsetCache = new ConcurrentHashMap<Integer, ZoneOffset>(24);
    private final Map<Integer, ZoneId> namedZoneCache = new ConcurrentHashMap<Integer, ZoneId>(10);

    public static TimeZoneMapping getInstance() {
        return INSTANCE;
    }

    public ZoneId timeZoneById(int timeZoneId) {
        if (timeZoneId < 0 || timeZoneId > 65535) {
            return this.defaultForOutOfRange(timeZoneId);
        }
        return timeZoneId > 2878 ? this.namedTimeZoneById(timeZoneId) : this.offsetTimeZoneFromId(timeZoneId);
    }

    public boolean isOffsetTimeZone(int timeZoneId) {
        return timeZoneId >= 0 && timeZoneId <= 2878;
    }

    public boolean isSupportedOffsetTimezone(int timeZoneId) {
        return timeZoneId >= 359 && timeZoneId <= 2519;
    }

    public int toOffsetMinutes(int timeZoneId) {
        if (this.isOffsetTimeZone(timeZoneId)) {
            return this.getOffsetMinutesUnchecked(timeZoneId);
        }
        this.logInvalidOffsetTimeZoneId(timeZoneId);
        return 0;
    }

    private void logInvalidOffsetTimeZoneId(int timeZoneId) {
        if (this.logger.isWarnEnabled()) {
            String message = "Provided timezone id " + timeZoneId + " is not a valid offset time zone. Valid range is [0, 2878]. Returning offset 0 (UTC) instead.";
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(message, new RuntimeException("debugging stacktrace"));
            } else {
                this.logger.warn(message + " See debug level for location.");
            }
        }
    }

    public int toTimeZoneId(ZoneOffset zoneOffset) {
        return this.toTimeZoneId(zoneOffset.getTotalSeconds() / 60);
    }

    public int toTimeZoneId(int offsetMinutes) {
        if (offsetMinutes < -1439 || offsetMinutes > 1439) {
            this.logInvalidOffsetMinutes(offsetMinutes);
            return 1439;
        }
        return 1439 + offsetMinutes;
    }

    private void logInvalidOffsetMinutes(int offsetMinutes) {
        if (this.logger.isWarnEnabled()) {
            String message = "Offset value " + offsetMinutes + " out of range [-1439, 1439]. Returning id for offset 0 instead.";
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(message, new RuntimeException("debugging stacktrace"));
            } else {
                this.logger.warn(message + " See debug level for location");
            }
        }
    }

    private ZoneId offsetTimeZoneFromId(int timeZoneId) {
        if (timeZoneId < 359 || timeZoneId > 2519) {
            return FALLBACK_ZONE_ID;
        }
        Integer key = timeZoneId;
        ZoneOffset offsetId = this.offsetCache.get(key);
        if (offsetId != null) {
            return offsetId;
        }
        offsetId = this.calculateOffsetTimeZone(timeZoneId);
        this.cacheOffset(key, offsetId);
        return offsetId;
    }

    private void cacheOffset(Integer key, ZoneOffset offsetId) {
        if (this.offsetCache.size() > 24) {
            this.offsetCache.clear();
        }
        this.offsetCache.put(key, offsetId);
    }

    private ZoneOffset calculateOffsetTimeZone(int timeZoneId) {
        int offset = Math.abs(this.getOffsetMinutesUnchecked(timeZoneId));
        int negative = timeZoneId < 1439 ? -1 : 1;
        int hours = negative * (offset / 60);
        int minutes = negative * (offset % 60);
        return ZoneOffset.ofHoursMinutes(hours, minutes);
    }

    private int getOffsetMinutesUnchecked(int timeZoneId) {
        return timeZoneId - 1439;
    }

    private ZoneId namedTimeZoneById(int timeZoneId) {
        Integer key = timeZoneId;
        ZoneId zoneId = this.namedZoneCache.get(timeZoneId);
        if (zoneId != null) {
            return zoneId;
        }
        int internalId = TimeZoneMapping.internalId(timeZoneId);
        if (internalId < 0 || internalId >= this.timeZoneNameById.size()) {
            return this.defaultForOutOfRange(timeZoneId);
        }
        String zoneIdName = this.timeZoneNameById.get(internalId);
        zoneId = zoneIdName != null ? ZoneId.of(zoneIdName, ZoneId.SHORT_IDS) : this.defaultForOutOfRange(timeZoneId);
        this.cacheNamedZone(key, zoneId);
        return zoneId;
    }

    private void cacheNamedZone(Integer key, ZoneId zoneId) {
        if (this.namedZoneCache.size() > 10) {
            this.namedZoneCache.clear();
        }
        this.namedZoneCache.put(key, zoneId);
    }

    private ZoneId defaultForOutOfRange(int timeZoneId) {
        this.logOutOfRange(timeZoneId);
        return FALLBACK_ZONE_ID;
    }

    private void logOutOfRange(int timeZoneId) {
        if (this.logger.isWarnEnabled()) {
            String message = "Unmapped or out of range timezone id received, defaulting to UTC, was id: " + timeZoneId + ".";
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(message, new RuntimeException("debugging stacktrace"));
            } else {
                this.logger.warn(message + " See debug level for location.");
            }
        }
    }

    private static int internalId(int timeZoneId) {
        return 65535 - timeZoneId;
    }

    private static int timeZoneId(int internalId) {
        return 65535 - internalId;
    }

    private static List<String> loadTimeZoneNameById() {
        List<String> list;
        block9: {
            InputStream in = TimeZoneMapping.class.getResourceAsStream(FIREBIRD_TIME_ZONE_MAPPING_PROPERTIES);
            try {
                Properties timeZoneMapping = new Properties();
                timeZoneMapping.load(in);
                int minZoneId = Integer.parseInt(timeZoneMapping.getProperty(KEY_MIN_ZONE_ID));
                int zoneIdCount = TimeZoneMapping.internalId(minZoneId) + 1;
                String[] zonesById = new String[zoneIdCount];
                for (int internalId = 0; internalId < zoneIdCount; ++internalId) {
                    String timeZoneId = String.valueOf(TimeZoneMapping.timeZoneId(internalId));
                    String timeZoneName = StringUtils.trimToNull(timeZoneMapping.getProperty(timeZoneId));
                    zonesById[internalId] = timeZoneName != null ? timeZoneName : FALLBACK_ZONE;
                }
                list = Collections.unmodifiableList(Arrays.asList(zonesById));
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(TimeZoneMapping.class).warn("Unable to load Firebird time zone id to name mapping, only offset timezone support will be available ", e);
                    return Collections.singletonList("GMT");
                }
            }
            in.close();
        }
        return list;
    }
}

