/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Map;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class AbstractFieldMetaData
implements Wrapper {
    private static final int SUBTYPE_NUMERIC = 1;
    private static final int SUBTYPE_DECIMAL = 2;
    private final RowDescriptor rowDescriptor;
    private final FBConnection connection;
    private Map<FieldKey, ExtendedFieldInfo> extendedInfo;

    protected AbstractFieldMetaData(RowDescriptor rowDescriptor, FBConnection connection) {
        assert (rowDescriptor != null) : "rowDescriptor is required";
        this.rowDescriptor = rowDescriptor;
        this.connection = connection;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Unable to unwrap to class " + iface.getName());
        }
        return iface.cast(this);
    }

    protected final RowDescriptor getRowDescriptor() {
        return this.rowDescriptor;
    }

    protected final int getFieldCount() {
        return this.rowDescriptor.getCount();
    }

    protected final FieldDescriptor getFieldDescriptor(int fieldIndex) {
        return this.rowDescriptor.getFieldDescriptor(fieldIndex - 1);
    }

    protected final boolean isSignedInternal(int field) {
        switch (this.getFieldDescriptor(field).getType() & 0xFFFFFFFE) {
            case 480: 
            case 482: 
            case 496: 
            case 500: 
            case 530: 
            case 580: 
            case 32752: 
            case 32760: 
            case 32762: {
                return true;
            }
        }
        return false;
    }

    protected final int getScaleInternal(int field) {
        return this.getFieldDescriptor(field).getScale() * -1;
    }

    protected final String getFieldClassName(int field) throws SQLException {
        switch (this.getFieldType(field)) {
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 2004: {
                return "java.sql.Blob";
            }
            case 2005: {
                return "java.sql.Clob";
            }
            case -4: 
            case -3: 
            case -2: {
                return "[B";
            }
            case 2003: {
                return "java.sql.Array";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 2013: {
                return "java.time.OffsetTime";
            }
            case 2014: {
                return "java.time.OffsetDateTime";
            }
            case -6001: 
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 16: {
                return "java.lang.Boolean";
            }
            case 0: 
            case 1111: {
                return "java.lang.Object";
            }
            case -8: {
                return "java.sql.RowId";
            }
        }
        throw new FBSQLException("Unknown SQL type.", "HY105");
    }

    protected final String getFieldTypeName(int field) {
        int sqlType = this.getFieldDescriptor(field).getType() & 0xFFFFFFFE;
        int sqlScale = this.getFieldDescriptor(field).getScale();
        int sqlSubtype = this.getFieldDescriptor(field).getSubType();
        switch (sqlType) {
            case 500: {
                if (sqlSubtype == 1 || sqlSubtype == 0 && sqlScale < 0) {
                    return "NUMERIC";
                }
                if (sqlSubtype == 2) {
                    return "DECIMAL";
                }
                return "SMALLINT";
            }
            case 496: {
                if (sqlSubtype == 1 || sqlSubtype == 0 && sqlScale < 0) {
                    return "NUMERIC";
                }
                if (sqlSubtype == 2) {
                    return "DECIMAL";
                }
                return "INTEGER";
            }
            case 580: {
                if (sqlSubtype == 1 || sqlSubtype == 0 && sqlScale < 0) {
                    return "NUMERIC";
                }
                if (sqlSubtype == 2) {
                    return "DECIMAL";
                }
                return "BIGINT";
            }
            case 480: 
            case 530: {
                if (sqlSubtype == 1 || sqlSubtype == 0 && sqlScale < 0) {
                    return "NUMERIC";
                }
                if (sqlSubtype == 2) {
                    return "DECIMAL";
                }
                return "DOUBLE PRECISION";
            }
            case 32760: 
            case 32762: {
                return "DECFLOAT";
            }
            case 32752: {
                if (sqlSubtype == 1) {
                    return "NUMERIC";
                }
                return "DECIMAL";
            }
            case 482: {
                return "FLOAT";
            }
            case 452: {
                return "CHAR";
            }
            case 448: {
                return "VARCHAR";
            }
            case 510: {
                return "TIMESTAMP";
            }
            case 560: {
                return "TIME";
            }
            case 570: {
                return "DATE";
            }
            case 32748: 
            case 32754: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case 32750: 
            case 32756: {
                return "TIME WITH TIME ZONE";
            }
            case 520: {
                if (sqlSubtype < 0) {
                    return "BLOB SUB_TYPE <0";
                }
                if (sqlSubtype == 0) {
                    return "BLOB SUB_TYPE 0";
                }
                if (sqlSubtype == 1) {
                    return "BLOB SUB_TYPE 1";
                }
                return "BLOB SUB_TYPE " + sqlSubtype;
            }
            case 550: {
                return "ARRAY";
            }
            case 32764: {
                return "BOOLEAN";
            }
        }
        return "NULL";
    }

    protected int getFieldType(int field) {
        return JdbcTypeConverter.toJdbcType(this.getFieldDescriptor(field));
    }

    protected final int getPrecisionInternal(int field) throws SQLException {
        int colType = this.getFieldType(field);
        switch (colType) {
            case 2: 
            case 3: {
                ExtendedFieldInfo fieldInfo = this.getExtFieldInfo(field);
                return fieldInfo == null || fieldInfo.fieldPrecision == 0 ? this.estimateFixedPrecision(field) : fieldInfo.fieldPrecision;
            }
            case -6001: {
                FieldDescriptor var = this.getFieldDescriptor(field);
                switch (var.getType() & 0xFFFFFFFE) {
                    case 32760: {
                        return 16;
                    }
                    case 32762: {
                        return 34;
                    }
                }
                return 0;
            }
            case 1: 
            case 12: {
                FieldDescriptor var = this.getFieldDescriptor(field);
                EncodingDefinition encodingDefinition = var.getEncodingFactory().getEncodingDefinitionByCharacterSetId(var.getSubType());
                int charSetSize = encodingDefinition != null ? encodingDefinition.getMaxBytesPerChar() : 1;
                return var.getLength() / charSetSize;
            }
            case -3: 
            case -2: {
                FieldDescriptor var = this.getFieldDescriptor(field);
                return var.getLength();
            }
            case 6: {
                if (FirebirdSupportInfo.supportInfoFor(this.connection).supportsFloatBinaryPrecision()) {
                    return 24;
                }
                return 7;
            }
            case 8: {
                if (FirebirdSupportInfo.supportInfoFor(this.connection).supportsFloatBinaryPrecision()) {
                    return 53;
                }
                return 15;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 5: {
                return 5;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 19;
            }
            case 2014: {
                return 30;
            }
            case 2013: {
                return 19;
            }
            case 16: {
                return 1;
            }
        }
        return 0;
    }

    protected final int estimateFixedPrecision(int fieldIndex) {
        int sqltype = this.getFieldDescriptor(fieldIndex).getType() & 0xFFFFFFFE;
        switch (sqltype) {
            case 500: {
                return 4;
            }
            case 496: {
                return 9;
            }
            case 580: {
                return 18;
            }
            case 480: {
                return 18;
            }
            case 32760: {
                return 16;
            }
            case 32762: {
                return 34;
            }
            case 32752: {
                return 38;
            }
        }
        return 0;
    }

    protected final ExtendedFieldInfo getExtFieldInfo(int columnIndex) throws SQLException {
        if (this.extendedInfo == null) {
            this.extendedInfo = this.getExtendedFieldInfo(this.connection);
        }
        FieldKey key = new FieldKey(this.getFieldDescriptor(columnIndex).getOriginalTableName(), this.getFieldDescriptor(columnIndex).getOriginalName());
        return this.extendedInfo.get(key);
    }

    protected abstract Map<FieldKey, ExtendedFieldInfo> getExtendedFieldInfo(FBConnection var1) throws SQLException;

    protected static final class FieldKey {
        private final String relationName;
        private final String fieldName;

        FieldKey(String relationName, String fieldName) {
            this.relationName = relationName;
            this.fieldName = fieldName;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FieldKey)) {
                return false;
            }
            FieldKey that = (FieldKey)obj;
            return (this.relationName != null ? this.relationName.equals(that.relationName) : that.relationName == null) && (this.fieldName != null ? this.fieldName.equals(that.fieldName) : that.fieldName == null);
        }

        public int hashCode() {
            int result = 971;
            result = 23 * result + (this.relationName != null ? this.relationName.hashCode() : 0);
            result = 23 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
            return result;
        }
    }

    protected static class ExtendedFieldInfo {
        final FieldKey fieldKey;
        final int fieldPrecision;

        public ExtendedFieldInfo(String relationName, String fieldName, int precision) {
            this.fieldKey = new FieldKey(relationName, fieldName);
            this.fieldPrecision = precision;
        }
    }
}

