/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.tz;

import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.tz.TimeZoneMapping;
import org.firebirdsql.logging.LoggerFactory;

public class TimeZoneDatatypeCoder {
    private static final int MAX_CACHED = 4;
    private static final Map<DatatypeCoder, TimeZoneDatatypeCoder> instanceCache = new ConcurrentHashMap<DatatypeCoder, TimeZoneDatatypeCoder>(4);
    private final DatatypeCoder datatypeCoder;
    private final TimeZoneMapping timeZoneMapping = TimeZoneMapping.getInstance();
    private final DefaultTimeZoneCodec defaultTimeZoneCodec = new DefaultTimeZoneCodec();
    private ExtendedTimeZoneCodec extendedTimeZoneCodec;

    public TimeZoneDatatypeCoder(DatatypeCoder datatypeCoder) {
        this.datatypeCoder = datatypeCoder;
    }

    public TimeZoneCodec getTimeZoneCodecFor(FieldDescriptor fieldDescriptor) throws SQLException {
        switch (fieldDescriptor.getType() & 0xFFFFFFFE) {
            case 32754: 
            case 32756: {
                return this.defaultTimeZoneCodec;
            }
            case 32748: 
            case 32750: {
                if (this.extendedTimeZoneCodec != null) {
                    return this.extendedTimeZoneCodec;
                }
                this.extendedTimeZoneCodec = new ExtendedTimeZoneCodec();
                return this.extendedTimeZoneCodec;
            }
        }
        throw FbExceptionBuilder.forException(337248277).messageParameter(fieldDescriptor.getType()).toFlatSQLException();
    }

    public OffsetDateTime decodeTimestampTz(byte[] timestampTzBytes) {
        assert (timestampTzBytes.length == 12) : "timestampTzBytes not length 12";
        return this.decodeTimestampTzImpl(timestampTzBytes);
    }

    public OffsetDateTime decodeExTimestampTz(byte[] exTimestampTzBytes) {
        assert (exTimestampTzBytes.length == this.sizeOfExTimestampTz()) : "exTimestampTzBytes wrong length";
        return this.decodeTimestampTzImpl(exTimestampTzBytes);
    }

    private OffsetDateTime decodeTimestampTzImpl(byte[] timestampTzBytes) {
        int encodedDate = this.datatypeCoder.decodeInt(timestampTzBytes);
        int encodedTime = this.datatypeCoder.decodeInt(timestampTzBytes, 4);
        int timeZoneId = this.datatypeCoder.decodeShort(timestampTzBytes, 8) & 0xFFFF;
        DatatypeCoder.RawDateTimeStruct raw = new DatatypeCoder.RawDateTimeStruct(encodedDate, true, encodedTime, true);
        LocalDateTime utcDateTime = LocalDateTime.of(raw.year, raw.month, raw.day, raw.hour, raw.minute, raw.second, raw.getFractionsAsNanos());
        ZoneId zoneId = this.timeZoneMapping.timeZoneById(timeZoneId);
        Instant instant = utcDateTime.toInstant(ZoneOffset.UTC);
        return OffsetDateTime.ofInstant(instant, zoneId);
    }

    public byte[] encodeTimestampTz(OffsetDateTime offsetDateTime) {
        return this.encodeTimestampTzImpl(offsetDateTime, 12);
    }

    public byte[] encodeExTimestampTz(OffsetDateTime offsetDateTime) {
        return this.encodeTimestampTzImpl(offsetDateTime, this.sizeOfExTimestampTz());
    }

    private byte[] encodeTimestampTzImpl(OffsetDateTime offsetDateTime, int bufferSize) {
        int firebirdZoneId = this.timeZoneMapping.toTimeZoneId(offsetDateTime.getOffset());
        OffsetDateTime utcDateTime = offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC);
        DatatypeCoder.RawDateTimeStruct raw = new DatatypeCoder.RawDateTimeStruct();
        raw.year = utcDateTime.getYear();
        raw.month = utcDateTime.getMonthValue();
        raw.day = utcDateTime.getDayOfMonth();
        raw.hour = utcDateTime.getHour();
        raw.minute = utcDateTime.getMinute();
        raw.second = utcDateTime.getSecond();
        raw.setFractionsFromNanos(utcDateTime.getNano());
        byte[] timestampTzBytes = new byte[bufferSize];
        this.datatypeCoder.encodeInt(raw.getEncodedDate(), timestampTzBytes, 0);
        this.datatypeCoder.encodeInt(raw.getEncodedTime(), timestampTzBytes, 4);
        this.datatypeCoder.encodeShort(firebirdZoneId, timestampTzBytes, 8);
        return timestampTzBytes;
    }

    public OffsetTime decodeTimeTz(byte[] timeTzBytes) {
        assert (timeTzBytes.length == 8) : "timeTzBytes not length 8";
        return this.decodeTimeTzImpl(timeTzBytes);
    }

    public OffsetTime decodeExTimeTz(byte[] exTimeTzBytes) {
        assert (exTimeTzBytes.length == this.sizeOfExTimeTz()) : "exTimeTzBytes wrong length";
        return this.decodeTimeTzImpl(exTimeTzBytes);
    }

    OffsetTime decodeTimeTzImpl(byte[] timeTzBytes) {
        int encodedTime = this.datatypeCoder.decodeInt(timeTzBytes);
        int timeZoneId = this.datatypeCoder.decodeShort(timeTzBytes, 4) & 0xFFFF;
        DatatypeCoder.RawDateTimeStruct raw = new DatatypeCoder.RawDateTimeStruct(0, false, encodedTime, true);
        LocalTime utcTime = LocalTime.of(raw.hour, raw.minute, raw.second, raw.getFractionsAsNanos());
        ZoneId zoneId = this.timeZoneMapping.timeZoneById(timeZoneId);
        if (zoneId instanceof ZoneOffset) {
            return OffsetTime.of(utcTime, ZoneOffset.UTC).withOffsetSameInstant((ZoneOffset)zoneId);
        }
        LocalDate utcDate = OffsetDateTime.now(ZoneOffset.UTC).toLocalDate();
        return ZonedDateTime.of(utcDate, utcTime, ZoneOffset.UTC).withZoneSameInstant(zoneId).toOffsetDateTime().toOffsetTime();
    }

    public byte[] encodeTimeTz(OffsetTime offsetTime) {
        return this.encodeTimeTzImpl(offsetTime, 8);
    }

    public byte[] encodeExTimeTz(OffsetTime offsetTime) {
        return this.encodeTimeTzImpl(offsetTime, this.sizeOfExTimeTz());
    }

    private byte[] encodeTimeTzImpl(OffsetTime offsetTime, int bufferSize) {
        int firebirdZoneId = this.timeZoneMapping.toTimeZoneId(offsetTime.getOffset());
        OffsetTime utcTime = offsetTime.withOffsetSameInstant(ZoneOffset.UTC);
        DatatypeCoder.RawDateTimeStruct raw = new DatatypeCoder.RawDateTimeStruct();
        raw.hour = utcTime.getHour();
        raw.minute = utcTime.getMinute();
        raw.second = utcTime.getSecond();
        raw.setFractionsFromNanos(utcTime.getNano());
        byte[] timeTzBytes = new byte[bufferSize];
        this.datatypeCoder.encodeInt(raw.getEncodedTime(), timeTzBytes, 0);
        this.datatypeCoder.encodeShort(firebirdZoneId, timeTzBytes, 4);
        return timeTzBytes;
    }

    private int sizeOfExTimestampTz() {
        return this.datatypeCoder.sizeOfShort() == 4 ? 16 : 12;
    }

    private int sizeOfExTimeTz() {
        return this.datatypeCoder.sizeOfShort() == 4 ? 12 : 8;
    }

    public static TimeZoneDatatypeCoder getInstanceFor(DatatypeCoder datatypeCoder) {
        DatatypeCoder rootCoder = datatypeCoder.unwrap();
        TimeZoneDatatypeCoder cachedValue = instanceCache.get(rootCoder);
        if (cachedValue != null) {
            return cachedValue;
        }
        return TimeZoneDatatypeCoder.createdCachedInstance(rootCoder);
    }

    private static TimeZoneDatatypeCoder createdCachedInstance(DatatypeCoder rootCoder) {
        if (instanceCache.size() > 4) {
            LoggerFactory.getLogger(TimeZoneDatatypeCoder.class).info("Clearing TimeZoneDatatypeCoder.instanceCache");
            instanceCache.clear();
        }
        TimeZoneDatatypeCoder value = new TimeZoneDatatypeCoder(rootCoder);
        instanceCache.putIfAbsent(rootCoder, value);
        return value;
    }

    private class ExtendedTimeZoneCodec
    implements TimeZoneCodec {
        private ExtendedTimeZoneCodec() {
        }

        @Override
        public byte[] encodeOffsetDateTime(OffsetDateTime offsetDateTime) {
            return TimeZoneDatatypeCoder.this.encodeExTimestampTz(offsetDateTime);
        }

        @Override
        public OffsetDateTime decodeOffsetDateTime(byte[] fieldData) {
            return TimeZoneDatatypeCoder.this.decodeExTimestampTz(fieldData);
        }

        @Override
        public byte[] encodeOffsetTime(OffsetTime offsetTime) {
            return TimeZoneDatatypeCoder.this.encodeExTimeTz(offsetTime);
        }

        @Override
        public OffsetTime decodeOffsetTime(byte[] fieldData) {
            return TimeZoneDatatypeCoder.this.decodeExTimeTz(fieldData);
        }
    }

    private class DefaultTimeZoneCodec
    implements TimeZoneCodec {
        private DefaultTimeZoneCodec() {
        }

        @Override
        public byte[] encodeOffsetDateTime(OffsetDateTime offsetDateTime) {
            return TimeZoneDatatypeCoder.this.encodeTimestampTz(offsetDateTime);
        }

        @Override
        public OffsetDateTime decodeOffsetDateTime(byte[] fieldData) {
            return TimeZoneDatatypeCoder.this.decodeTimestampTz(fieldData);
        }

        @Override
        public byte[] encodeOffsetTime(OffsetTime offsetTime) {
            return TimeZoneDatatypeCoder.this.encodeTimeTz(offsetTime);
        }

        @Override
        public OffsetTime decodeOffsetTime(byte[] fieldData) {
            return TimeZoneDatatypeCoder.this.decodeTimeTz(fieldData);
        }
    }

    public static interface TimeZoneCodec {
        public byte[] encodeOffsetDateTime(OffsetDateTime var1);

        public OffsetDateTime decodeOffsetDateTime(byte[] var1);

        public byte[] encodeOffsetTime(OffsetTime var1);

        public OffsetTime decodeOffsetTime(byte[] var1);
    }
}

