/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.fields;

import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;

public class RowValueBuilder {
    private final RowDescriptor rowDescriptor;
    private RowValue rowValue;
    private int currentIndex;

    public RowValueBuilder(RowDescriptor rowDescriptor) {
        this.rowDescriptor = rowDescriptor;
        this.rowValue = rowDescriptor.createDefaultFieldValues();
    }

    public RowValueBuilder setFieldIndex(int index) {
        this.checkBounds(index);
        this.currentIndex = index;
        return this;
    }

    public RowValueBuilder at(int index) {
        return this.setFieldIndex(index);
    }

    public RowValueBuilder set(byte[] fieldData) {
        this.rowValue.setFieldData(this.currentIndex, fieldData);
        return this;
    }

    public byte[] get(int index) {
        this.checkBounds(index);
        return this.rowValue.getFieldData(index);
    }

    public RowValueBuilder reset() {
        this.rowValue = this.rowDescriptor.createDefaultFieldValues();
        return this;
    }

    public int getSize() {
        return this.rowDescriptor.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowValue toRowValue(boolean initialize) {
        try {
            if (initialize) {
                this.rowValue.initializeFields();
            }
            RowValue rowValue = this.rowValue;
            return rowValue;
        }
        finally {
            this.reset();
        }
    }

    private void checkBounds(int index) {
        if (index < 0 || index >= this.rowDescriptor.getCount()) {
            throw new IndexOutOfBoundsException(String.format("The index '%d' exceeds the expected size (%d) of this RowDescriptorBuilder", index, this.rowDescriptor.getCount()));
        }
    }
}

