/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.DefaultStatementListener;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBParameterMetaData;
import org.firebirdsql.jdbc.FBResultSetMetaData;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FirebirdParameterMetaData;
import org.firebirdsql.jdbc.FirebirdPreparedStatement;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FBWorkaroundStringField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public abstract class AbstractPreparedStatement
extends FBStatement
implements FirebirdPreparedStatement {
    public static final String METHOD_NOT_SUPPORTED = "This method is only supported on Statement and not supported on PreparedStatement and CallableStatement";
    private static final String UNICODE_STREAM_NOT_SUPPORTED = "Unicode stream not supported.";
    private final boolean metaDataQuery;
    private final boolean standaloneStatement;
    private final boolean generatedKeys;
    private FBField[] fields = null;
    private boolean isExecuteProcedureStatement;
    private final FBObjectListener.BlobListener blobListener;
    private RowValue fieldValues;
    protected final List<Object> batchList = new ArrayList<Object>();

    protected AbstractPreparedStatement(GDSHelper c, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener, FBObjectListener.BlobListener blobListener) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability, statementListener);
        this.blobListener = blobListener;
        this.standaloneStatement = false;
        this.metaDataQuery = false;
        this.generatedKeys = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractPreparedStatement(GDSHelper c, String sql, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener, FBObjectListener.BlobListener blobListener, boolean metaDataQuery, boolean standaloneStatement, boolean generatedKeys) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability, statementListener);
        this.blobListener = blobListener;
        this.metaDataQuery = metaDataQuery;
        this.standaloneStatement = standaloneStatement;
        this.generatedKeys = generatedKeys;
        Object object = c.getSynchronizationObject();
        synchronized (object) {
            try {
                this.notifyStatementStarted();
                this.prepareFixedStatement(sql);
            }
            catch (RuntimeException | SQLException e) {
                this.notifyStatementCompleted(false);
                throw e;
            }
        }
    }

    @Override
    public void completeStatement(CompletionReason reason) throws SQLException {
        if (!this.metaDataQuery) {
            super.completeStatement(reason);
        } else if (!this.completed) {
            this.notifyStatementCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyStatementCompleted(boolean success) throws SQLException {
        try {
            super.notifyStatementCompleted(success);
        }
        finally {
            if (this.metaDataQuery && this.standaloneStatement) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            this.notifyStatementStarted();
            if (!this.internalExecute(this.isExecuteProcedureStatement)) {
                throw new FBSQLException("No resultset for sql", "07005");
            }
            return this.getResultSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            int n;
            this.checkValidity();
            this.notifyStatementStarted();
            try {
                if (this.internalExecute(this.isExecuteProcedureStatement) && !this.generatedKeys) {
                    throw new FBSQLException("Update statement returned results.");
                }
                n = this.getUpdateCount();
            }
            catch (Throwable throwable) {
                this.notifyStatementCompleted();
                throw throwable;
            }
            this.notifyStatementCompleted();
            return n;
        }
    }

    public FirebirdParameterMetaData getFirebirdParameterMetaData() throws SQLException {
        return new FBParameterMetaData(this.fbStatement.getParameterDescriptor(), this.connection);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getField(parameterIndex).setNull();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.getField(parameterIndex).setBinaryStream(inputStream, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.getField(parameterIndex).setBinaryStream(inputStream, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream) throws SQLException {
        this.getField(parameterIndex).setBinaryStream(inputStream);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getField(parameterIndex).setBytes(x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getField(parameterIndex).setBoolean(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getField(parameterIndex).setByte(x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getField(parameterIndex).setDate(x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getField(parameterIndex).setDouble(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getField(parameterIndex).setFloat(x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getField(parameterIndex).setInteger(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getField(parameterIndex).setLong(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getField(parameterIndex).setObject(x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getField(parameterIndex).setShort(x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.getField(parameterIndex).setString(x);
    }

    public void setStringForced(int parameterIndex, String x) throws SQLException {
        FBField field = this.getField(parameterIndex);
        if (field instanceof FBWorkaroundStringField) {
            ((FBWorkaroundStringField)field).setStringForced(x);
        } else {
            field.setString(x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getField(parameterIndex).setTime(x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getField(parameterIndex).setTimestamp(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getField(parameterIndex).setBigDecimal(x);
    }

    protected FieldDescriptor getParameterDescriptor(int columnIndex) {
        return this.fbStatement.getParameterDescriptor().getFieldDescriptor(columnIndex - 1);
    }

    protected FBField getField(int columnIndex) throws SQLException {
        this.checkValidity();
        if (columnIndex > this.fields.length) {
            throw new SQLException("Invalid column index: " + columnIndex, "HY002");
        }
        return this.fields[columnIndex - 1];
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException(UNICODE_STREAM_NOT_SUPPORTED);
    }

    @Override
    public void setURL(int parameterIndex, URL url) throws SQLException {
        throw new FBDriverNotCapableException("Type URL not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkValidity();
        if (this.fieldValues != null) {
            this.fieldValues.reset();
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            this.notifyStatementStarted();
            boolean hasResultSet = this.internalExecute(this.isExecuteProcedureStatement);
            if (!hasResultSet) {
                this.notifyStatementCompleted();
            }
            return hasResultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet executeMetaDataQuery() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            this.notifyStatementStarted();
            boolean hasResultSet = this.internalExecute(this.isExecuteProcedureStatement);
            if (!hasResultSet) {
                throw new FBSQLException("No result set is available.");
            }
            return this.getResultSet(true);
        }
    }

    protected boolean internalExecute(boolean sendOutParams) throws SQLException {
        this.checkAllParametersSet();
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.flushFields();
            try {
                this.fbStatement.execute(this.fieldValues);
                return this.currentStatementResult == FBStatement.StatementResult.RESULT_SET;
            }
            catch (SQLException e) {
                this.currentStatementResult = FBStatement.StatementResult.NO_MORE_RESULTS;
                throw e;
            }
        }
    }

    private void checkAllParametersSet() throws SQLException {
        this.fbStatement.validateParameters(this.fieldValues);
    }

    @Override
    protected boolean isGeneratedKeyQuery() {
        return this.generatedKeys;
    }

    private void flushFields() throws SQLException {
        for (int i = 0; i < this.fields.length; ++i) {
            FBField field = this.fields[i];
            if (!(field instanceof FBFlushableField)) continue;
            ((FBFlushableField)((Object)field)).flushCachedData();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkValidity();
        this.checkAllParametersSet();
        BatchedRowValue batchedValues = new BatchedRowValue(this.fieldValues.deepCopy());
        for (int i = 0; i < batchedValues.getCount(); ++i) {
            FBField field = this.getField(i + 1);
            if (!(field instanceof FBFlushableField)) continue;
            batchedValues.setCachedObject(i, ((FBFlushableField)((Object)field)).getCachedObject());
        }
        this.batchList.add(batchedValues);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchList.clear();
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<Long> executeBatchInternal() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            boolean commit = false;
            try {
                Object data;
                BatchStatementListener batchStatementListener;
                this.notifyStatementStarted();
                int size = this.batchList.size();
                if (this.generatedKeys) {
                    batchStatementListener = new BatchStatementListener(size);
                    this.fbStatement.addStatementListener(batchStatementListener);
                } else {
                    batchStatementListener = null;
                }
                ArrayList<Long> results = new ArrayList<Long>(size);
                Iterator<Object> iter = this.batchList.iterator();
                try {
                    while (iter.hasNext()) {
                        data = (BatchedRowValue)iter.next();
                        this.executeSingleForBatch((BatchedRowValue)data, results);
                    }
                    commit = true;
                    data = results;
                }
                catch (SQLException ex) {
                    throw jdbcVersionSupport.createBatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), this.toLargeArray(results), ex);
                }
                finally {
                    if (this.generatedKeys) {
                        this.fbStatement.removeStatementListener(batchStatementListener);
                        this.specialResult.clear();
                        this.specialResult.addAll(batchStatementListener.getRows());
                    }
                    this.clearBatch();
                }
                return data;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.notifyStatementCompleted(commit);
            }
        }
    }

    private void executeSingleForBatch(BatchedRowValue data, List<Long> results) throws SQLException {
        this.fieldValues.reset();
        for (int i = 0; i < this.fieldValues.getCount(); ++i) {
            FBField field = this.getField(i + 1);
            if (field instanceof FBFlushableField) {
                ((FBFlushableField)((Object)field)).setCachedObject((FBFlushableField.CachedObject)data.getCachedObject(i));
                continue;
            }
            this.fieldValues.setFieldData(i, data.getFieldData(i));
        }
        if (this.internalExecute(this.isExecuteProcedureStatement)) {
            throw jdbcVersionSupport.createBatchUpdateException("Statements executed as batch should not produce a result set", "07003", 0, this.toLargeArray(results), null);
        }
        results.add(this.getLargeUpdateCount());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getField(parameterIndex).setCharacterStream(reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.getField(parameterIndex).setCharacterStream(reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.getField(parameterIndex).setCharacterStream(reader);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw new FBDriverNotCapableException("Type REF not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        if (blob != null && !(blob instanceof FBBlob)) {
            FBBlob fbb = new FBBlob(this.gdsHelper, this.blobListener);
            fbb.copyStream(blob.getBinaryStream());
            blob = fbb;
        }
        this.getField(parameterIndex).setBlob((FBBlob)blob);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        if (clob != null && !(clob instanceof FBClob)) {
            FBClob fbc = new FBClob(new FBBlob(this.gdsHelper, this.blobListener));
            fbc.copyCharacterStream(clob.getCharacterStream());
            clob = fbc;
        }
        this.getField(parameterIndex).setClob((FBClob)clob);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw new FBDriverNotCapableException("Type ARRAY not yet supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkValidity();
        return new FBResultSetMetaData(this.fbStatement.getRowDescriptor(), this.connection);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setDate(x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setTime(x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setTimestamp(x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    protected void prepareFixedStatement(String sql) throws SQLException {
        super.prepareFixedStatement(sql);
        RowDescriptor rowDescriptor = this.fbStatement.getParameterDescriptor();
        assert (rowDescriptor != null) : "RowDescriptor should not be null after prepare";
        int fieldCount = rowDescriptor.getCount();
        this.fieldValues = rowDescriptor.createDefaultFieldValues();
        this.fields = new FBField[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            final int fieldPosition = i;
            FieldDataProvider dataProvider = new FieldDataProvider(){

                @Override
                public byte[] getFieldData() {
                    return AbstractPreparedStatement.this.fieldValues.getFieldData(fieldPosition);
                }

                @Override
                public void setFieldData(byte[] data) {
                    AbstractPreparedStatement.this.fieldValues.setFieldData(fieldPosition, data);
                }
            };
            this.fields[i] = FBField.createField(this.getParameterDescriptor(i + 1), dataProvider, this.gdsHelper, false);
        }
        this.isExecuteProcedureStatement = this.fbStatement.getType() == StatementType.STORED_PROCEDURE;
    }

    @Override
    public String getExecutionPlan() throws SQLException {
        return super.getExecutionPlan();
    }

    @Override
    public String getExplainedExecutionPlan() throws SQLException {
        return super.getExplainedExecutionPlan();
    }

    @Override
    public int getStatementType() throws SQLException {
        return super.getStatementType();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.getFirebirdParameterMetaData();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setClob(parameterIndex, value);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.getField(parameterIndex).setRowId(x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new FBDriverNotCapableException("Type SQLXML not supported");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndex) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new FBSQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeUpdate();
        return this.getLargeUpdateCount();
    }

    boolean isInitialized() {
        return this.fields != null;
    }

    private static final class BatchedRowValue {
        private final RowValue rowValue;
        private Object[] cachedObjects;

        private BatchedRowValue(RowValue rowValue) {
            this.rowValue = rowValue;
        }

        private int getCount() {
            return this.rowValue.getCount();
        }

        private byte[] getFieldData(int index) {
            return this.rowValue.getFieldData(index);
        }

        private void setCachedObject(int index, Object object) {
            this.checkBounds(index);
            if (this.cachedObjects == null) {
                this.cachedObjects = new Object[this.getCount()];
            }
            this.cachedObjects[index] = object;
        }

        private Object getCachedObject(int index) {
            this.checkBounds(index);
            if (this.cachedObjects == null) {
                return null;
            }
            return this.cachedObjects[index];
        }

        private void checkBounds(int index) {
            if (index < 0 || index >= this.getCount()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }
    }

    private static class BatchStatementListener
    extends DefaultStatementListener {
        private final List<RowValue> rows;

        private BatchStatementListener(int expectedSize) {
            this.rows = new ArrayList<RowValue>(expectedSize);
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            this.rows.add(rowValue);
        }

        public List<RowValue> getRows() {
            return new ArrayList<RowValue>(this.rows);
        }
    }
}

