/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.util.regex.Pattern;
import org.firebirdsql.jdbc.metadata.MetadataPatternMatcher;

public final class MetadataPattern {
    private static final int OBJECT_NAME_PARAMETER_LENGTH = 73;
    private static final MetadataPattern ALL_PATTERN = new MetadataPattern(ConditionType.NONE, null);
    private static final MetadataPattern EMPTY_PATTERN = new MetadataPattern(ConditionType.SQL_EQUALS, "");
    private static final Pattern METADATA_SPECIALS = Pattern.compile("([\\\\_%])");
    private final ConditionType conditionType;
    private final String conditionValue;

    private MetadataPattern(ConditionType conditionType, String conditionValue) {
        this.conditionType = conditionType;
        this.conditionValue = conditionValue;
    }

    public ConditionType getConditionType() {
        return this.conditionType;
    }

    public String getConditionValue() {
        return this.conditionValue;
    }

    public String renderCondition(String columnName) {
        return this.conditionType.renderCondition(columnName);
    }

    public MetadataPatternMatcher toMetadataPatternMatcher() {
        return MetadataPatternMatcher.fromPattern(this);
    }

    public static MetadataPattern compile(String metadataPattern) {
        if (MetadataPattern.isAllCondition(metadataPattern)) {
            return ALL_PATTERN;
        }
        if (metadataPattern.isEmpty()) {
            return EMPTY_PATTERN;
        }
        if (!MetadataPattern.containsPatternSpecialChars(metadataPattern)) {
            return new MetadataPattern(ConditionType.SQL_EQUALS, metadataPattern);
        }
        return MetadataPattern.parsePattern(metadataPattern);
    }

    public static boolean containsPatternSpecialChars(String pattern) {
        for (int idx = 0; idx < pattern.length(); ++idx) {
            if (!MetadataPattern.isPatternSpecialChar(pattern.charAt(idx))) continue;
            return true;
        }
        return false;
    }

    public static boolean isPatternSpecialChar(char charVal) {
        return charVal == '%' || charVal == '_' || charVal == '\\';
    }

    public static String escapeWildcards(String objectName) {
        if (objectName == null) {
            return null;
        }
        return METADATA_SPECIALS.matcher(objectName).replaceAll("\\\\$1");
    }

    private static MetadataPattern parsePattern(String metadataPattern) {
        ConditionType conditionType = ConditionType.SQL_EQUALS;
        boolean hasEscape = false;
        int patternLength = metadataPattern.length();
        StringBuilder likePattern = new StringBuilder(patternLength);
        block5: for (int idx = 0; idx < patternLength; ++idx) {
            char ch = metadataPattern.charAt(idx);
            switch (ch) {
                case '%': {
                    if (idx == patternLength - 1 && conditionType == ConditionType.SQL_EQUALS) {
                        conditionType = ConditionType.SQL_STARTING_WITH;
                        continue block5;
                    }
                }
                case '_': {
                    conditionType = ConditionType.SQL_LIKE;
                    likePattern.append(ch);
                    continue block5;
                }
                case '\\': {
                    hasEscape = true;
                    if (idx < patternLength - 1 && MetadataPattern.isPatternSpecialChar(metadataPattern.charAt(idx + 1))) {
                        likePattern.append('\\').append(metadataPattern.charAt(++idx));
                        continue block5;
                    }
                    likePattern.append('\\').append('\\');
                    continue block5;
                }
                default: {
                    likePattern.append(ch);
                }
            }
        }
        if (!hasEscape) {
            return new MetadataPattern(conditionType, conditionType == ConditionType.SQL_EQUALS ? metadataPattern : likePattern.toString());
        }
        if (conditionType != ConditionType.SQL_LIKE) {
            MetadataPattern.stripEscapes(likePattern);
        }
        return new MetadataPattern(conditionType, likePattern.toString());
    }

    private static void stripEscapes(StringBuilder likePattern) {
        for (int idx = 0; idx < likePattern.length(); ++idx) {
            if (likePattern.charAt(idx) != '\\') continue;
            likePattern.deleteCharAt(idx);
        }
    }

    public static boolean isAllCondition(String metadataPattern) {
        return metadataPattern == null || "%".equals(metadataPattern);
    }

    public static enum ConditionType {
        NONE{

            @Override
            String renderCondition(String columnName) {
                return "";
            }
        }
        ,
        SQL_LIKE{

            @Override
            String renderCondition(String columnName) {
                return "trim(trailing from " + columnName + ") like " + "cast(? as varchar(" + 73 + ")) escape '\\' ";
            }
        }
        ,
        SQL_EQUALS{

            @Override
            String renderCondition(String columnName) {
                return columnName + " = cast(? as varchar(" + 73 + ")) ";
            }
        }
        ,
        SQL_STARTING_WITH{

            @Override
            String renderCondition(String columnName) {
                return columnName + " starting with cast(? as varchar(" + 73 + ")) ";
            }
        };


        abstract String renderCondition(String var1);
    }
}

