/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.sql.SQLException;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbConnectionProperties;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.management.FBManagerMBean;
import org.firebirdsql.management.PageSizeConstants;

public class FBManager
implements FBManagerMBean {
    private static final int DEFAULT_PORT = 3050;
    private static final Logger log = LoggerFactory.getLogger(FBManager.class);
    private FbDatabaseFactory dbFactory;
    private String host = "localhost";
    private Integer port;
    private String fileName;
    private String userName;
    private String password;
    private int dialect = 3;
    private int pageSize = -1;
    private String defaultCharacterSet;
    private boolean forceCreate;
    private boolean createOnStart;
    private boolean dropOnStop;
    private String state = "Stopped";
    private static final String STOPPED = "Stopped";
    private static final String STARTED = "Started";
    private GDSType type;

    public FBManager() {
        this(GDSFactory.getDefaultGDSType());
    }

    public FBManager(GDSType type) {
        this.type = type;
    }

    public FBManager(String type) {
        this.type = GDSType.getType(type);
    }

    @Override
    public synchronized void start() throws Exception {
        if (STARTED.equals(this.state)) {
            throw new IllegalStateException("FBManager already started. Call stop() before starting again.");
        }
        this.dbFactory = GDSFactory.getDatabaseFactoryForType(this.type);
        this.state = STARTED;
        String fileName = this.getFileName();
        if (this.isCreateOnStart() && fileName != null) {
            this.createDatabase(fileName, this.getUserName(), this.getPassword());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws Exception {
        try {
            if (STOPPED.equals(this.state)) {
                log.warn("FBManager already stopped.");
                return;
            }
            String fileName = this.getFileName();
            if (this.isDropOnStop() && fileName != null) {
                this.dropDatabase(fileName, this.getUserName(), this.getPassword());
            }
        }
        finally {
            this.dbFactory = null;
            this.state = STOPPED;
        }
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getName() {
        return "Firebird Database manager";
    }

    @Override
    public void setServer(String host) {
        this.host = host;
    }

    @Override
    public String getServer() {
        return this.host;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port != null ? this.port : 3050;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getType() {
        return this.type.toString();
    }

    @Override
    public void setType(String type) {
        GDSType gdsType = GDSType.getType(type);
        if (gdsType == null) {
            throw new RuntimeException("Unrecognized type '" + type + "'");
        }
        this.type = gdsType;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setDialect(int dialect) {
        if (dialect != 1 && dialect != 3) {
            throw new IllegalArgumentException("Only dialect 1 or 3 allowed");
        }
        this.dialect = dialect;
    }

    @Override
    public int getDialect() {
        return this.dialect;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = PageSizeConstants.requireValidPageSize(pageSize);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setDefaultCharacterSet(String firebirdCharsetName) {
        this.defaultCharacterSet = firebirdCharsetName;
    }

    @Override
    public String getDefaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    @Override
    public boolean isCreateOnStart() {
        return this.createOnStart;
    }

    @Override
    public void setCreateOnStart(boolean createOnStart) {
        this.createOnStart = createOnStart;
    }

    @Override
    public boolean isDropOnStop() {
        return this.dropOnStop;
    }

    @Override
    public void setDropOnStop(boolean dropOnStop) {
        this.dropOnStop = dropOnStop;
    }

    @Override
    public boolean isForceCreate() {
        return this.forceCreate;
    }

    @Override
    public void setForceCreate(boolean forceCreate) {
        this.forceCreate = forceCreate;
    }

    @Override
    public synchronized void createDatabase(String fileName, String user, String password) throws Exception {
        FbDatabase db;
        IConnectionProperties connectionProperties2;
        this.checkStarted();
        try {
            connectionProperties2 = this.createDefaultConnectionProperties(user, password);
            connectionProperties2.setDatabaseName(fileName);
            db = this.dbFactory.connect(connectionProperties2);
            db.attach();
            if (!this.forceCreate) {
                db.close();
                return;
            }
            db.dropDatabase();
        }
        catch (SQLException connectionProperties2) {
            // empty catch block
        }
        try {
            connectionProperties2 = this.createDefaultConnectionProperties(user, password);
            connectionProperties2.setDatabaseName(fileName);
            connectionProperties2.setConnectionDialect((short)this.dialect);
            if (this.getPageSize() != -1) {
                connectionProperties2.getExtraDatabaseParameters().addArgument(4, this.getPageSize());
            }
            if (this.getDefaultCharacterSet() != null) {
                connectionProperties2.getExtraDatabaseParameters().addArgument(68, this.getDefaultCharacterSet());
            }
            db = this.dbFactory.connect(connectionProperties2);
            Throwable throwable = null;
            try {
                db.createDatabase();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (db != null) {
                    if (throwable != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        db.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Exception creating database", e);
            throw e;
        }
    }

    @Override
    public synchronized void dropDatabase(String fileName, String user, String password) throws Exception {
        this.checkStarted();
        try {
            IConnectionProperties connectionProperties = this.createDefaultConnectionProperties(user, password);
            connectionProperties.setDatabaseName(fileName);
            FbDatabase db = this.dbFactory.connect(connectionProperties);
            db.attach();
            db.dropDatabase();
        }
        catch (Exception e) {
            log.error("Exception dropping database", e);
            throw e;
        }
    }

    @Override
    public synchronized boolean isDatabaseExists(String fileName, String user, String password) throws Exception {
        this.checkStarted();
        try {
            IConnectionProperties connectionProperties = this.createDefaultConnectionProperties(user, password);
            connectionProperties.setDatabaseName(fileName);
            FbDatabase db = this.dbFactory.connect(connectionProperties);
            db.attach();
            db.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private IConnectionProperties createDefaultConnectionProperties(String user, String password) {
        FbConnectionProperties connectionProperties = new FbConnectionProperties();
        connectionProperties.setUser(user);
        connectionProperties.setPassword(password);
        connectionProperties.setServerName(this.getServer());
        connectionProperties.setPortNumber(this.getPort());
        return connectionProperties;
    }

    private synchronized void checkStarted() {
        if (!STARTED.equals(this.state)) {
            throw new IllegalStateException("FBManager has not been started. Call start() before use.");
        }
    }
}

