/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import java.util.Arrays;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.BaseGDSFactoryPlugin;
import org.firebirdsql.gds.ng.jna.FbClientDatabaseFactory;

public class NativeGDSFactoryPlugin
extends BaseGDSFactoryPlugin {
    public static final String NATIVE_TYPE_NAME = "NATIVE";
    private static final String[] TYPE_ALIASES = new String[]{"TYPE2"};
    private static final String[] JDBC_PROTOCOLS = new String[]{"jdbc:firebirdsql:native:", "jdbc:firebird:native:"};

    @Override
    public String getPluginName() {
        return "JNA-based GDS implementation.";
    }

    @Override
    public String getTypeName() {
        return NATIVE_TYPE_NAME;
    }

    @Override
    public String[] getTypeAliases() {
        return Arrays.copyOf(TYPE_ALIASES, TYPE_ALIASES.length);
    }

    @Override
    public String[] getSupportedProtocols() {
        return Arrays.copyOf(JDBC_PROTOCOLS, JDBC_PROTOCOLS.length);
    }

    @Override
    public String getDatabasePath(String server, Integer port, String path) throws GDSException {
        if (server == null) {
            throw new GDSException("Server name/address is required for native implementation.");
        }
        if (path == null) {
            throw new GDSException("Database name/path is required.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(server);
        if (port != null) {
            sb.append('/').append(port);
        }
        sb.append(':').append(path);
        return sb.toString();
    }

    @Override
    public FbClientDatabaseFactory getDatabaseFactory() {
        return FbClientDatabaseFactory.getInstance();
    }
}

