/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.jdbc.field.BlobListenableField;
import org.firebirdsql.jdbc.field.FBCloseableField;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBBlobField
extends FBField
implements FBCloseableField,
FBFlushableField,
BlobListenableField {
    protected FirebirdBlob blob;
    private boolean blobExplicitNull;
    private long length;
    private InputStream binaryStream;
    private Reader characterStream;
    private byte[] bytes;
    private FBObjectListener.BlobListener blobListener = FBObjectListener.NoActionBlobListener.instance();
    final FBBlob.Config blobConfig;

    FBBlobField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType, GDSHelper gdsHelper) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
        this.gdsHelper = gdsHelper;
        this.blobConfig = gdsHelper != null ? FBBlob.createConfig(fieldDescriptor, gdsHelper.getConnectionProperties()) : FBBlob.createConfig(fieldDescriptor.getSubType(), true, 16384, fieldDescriptor.getDatatypeCoder());
    }

    @Override
    public void setBlobListener(FBObjectListener.BlobListener blobListener) {
        this.blobListener = blobListener;
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.blob != null) {
                this.blob.free();
            }
        }
        finally {
            this.blob = null;
            this.blobExplicitNull = false;
            this.bytes = null;
            this.binaryStream = null;
            this.characterStream = null;
            this.length = 0L;
            this.blobListener = null;
        }
    }

    protected FirebirdBlob getBlobInternal() {
        if (this.blob != null) {
            return this.blob;
        }
        byte[] bytes = this.getFieldData();
        if (bytes == null) {
            return null;
        }
        this.blob = new FBBlob(this.gdsHelper, this.getDatatypeCoder().decodeLong(bytes), this.blobListener, this.blobConfig);
        return this.blob;
    }

    @Override
    public Object getObject() throws SQLException {
        if (this.requiredType == 2004) {
            return this.getBlob();
        }
        return this.getBytes();
    }

    @Override
    public Blob getBlob() throws SQLException {
        FirebirdBlob blob = this.getBlobInternal();
        return blob != null ? this.registerWithTransaction(blob.detach()) : null;
    }

    @Override
    public Clob getClob() throws SQLException {
        FBBlob blob = (FBBlob)this.getBlob();
        if (blob == null) {
            return null;
        }
        return new FBClob(blob);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        FirebirdBlob blob = this.getBlobInternal();
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    @Override
    public byte[] getBytes() throws SQLException {
        return this.getBytesInternal();
    }

    /*
     * Exception decompiling
     */
    public byte[] getBytesInternal() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public byte[] getCachedData() throws SQLException {
        if (this.isNull()) {
            return this.bytes;
        }
        return this.getBytesInternal();
    }

    @Override
    public FBFlushableField.CachedObject getCachedObject() throws SQLException {
        if (this.isNull()) {
            return new FBFlushableField.CachedObject(this.bytes, this.binaryStream, this.characterStream, this.length);
        }
        byte[] bytes = this.getBytesInternal();
        return new FBFlushableField.CachedObject(bytes, null, null, bytes.length);
    }

    @Override
    public void setCachedObject(FBFlushableField.CachedObject cachedObject) throws SQLException {
        this.setNull();
        this.bytes = cachedObject.bytes;
        this.binaryStream = cachedObject.binaryStream;
        this.characterStream = cachedObject.characterStream;
        this.length = cachedObject.length;
        this.blobExplicitNull = this.bytes == null && this.binaryStream == null && this.characterStream == null;
    }

    @Override
    public String getString() throws SQLException {
        if (this.fieldDescriptor.getSubType() < 0) {
            throw this.invalidGetConversion(String.class, String.format("BLOB SUB_TYPE %d", this.fieldDescriptor.getSubType()));
        }
        FirebirdBlob blob = this.getBlobInternal();
        if (blob == null) {
            return null;
        }
        return this.getDatatypeCoder().decodeString(this.getBytes());
    }

    @Override
    protected void setCharacterStreamInternal(Reader in, long length) {
        this.setNull();
        if (in != null) {
            this.characterStream = in;
            this.length = length;
            this.blobExplicitNull = false;
        }
    }

    @Override
    protected void setBinaryStreamInternal(InputStream in, long length) {
        this.setNull();
        if (in != null) {
            this.binaryStream = in;
            this.length = length;
            this.blobExplicitNull = false;
        }
    }

    @Override
    public void flushCachedData() throws SQLException {
        if (this.binaryStream != null) {
            this.copyBinaryStream(this.binaryStream, this.length);
        } else if (this.characterStream != null) {
            this.copyCharacterStream(this.characterStream, this.length);
        } else if (this.bytes != null) {
            this.copyBytes(this.bytes, (int)this.length);
        } else if (this.blob == null && this.blobExplicitNull) {
            this.setNull();
        }
        this.characterStream = null;
        this.binaryStream = null;
        this.bytes = null;
        this.length = 0L;
    }

    private void copyBinaryStream(InputStream in, long length) throws SQLException {
        FBBlob blob = this.createBlob();
        blob.copyStream(in, length);
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
        this.blobExplicitNull = false;
    }

    private void copyCharacterStream(Reader in, long length) throws SQLException {
        FBBlob blob = this.createBlob();
        blob.copyCharacterStream(in, length);
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
        this.blobExplicitNull = false;
    }

    private void copyBytes(byte[] bytes, int length) throws SQLException {
        FBBlob blob = this.createBlob();
        blob.copyBytes(bytes, 0, length);
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
        this.blobExplicitNull = false;
    }

    @Override
    public void setBytes(byte[] value) throws SQLException {
        this.setNull();
        if (value != null) {
            this.bytes = value;
            this.length = value.length;
            this.blobExplicitNull = false;
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setBytes(this.getDatatypeCoder().encodeString(value));
    }

    @Override
    public void setBlob(FBBlob blob) throws SQLException {
        this.setNull();
        if (blob != null) {
            this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
            this.blob = blob;
            this.blobExplicitNull = false;
        }
    }

    @Override
    public void setBlob(Blob blob) throws SQLException {
        if (blob == null) {
            this.setNull();
        } else if (blob instanceof FBBlob) {
            this.setBlob((FBBlob)blob);
        } else {
            FBBlob fbb = this.createBlob();
            fbb.copyStream(blob.getBinaryStream());
            this.setBlob(fbb);
        }
    }

    @Override
    FBBlob createBlob() {
        return new FBBlob(this.gdsHelper, this.blobListener, this.blobConfig);
    }

    @Override
    public void setClob(FBClob clob) throws SQLException {
        this.setBlob(clob != null ? clob.getWrappedBlob() : null);
    }

    @Override
    public void setClob(Clob clob) throws SQLException {
        if (clob == null) {
            this.setNull();
        } else if (clob instanceof FBClob) {
            this.setClob((FBClob)clob);
        } else {
            FBClob fbc = this.createClob();
            fbc.copyCharacterStream(clob.getCharacterStream());
            this.setClob(fbc);
        }
    }

    @Override
    public void setNull() {
        super.setNull();
        try {
            if (this.blob != null) {
                this.blob.free();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.blob = null;
            this.blobExplicitNull = true;
            this.binaryStream = null;
            this.characterStream = null;
            this.bytes = null;
            this.length = 0L;
        }
    }

    private <T extends FirebirdBlob> T registerWithTransaction(T blob) {
        FbTransaction currentTransaction;
        if (blob instanceof TransactionListener && (currentTransaction = this.gdsHelper.getCurrentTransaction()) != null) {
            currentTransaction.addWeakTransactionListener((TransactionListener)((Object)blob));
        }
        return blob;
    }
}

