/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLWarning;
import java.util.Objects;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ng.AbstractFbDatabase;
import org.firebirdsql.gds.ng.BlobHelper;
import org.firebirdsql.gds.ng.BlobLengthProcessor;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.ByteArrayHelper;

public abstract class AbstractFbBlob
implements FbBlob,
TransactionListener,
DatabaseListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractFbBlob.class);
    protected final ExceptionListenerDispatcher exceptionListenerDispatcher = new ExceptionListenerDispatcher(this);
    private final BlobParameterBuffer blobParameterBuffer;
    private final int maximumSegmentSize;
    private FbTransaction transaction;
    private FbDatabase database;
    private BlobState state = BlobState.NEW;
    private boolean eof;
    private SQLException deferredException;

    protected AbstractFbBlob(FbDatabase database, FbTransaction transaction, BlobParameterBuffer blobParameterBuffer) throws SQLException {
        this.database = database;
        this.transaction = transaction;
        this.checkDatabaseAttached();
        this.checkTransactionActive();
        this.blobParameterBuffer = blobParameterBuffer;
        this.maximumSegmentSize = AbstractFbBlob.maximumSegmentSize(database);
        transaction.addWeakTransactionListener(this);
    }

    @Override
    public final boolean isOpen() {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.state.isOpen();
            return bl;
        }
    }

    @Override
    public final boolean isEof() {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.eof || this.state.isClosed();
            return bl;
        }
    }

    protected final void setEof() {
        if (this.isOutput()) {
            return;
        }
        try (LockCloseable ignored = this.withLock();){
            this.eof = true;
        }
    }

    protected final void resetEof() {
        try (LockCloseable ignored = this.withLock();){
            this.eof = false;
        }
    }

    protected final void setState(BlobState newState) {
        try (LockCloseable ignored = this.withLock();){
            FbTransaction transaction;
            BlobState previousState = this.state;
            FbDatabase database = this.database;
            if (database != null) {
                if (newState.isClosed()) {
                    database.removeDatabaseListener(this);
                } else if (previousState.isClosed()) {
                    database.addWeakDatabaseListener(this);
                }
            }
            if (newState.isClosed() && (transaction = this.transaction) != null) {
                transaction.removeTransactionListener(this);
            }
            this.state = newState;
        }
    }

    protected final BlobState getState() {
        try (LockCloseable ignored = this.withLock();){
            BlobState blobState = this.state;
            return blobState;
        }
    }

    @Override
    public final void close() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.state.isClosed()) {
                return;
            }
            try {
                if (this.isEndingTransaction()) {
                    this.releaseResources();
                } else {
                    this.checkDatabaseAttached();
                    this.checkTransactionActive();
                    this.closeImpl();
                }
            }
            finally {
                this.setState(BlobState.CLOSED);
            }
            this.throwAndClearDeferredException();
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
        finally {
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    protected abstract void closeImpl() throws SQLException;

    @Override
    public final void cancel() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                if (this.isEndingTransaction()) {
                    this.releaseResources();
                } else {
                    this.checkDatabaseAttached();
                    this.checkTransactionActive();
                    this.cancelImpl();
                }
            }
            finally {
                this.setState(BlobState.CLOSED);
            }
            this.throwAndClearDeferredException();
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    protected abstract void cancelImpl() throws SQLException;

    @Override
    public void putSegment(byte[] segment) throws SQLException {
        this.put(segment, 0, segment.length);
    }

    @Override
    public final int get(byte[] b, int off, int len) throws SQLException {
        return this.get(b, off, len, len);
    }

    @Override
    public final int get(byte[] b, int off, int len, float minFillFactor) throws SQLException {
        if (minFillFactor <= 0.0f || minFillFactor > 1.0f || Float.isNaN(minFillFactor)) {
            SQLNonTransientException invalidFloatFactor = new SQLNonTransientException("minFillFactor out of range, must be 0 < minFillFactor <= 1, was: " + minFillFactor);
            this.errorOccurred(invalidFloatFactor);
            throw invalidFloatFactor;
        }
        return this.get(b, off, len, len != 0 ? Math.max(1, (int)(minFillFactor * (float)len)) : 0);
    }

    protected abstract int get(byte[] var1, int var2, int var3, int var4) throws SQLException;

    protected abstract void releaseResources();

    protected final void registerDeferredException(SQLException deferredException) {
        Objects.requireNonNull(deferredException, "deferredException");
        SQLException current = this.deferredException;
        if (current == null) {
            this.deferredException = deferredException;
        } else {
            current.setNextException(deferredException);
        }
    }

    protected final void clearDeferredException() {
        this.deferredException = null;
    }

    protected final void throwAndClearDeferredException() throws SQLException {
        SQLException current = this.deferredException;
        if (current != null) {
            this.clearDeferredException();
            throw current;
        }
    }

    protected final void transferDeferredExceptionTo(SQLException target) {
        try (LockCloseable ignored = this.withLock();){
            SQLException current = this.deferredException;
            if (current != null) {
                this.clearDeferredException();
                if (current != target) {
                    Objects.requireNonNull(target, "target").setNextException(current);
                }
            }
        }
    }

    protected final LockCloseable withLock() {
        FbDatabase database = this.database;
        if (database != null) {
            return database.withLock();
        }
        return LockCloseable.NO_OP;
    }

    @Override
    public void transactionStateChanged(FbTransaction transaction, TransactionState newState, TransactionState previousState) {
        if (this.getTransaction() != transaction) {
            transaction.removeTransactionListener(this);
            return;
        }
        switch (newState) {
            case COMMITTING: 
            case ROLLING_BACK: 
            case PREPARING: {
                try {
                    this.close();
                }
                catch (SQLException e) {
                    log.error("Exception while closing blob during transaction end", e);
                }
                break;
            }
            case COMMITTED: 
            case ROLLED_BACK: {
                try (LockCloseable ignored = this.withLock();){
                    this.clearTransaction();
                    this.setState(BlobState.CLOSED);
                    this.releaseResources();
                    break;
                }
            }
        }
    }

    @Override
    public void detaching(FbDatabase database) {
        if (this.database != database) {
            database.removeDatabaseListener(this);
            return;
        }
        try (LockCloseable ignored = this.withLock();){
            if (this.state.isOpen()) {
                log.debugf("blob with blobId %d still open on database detach", (Object)this.getBlobId());
                try {
                    this.close();
                }
                catch (SQLException e) {
                    log.error("Blob close in detaching event failed", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detached(FbDatabase database) {
        try (LockCloseable ignored = this.withLock();){
            if (this.database == database) {
                this.state = BlobState.CLOSED;
                this.clearDatabase();
                this.clearTransaction();
                this.releaseResources();
            }
        }
        finally {
            database.removeDatabaseListener(this);
        }
    }

    @Override
    public void warningReceived(FbDatabase database, SQLWarning warning) {
    }

    protected final boolean isEndingTransaction() {
        FbTransaction transaction = this.getTransaction();
        if (transaction != null) {
            TransactionState transactionState = transaction.getState();
            return transactionState == TransactionState.COMMITTING || transactionState == TransactionState.ROLLING_BACK || transactionState == TransactionState.PREPARING;
        }
        return false;
    }

    protected final void checkTransactionActive() throws SQLException {
        TransactionHelper.checkTransactionActive(this.getTransaction(), 335544370);
    }

    protected final void checkDatabaseAttached() throws SQLException {
        FbDatabase database = this.database;
        if (database == null || !database.isAttached()) {
            throw new FbExceptionBuilder().nonTransientException(335544372).toSQLException();
        }
    }

    protected void checkBlobOpen() throws SQLException {
        BlobHelper.checkBlobOpen(this);
    }

    protected void checkBlobClosed() throws SQLException {
        BlobHelper.checkBlobClosed(this);
    }

    protected FbTransaction getTransaction() {
        try (LockCloseable ignored = this.withLock();){
            FbTransaction fbTransaction = this.transaction;
            return fbTransaction;
        }
    }

    protected final void clearTransaction() {
        FbTransaction transaction;
        try (LockCloseable ignored = this.withLock();){
            transaction = this.transaction;
            this.transaction = null;
        }
        if (transaction != null) {
            transaction.removeTransactionListener(this);
        }
    }

    @Override
    public FbDatabase getDatabase() {
        try (LockCloseable ignored = this.withLock();){
            FbDatabase fbDatabase = this.database;
            return fbDatabase;
        }
    }

    @Override
    public <T> T getBlobInfo(byte[] requestItems, int bufferLength, InfoProcessor<T> infoProcessor) throws SQLException {
        byte[] blobInfo = this.getBlobInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(blobInfo);
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    protected byte[] getKnownBlobInfoItems() {
        FbDatabase db = this.getDatabase();
        if (db instanceof AbstractFbDatabase) {
            return ((AbstractFbDatabase)db).getServerVersionInformation().getBlobInfoRequestItems();
        }
        return ByteArrayHelper.emptyByteArray();
    }

    @Override
    public long length() throws SQLException {
        LockCloseable ignored = this.withLock();
        try {
            this.checkDatabaseAttached();
            if (this.isOutput() && this.getBlobId() == 0L && !this.getState().isDeferredOpen()) {
                throw FbExceptionBuilder.forException(335544329).toSQLException();
            }
            BlobLengthProcessor blobLengthProcessor = this.createBlobLengthProcessor();
            long l = this.getBlobInfo(blobLengthProcessor.getBlobLengthItems(), 20, blobLengthProcessor);
            if (ignored != null) {
                ignored.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.errorOccurred(e);
                throw e;
            }
        }
    }

    protected final void errorOccurred(SQLException e) {
        this.transferDeferredExceptionTo(e);
        this.exceptionListenerDispatcher.errorOccurred(e);
    }

    @Override
    public final void addExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.addListener(listener);
    }

    @Override
    public final void removeExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.removeListener(listener);
    }

    protected final void clearDatabase() {
        FbDatabase database;
        try (LockCloseable ignored = this.withLock();){
            database = this.database;
            this.database = null;
        }
        if (database != null) {
            database.removeDatabaseListener(this);
        }
    }

    protected BlobParameterBuffer getBlobParameterBuffer() {
        return this.blobParameterBuffer;
    }

    protected BlobLengthProcessor createBlobLengthProcessor() {
        return new BlobLengthProcessor();
    }

    @Override
    public int getMaximumSegmentSize() {
        return this.maximumSegmentSize;
    }

    private static int maximumSegmentSize(FbDatabase db) {
        if (db != null && db.getServerVersion().isEqualOrAbove(3, 0)) {
            return 65535;
        }
        return 32765;
    }

    protected static final class BlobState
    extends Enum<BlobState> {
        public static final /* enum */ BlobState NEW = new BlobState(false, false);
        public static final /* enum */ BlobState DELAYED_OPEN = new BlobState(true, true);
        public static final /* enum */ BlobState PENDING_OPEN = new BlobState(true, true);
        public static final /* enum */ BlobState OPEN = new BlobState(true, false);
        public static final /* enum */ BlobState CLOSED = new BlobState(false, false);
        private final boolean open;
        private final boolean deferredOpen;
        private static final /* synthetic */ BlobState[] $VALUES;

        public static BlobState[] values() {
            return (BlobState[])$VALUES.clone();
        }

        public static BlobState valueOf(String name) {
            return Enum.valueOf(BlobState.class, name);
        }

        private BlobState(boolean open, boolean deferredOpen) {
            assert (!deferredOpen || open) : "open must be true when deferredOpen is true";
            this.open = open;
            this.deferredOpen = deferredOpen;
        }

        public final boolean isOpen() {
            return this.open;
        }

        public final boolean isClosed() {
            return !this.open;
        }

        public final boolean isDeferredOpen() {
            return this.deferredOpen;
        }

        static {
            $VALUES = new BlobState[]{NEW, DELAYED_OPEN, PENDING_OPEN, OPEN, CLOSED};
        }
    }
}

