/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version16;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import org.firebirdsql.gds.BatchParameterBuffer;
import org.firebirdsql.gds.impl.BatchParameterBufferImp;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.BatchCompletion;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.FbBatchConfig;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.wire.BatchCompletionResponse;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.version13.V13Statement;

public class V16Statement
extends V13Statement {
    public V16Statement(FbWireDatabase database) {
        super(database);
    }

    @Override
    protected void sendExecute(int operation, RowValue parameters) throws IOException, SQLException {
        super.sendExecute(operation, parameters);
        this.getXdrOut().writeInt((int)this.getAllowedTimeout());
    }

    @Override
    public boolean supportBatchUpdates() {
        return true;
    }

    @Override
    public BatchParameterBuffer createBatchParameterBuffer() throws SQLException {
        this.checkStatementValid();
        return new BatchParameterBufferImp();
    }

    @Override
    public void deferredBatchCreate(FbBatchConfig batchConfig, DeferredResponse<Void> onResponse) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementValid();
            try {
                this.sendBatchCreate(batchConfig);
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.forException(335544727).cause(e).toSQLException();
            }
            this.getDatabase().enqueueDeferredAction(this.wrapDeferredResponse(onResponse, r -> null));
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected void sendBatchCreate(FbBatchConfig batchConfig) throws SQLException, IOException {
        BlrCalculator blrCalculator = this.getBlrCalculator();
        RowDescriptor parameterDescriptor = this.getParameterDescriptor();
        byte[] blrMessage = blrCalculator.calculateBlr(parameterDescriptor);
        int messageLength = blrCalculator.calculateBatchMessageLength(parameterDescriptor);
        BatchParameterBuffer batchPb = this.createBatchParameterBuffer();
        batchConfig.populateBatchParameterBuffer(batchPb);
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(99);
        xdrOut.writeInt(this.getHandle());
        xdrOut.writeBuffer(blrMessage);
        xdrOut.writeInt(messageLength);
        xdrOut.writeTyped(batchPb);
        xdrOut.flush();
    }

    @Override
    public void deferredBatchSend(Collection<RowValue> rowValues, DeferredResponse<Void> onResponse) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementValid();
            try {
                this.sendBatchMsg(rowValues);
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.forException(335544727).cause(e).toSQLException();
            }
            this.getDatabase().enqueueDeferredAction(this.wrapDeferredResponse(onResponse, r -> null));
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected void sendBatchMsg(Collection<RowValue> rowValues) throws SQLException, IOException {
        BlrCalculator blrCalculator = this.getBlrCalculator();
        RowDescriptor parameterDescriptor = this.getParameterDescriptor();
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(100);
        xdrOut.writeInt(this.getHandle());
        xdrOut.writeInt(rowValues.size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XdrOutputStream rowOut = new XdrOutputStream(baos, 512);
        for (RowValue rowValue : rowValues) {
            baos.reset();
            this.writeSqlData(rowOut, blrCalculator, parameterDescriptor, rowValue, false);
            rowOut.flush();
            byte[] rowBytes = baos.toByteArray();
            xdrOut.write(rowBytes);
            xdrOut.writeZeroPadding(4 - rowBytes.length & 3);
        }
        xdrOut.flush();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public BatchCompletion batchExecute() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementValid();
            FbWireTransaction transaction = this.getTransaction();
            TransactionHelper.checkTransactionActive(transaction);
            try {
                XdrOutputStream xdrOut = this.getXdrOut();
                xdrOut.writeInt(101);
                xdrOut.writeInt(this.getHandle());
                xdrOut.writeInt(transaction.getHandle());
                xdrOut.flush();
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.forException(335544727).cause(e).toSQLException();
            }
            try {
                BatchCompletionResponse response = (BatchCompletionResponse)this.getDatabase().readResponse(this.getStatementWarningCallback());
                BatchCompletion batchCompletion = response.batchCompletion();
                return batchCompletion;
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.forException(335544727).cause(e).toSQLException();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public void batchCancel() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                XdrOutputStream xdrOut = this.getXdrOut();
                xdrOut.writeInt(109);
                xdrOut.writeInt(this.getHandle());
                xdrOut.flush();
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.forException(335544727).cause(e).toSQLException();
            }
            try {
                this.getDatabase().readResponse(this.getStatementWarningCallback());
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.forException(335544726).cause(e).toSQLException();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public void deferredBatchRelease(DeferredResponse<Void> onResponse) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementValid();
            try {
                XdrOutputStream xdrOut = this.getXdrOut();
                xdrOut.writeInt(102);
                xdrOut.writeInt(this.getHandle());
                xdrOut.flush();
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.forException(335544727).cause(e).toSQLException();
            }
            this.getDatabase().enqueueDeferredAction(this.wrapDeferredResponse(onResponse, r -> null));
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }
}

