/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBDriverNotCapableException;

public final class FBClob
implements Clob,
NClob {
    private final FBBlob wrappedBlob;

    public FBClob(FBBlob blob) {
        this.wrappedBlob = blob;
    }

    @Override
    public long length() throws SQLException {
        throw new FBDriverNotCapableException("Cannot determine length for CLOB");
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new FBDriverNotCapableException("Method truncate(long) is not supported");
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        String string;
        block10: {
            Reader reader = this.getCharacterStream();
            try {
                int n;
                long skipped;
                for (long toSkip = pos - 1L; toSkip > 0L; toSkip -= skipped) {
                    skipped = reader.skip(toSkip);
                    if (skipped != 0L) continue;
                    throw new EOFException("end of stream was reached at position " + (pos - toSkip));
                }
                char[] buffer = new char[Math.min(length, 1024)];
                StringBuilder sb = new StringBuilder(length);
                while (length > 0 && (n = reader.read(buffer, 0, Math.min(length, buffer.length))) != -1) {
                    sb.append(buffer, 0, n);
                    length -= n;
                }
                string = sb.toString();
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SQLException(e.toString(), "HY000", e);
                }
            }
            reader.close();
        }
        return string;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.wrappedBlob.config().createReader(this.wrappedBlob.getBinaryStream());
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.wrappedBlob.getBinaryStream();
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method position(String, long) is not supported");
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method position(Clob, long) is not supported");
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(1L, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        int n;
        block8: {
            Writer charStream = this.setCharacterStream(pos);
            try {
                charStream.write(str, offset, len);
                n = len;
                if (charStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (charStream != null) {
                        try {
                            charStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SQLException("IOException writing string to blob", e);
                }
            }
            charStream.close();
        }
        return n;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return this.wrappedBlob.setBinaryStream(pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        if (pos < 1L) {
            throw new SQLNonTransientException("You can't start before the beginning of the blob", "HY009");
        }
        if (pos > 1L) {
            throw new FBDriverNotCapableException("Offset start positions are not supported.");
        }
        return this.wrappedBlob.config().createWriter(this.wrappedBlob.setBinaryStream(1L));
    }

    @Override
    public void free() throws SQLException {
        this.wrappedBlob.free();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw new FBDriverNotCapableException("Method getCharacterStream(long, long) is not supported");
    }

    public void copyCharacterStream(Reader characterStream, long length) throws SQLException {
        this.wrappedBlob.copyCharacterStream(characterStream, length);
    }

    public void copyCharacterStream(Reader characterStream) throws SQLException {
        this.wrappedBlob.copyCharacterStream(characterStream);
    }

    public FBBlob getWrappedBlob() throws SQLException {
        return this.wrappedBlob;
    }
}

