/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.NativeLibrary;
import java.lang.reflect.Proxy;
import org.firebirdsql.gds.ng.jna.AbstractNativeDatabaseFactory;
import org.firebirdsql.gds.ng.jna.FbClientFeatureAccessHandler;
import org.firebirdsql.gds.ng.jna.NativeResourceTracker;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

class FbClientResource
extends NativeResourceTracker.NativeResource {
    private volatile FbClientLibrary library;
    private final AbstractNativeDatabaseFactory owner;

    FbClientResource(FbClientLibrary library, AbstractNativeDatabaseFactory owner) {
        this.library = library;
        this.owner = owner;
    }

    FbClientLibrary get() {
        FbClientLibrary local = this.library;
        if (local == null) {
            throw new IllegalStateException("Library was already disposed");
        }
        return local;
    }

    @Override
    void dispose() {
        FbClientLibrary local = this.library;
        if (local == null) {
            return;
        }
        try {
            this.disposeImpl();
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(FbClientResource.class).errorfe("Error disposing of %s", local, e);
        }
    }

    private void disposeImpl() {
        FbClientLibrary local = this.library;
        if (local == null) {
            return;
        }
        this.owner.disposing(this, () -> {
            this.library = null;
            if (NativeResourceTracker.isNativeResourceShutdownDisabled()) {
                return;
            }
            Logger log = LoggerFactory.getLogger(FbClientResource.class);
            try {
                log.debugf("Calling fb_shutdown on %s", (Object)local);
                local.fb_shutdown(0, 1);
            }
            finally {
                FbClientFeatureAccessHandler handler = (FbClientFeatureAccessHandler)Proxy.getInvocationHandler(local);
                NativeLibrary nativeLibrary = handler.getNativeLibrary();
                log.debugf("Disposing JNA native library %s", (Object)nativeLibrary);
                try {
                    nativeLibrary.dispose();
                }
                catch (Throwable e) {
                    log.errorfe("Error disposing of %s", nativeLibrary, e);
                }
            }
        });
    }
}

