/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.sql.SQLException;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ng.AbstractFbBlob;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.wire.FbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;

public abstract class AbstractFbWireBlob
extends AbstractFbBlob
implements FbWireBlob {
    private int blobHandle;

    protected AbstractFbWireBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer) {
        super(database, transaction, blobParameterBuffer);
    }

    @Override
    public FbWireDatabase getDatabase() {
        return (FbWireDatabase)super.getDatabase();
    }

    @Override
    public final int getHandle() {
        try (LockCloseable ignored = this.withLock();){
            int n = this.blobHandle;
            return n;
        }
    }

    protected final void setHandle(int blobHandle) {
        try (LockCloseable ignored = this.withLock();){
            this.blobHandle = blobHandle;
        }
    }

    protected void releaseBlob(int releaseOperation) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.getDatabase().releaseObject(releaseOperation, this.getHandle());
        }
    }

    @Override
    protected void closeImpl() throws SQLException {
        try {
            this.releaseBlob(39);
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    protected void cancelImpl() throws SQLException {
        try {
            this.releaseBlob(38);
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    protected void releaseResources() {
    }

    @Override
    public byte[] getBlobInfo(byte[] requestItems, int bufferLength) throws SQLException {
        try {
            return this.getDatabase().getInfo(43, this.getHandle(), requestItems, bufferLength, null);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }
}

