/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.ShortByReference;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ng.AbstractFbBlob;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.jna.JnaDatabase;
import org.firebirdsql.gds.ng.jna.JnaTransaction;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.ISC_STATUS;
import org.firebirdsql.util.ByteArrayHelper;

public class JnaBlob
extends AbstractFbBlob
implements FbBlob,
DatabaseListener {
    private final LongByReference blobId;
    private final boolean outputBlob;
    private final IntByReference jnaHandle = new IntByReference(0);
    private final ISC_STATUS[] statusVector = new ISC_STATUS[20];
    private final FbClientLibrary clientLibrary;
    private ByteBuffer byteBuffer;

    public JnaBlob(JnaDatabase database, JnaTransaction transaction, BlobParameterBuffer blobParameterBuffer) throws SQLException {
        this(database, transaction, blobParameterBuffer, 0L, true);
    }

    public JnaBlob(JnaDatabase database, JnaTransaction transaction, BlobParameterBuffer blobParameterBuffer, long blobId) throws SQLException {
        this(database, transaction, blobParameterBuffer, blobId, false);
    }

    private JnaBlob(JnaDatabase database, JnaTransaction transaction, BlobParameterBuffer blobParameterBuffer, long blobId, boolean outputBlob) throws SQLException {
        super(database, transaction, blobParameterBuffer);
        this.blobId = new LongByReference(blobId);
        this.outputBlob = outputBlob;
        this.clientLibrary = database.getClientLibrary();
    }

    @Override
    public JnaDatabase getDatabase() {
        return (JnaDatabase)super.getDatabase();
    }

    @Override
    public JnaTransaction getTransaction() {
        return (JnaTransaction)super.getTransaction();
    }

    @Override
    public int getHandle() {
        return this.jnaHandle.getValue();
    }

    public final IntByReference getJnaHandle() {
        return this.jnaHandle;
    }

    @Override
    public final long getBlobId() {
        return this.blobId.getValue();
    }

    @Override
    public void open() throws SQLException {
        try {
            if (this.isOutput() && this.getBlobId() != 0L) {
                throw new FbExceptionBuilder().nonTransientException(335544368).toSQLException();
            }
            BlobParameterBuffer blobParameterBuffer = this.getBlobParameterBuffer();
            byte[] bpb = blobParameterBuffer != null ? blobParameterBuffer.toBytesWithType() : ByteArrayHelper.emptyByteArray();
            try (LockCloseable ignored = this.withLock();){
                this.checkDatabaseAttached();
                this.checkTransactionActive();
                this.checkBlobClosed();
                this.clearDeferredException();
                JnaDatabase db = this.getDatabase();
                if (this.isOutput()) {
                    this.clientLibrary.isc_create_blob2(this.statusVector, db.getJnaHandle(), this.getTransaction().getJnaHandle(), this.getJnaHandle(), this.blobId, (short)bpb.length, bpb);
                } else {
                    this.clientLibrary.isc_open_blob2(this.statusVector, db.getJnaHandle(), this.getTransaction().getJnaHandle(), this.getJnaHandle(), this.blobId, (short)bpb.length, bpb);
                }
                this.processStatusVector();
                this.setState(AbstractFbBlob.BlobState.OPEN);
                this.resetEof();
                this.throwAndClearDeferredException();
            }
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public final boolean isOutput() {
        return this.outputBlob;
    }

    @Override
    public byte[] getSegment(int sizeRequested) throws SQLException {
        LockCloseable ignored = this.withLock();
        try {
            if (sizeRequested <= 0) {
                throw FbExceptionBuilder.forException(337248257).messageParameter(sizeRequested).toSQLException();
            }
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobOpen();
            ShortByReference actualLength = new ShortByReference();
            ByteBuffer responseBuffer = this.getSegment0(sizeRequested, actualLength);
            this.throwAndClearDeferredException();
            byte[] segment = new byte[actualLength.getValue() & 0xFFFF];
            responseBuffer.get(segment);
            byte[] byArray = segment;
            if (ignored != null) {
                ignored.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.errorOccurred(e);
                throw e;
            }
        }
    }

    private ByteBuffer getSegment0(int sizeRequested, ShortByReference actualLength) throws SQLException {
        sizeRequested = Math.min(sizeRequested, this.getMaximumSegmentSize());
        ByteBuffer responseBuffer = this.getByteBuffer(sizeRequested);
        this.clientLibrary.isc_get_segment(this.statusVector, this.getJnaHandle(), actualLength, (short)sizeRequested, responseBuffer);
        int status = this.statusVector[1].intValue();
        if (status == 335544367) {
            this.setEof();
        } else if (status != 0 && status != 335544366) {
            this.processStatusVector();
        }
        return responseBuffer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int get(byte[] b, int off, int len, int minLen) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            int count;
            int dataLength;
            this.validateBufferLength(b, off, len);
            if (len == 0) {
                int n = 0;
                return n;
            }
            if (minLen <= 0 || minLen > len) {
                throw new FbExceptionBuilder().nonTransientException(337248330).messageParameter("minLen", len, minLen).toSQLException();
            }
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobOpen();
            ShortByReference actualLength = new ShortByReference();
            for (count = 0; count < minLen && !this.isEof(); count += dataLength) {
                ByteBuffer segmentBuffer = this.getSegment0(Math.min(len - count, Math.max(this.getBlobBufferSize(), this.currentBufferCapacity())), actualLength);
                dataLength = actualLength.getValue() & 0xFFFF;
                segmentBuffer.get(b, off + count, dataLength);
            }
            this.throwAndClearDeferredException();
            int n = count;
            return n;
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    private int getBlobBufferSize() {
        return this.getDatabase().getConnectionProperties().getBlobBufferSize();
    }

    @Override
    public void put(byte[] b, int off, int len) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.validateBufferLength(b, off, len);
            if (len == 0) {
                throw FbExceptionBuilder.forException(337248258).toSQLException();
            }
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobOpen();
            int count = 0;
            if (off == 0) {
                count = Math.min(len, this.getMaximumSegmentSize());
                this.clientLibrary.isc_put_segment(this.statusVector, this.getJnaHandle(), (short)count, b);
                this.processStatusVector();
                if (count == len) {
                    return;
                }
            }
            byte[] segmentBuffer = new byte[Math.min(len - count, Math.min(this.getBlobBufferSize(), this.getMaximumSegmentSize()))];
            while (count < len) {
                int segmentLength = Math.min(len - count, segmentBuffer.length);
                System.arraycopy(b, off + count, segmentBuffer, 0, segmentLength);
                this.clientLibrary.isc_put_segment(this.statusVector, this.getJnaHandle(), (short)segmentLength, segmentBuffer);
                this.processStatusVector();
                count += segmentLength;
            }
            this.throwAndClearDeferredException();
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public void seek(int offset, FbBlob.SeekMode seekMode) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobOpen();
            IntByReference result = new IntByReference();
            this.clientLibrary.isc_seek_blob(this.statusVector, this.getJnaHandle(), (short)seekMode.getSeekModeId(), offset, result);
            this.processStatusVector();
            this.throwAndClearDeferredException();
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public byte[] getBlobInfo(byte[] requestItems, int bufferLength) throws SQLException {
        try {
            ByteBuffer responseBuffer;
            try (LockCloseable ignored = this.withLock();){
                responseBuffer = this.getByteBuffer(bufferLength);
                this.checkDatabaseAttached();
                this.checkBlobOpen();
                this.clientLibrary.isc_blob_info(this.statusVector, this.getJnaHandle(), (short)requestItems.length, requestItems, (short)bufferLength, responseBuffer);
                this.processStatusVector();
                this.throwAndClearDeferredException();
            }
            byte[] responseArr = new byte[bufferLength];
            responseBuffer.get(responseArr);
            return responseArr;
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    @Override
    protected void closeImpl() throws SQLException {
        try {
            this.clientLibrary.isc_close_blob(this.statusVector, this.getJnaHandle());
            this.processStatusVector();
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    protected void cancelImpl() throws SQLException {
        try {
            this.clientLibrary.isc_cancel_blob(this.statusVector, this.getJnaHandle());
            this.processStatusVector();
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    protected void releaseResources() {
        this.byteBuffer = null;
    }

    private void processStatusVector() throws SQLException {
        this.getDatabase().processStatusVector(this.statusVector, null);
    }

    private ByteBuffer getByteBuffer(int requiredSize) {
        ByteBuffer byteBuffer = this.byteBuffer;
        if (byteBuffer == null || byteBuffer.capacity() < requiredSize) {
            this.byteBuffer = ByteBuffer.allocateDirect((1 + (requiredSize - 1) / 512) * 512);
            return this.byteBuffer;
        }
        byteBuffer.clear();
        return byteBuffer;
    }

    private int currentBufferCapacity() {
        ByteBuffer byteBuffer = this.byteBuffer;
        return byteBuffer != null ? byteBuffer.capacity() : 0;
    }
}

