/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Platform;
import com.sun.jna.ptr.IntByReference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLTransientException;
import java.util.Collections;
import java.util.Set;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.EventHandle;
import org.firebirdsql.gds.EventHandler;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.AbstractFbDatabase;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.ParameterConverter;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.jna.FbClientFeature;
import org.firebirdsql.gds.ng.jna.FbClientFeatureAccess;
import org.firebirdsql.gds.ng.jna.JnaAttachment;
import org.firebirdsql.gds.ng.jna.JnaBlob;
import org.firebirdsql.gds.ng.jna.JnaDatabaseConnection;
import org.firebirdsql.gds.ng.jna.JnaEventHandle;
import org.firebirdsql.gds.ng.jna.JnaParameterConverter;
import org.firebirdsql.gds.ng.jna.JnaStatement;
import org.firebirdsql.gds.ng.jna.JnaTransaction;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.ISC_STATUS;
import org.firebirdsql.jna.fbclient.WinFbClientLibrary;

public class JnaDatabase
extends AbstractFbDatabase<JnaDatabaseConnection>
implements JnaAttachment,
TransactionListener,
FbClientFeatureAccess {
    private static final ParameterConverter<JnaDatabaseConnection, ?> PARAMETER_CONVERTER = new JnaParameterConverter();
    public static final int STATUS_VECTOR_SIZE = 20;
    public static final int MAX_STATEMENT_LENGTH = 65536;
    private final FbClientLibrary clientLibrary;
    private final Set<FbClientFeature> clientFeatures;
    protected final IntByReference handle = new IntByReference(0);
    protected final ISC_STATUS[] statusVector = new ISC_STATUS[20];

    public JnaDatabase(JnaDatabaseConnection connection) {
        super(connection, connection.createDatatypeCoder());
        this.clientLibrary = connection.getClientLibrary();
        this.clientFeatures = this.clientLibrary instanceof FbClientFeatureAccess ? ((FbClientFeatureAccess)((Object)this.clientLibrary)).getFeatures() : Collections.emptySet();
    }

    protected final FbClientLibrary getClientLibrary() {
        return this.clientLibrary;
    }

    @Override
    protected void checkConnected() throws SQLException {
        if (!this.isAttached()) {
            throw FbExceptionBuilder.forException(337248274).toSQLException();
        }
    }

    @Override
    protected void internalDetach() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                this.clientLibrary.isc_detach_database(this.statusVector, this.handle);
                this.processStatusVector();
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new FbExceptionBuilder().exception(335544721).messageParameter(((JnaDatabaseConnection)this.connection).getAttachUrl()).cause(ex).toSQLException();
            }
            finally {
                this.setDetached();
            }
        }
    }

    @Override
    public void attach() throws SQLException {
        try {
            DatabaseParameterBuffer dpb = PARAMETER_CONVERTER.toDatabaseParameterBuffer((JnaDatabaseConnection)this.connection);
            this.attachOrCreate(dpb, false);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected void attachOrCreate(DatabaseParameterBuffer dpb, boolean create) throws SQLException {
        if (this.isAttached()) {
            throw new SQLException("Already attached to a database");
        }
        byte[] dbName = this.getEncoding().encodeToCharset(((JnaDatabaseConnection)this.connection).getAttachUrl());
        byte[] dpbArray = dpb.toBytesWithType();
        try (LockCloseable ignored = this.withLock();){
            try {
                if (create) {
                    this.clientLibrary.isc_create_database(this.statusVector, (short)dbName.length, dbName, this.handle, (short)dpbArray.length, dpbArray, this.getConnectionDialect());
                } else {
                    this.clientLibrary.isc_attach_database(this.statusVector, (short)dbName.length, dbName, this.handle, (short)dpbArray.length, dpbArray);
                }
                this.processStatusVector();
            }
            catch (SQLException ex) {
                this.safelyDetach();
                throw ex;
            }
            catch (Exception ex) {
                this.safelyDetach();
                throw new FbExceptionBuilder().exception(335544721).messageParameter(((JnaDatabaseConnection)this.connection).getAttachUrl()).cause(ex).toSQLException();
            }
            this.setAttached();
            this.afterAttachActions();
        }
    }

    protected void afterAttachActions() throws SQLException {
        this.getDatabaseInfo(this.getDescribeDatabaseInfoBlock(), 1024, this.getDatabaseInformationProcessor());
    }

    @Override
    public void createDatabase() throws SQLException {
        try {
            DatabaseParameterBuffer dpb = PARAMETER_CONVERTER.toDatabaseParameterBuffer((JnaDatabaseConnection)this.connection);
            this.attachOrCreate(dpb, true);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public void dropDatabase() throws SQLException {
        try {
            this.checkConnected();
            try (LockCloseable ignored = this.withLock();){
                try {
                    this.clientLibrary.isc_drop_database(this.statusVector, this.handle);
                    this.processStatusVector();
                }
                finally {
                    this.setDetached();
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public void cancelOperation(int kind) throws SQLException {
        try {
            this.checkConnected();
            try {
                this.clientLibrary.fb_cancel_operation(this.statusVector, this.handle, (short)kind);
            }
            finally {
                if (kind == 4) {
                    this.setDetached();
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public JnaTransaction startTransaction(TransactionParameterBuffer tpb) throws SQLException {
        this.checkConnected();
        IntByReference transactionHandle = new IntByReference(0);
        byte[] tpbArray = tpb.toBytesWithType();
        LockCloseable ignored = this.withLock();
        try {
            this.clientLibrary.isc_start_transaction(this.statusVector, transactionHandle, (short)1, this.handle, (short)tpbArray.length, tpbArray);
            this.processStatusVector();
            JnaTransaction transaction = new JnaTransaction(this, transactionHandle, TransactionState.ACTIVE);
            this.transactionAdded(transaction);
            JnaTransaction jnaTransaction = transaction;
            if (ignored != null) {
                ignored.close();
            }
            return jnaTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.exceptionListenerDispatcher.errorOccurred(e);
                throw e;
            }
        }
    }

    @Override
    public FbTransaction reconnectTransaction(long transactionId) throws SQLException {
        this.checkConnected();
        byte[] transactionIdBuffer = this.getTransactionIdBuffer(transactionId);
        IntByReference transactionHandle = new IntByReference(0);
        LockCloseable ignored = this.withLock();
        try {
            this.clientLibrary.isc_reconnect_transaction(this.statusVector, this.handle, transactionHandle, (short)transactionIdBuffer.length, transactionIdBuffer);
            this.processStatusVector();
            JnaTransaction transaction = new JnaTransaction(this, transactionHandle, TransactionState.PREPARED);
            this.transactionAdded(transaction);
            JnaTransaction jnaTransaction = transaction;
            if (ignored != null) {
                ignored.close();
            }
            return jnaTransaction;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.exceptionListenerDispatcher.errorOccurred(e);
                throw e;
            }
        }
    }

    protected byte[] getTransactionIdBuffer(long transactionId) {
        ByteArrayOutputStream bos;
        if ((transactionId & Integer.MAX_VALUE) == transactionId) {
            bos = new ByteArrayOutputStream(4);
            try {
                VaxEncoding.encodeVaxIntegerWithoutLength(bos, (int)transactionId);
            }
            catch (IOException iOException) {}
        } else {
            bos = new ByteArrayOutputStream(8);
            try {
                VaxEncoding.encodeVaxLongWithoutLength(bos, transactionId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bos.toByteArray();
    }

    @Override
    public JnaStatement createStatement(FbTransaction transaction) throws SQLException {
        try {
            this.checkConnected();
            JnaStatement stmt = new JnaStatement(this);
            stmt.addExceptionListener(this.exceptionListenerDispatcher);
            stmt.setTransaction(transaction);
            return stmt;
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public FbBlob createBlobForOutput(FbTransaction transaction, BlobParameterBuffer blobParameterBuffer) throws SQLException {
        JnaBlob jnaBlob = new JnaBlob(this, (JnaTransaction)transaction, blobParameterBuffer);
        jnaBlob.addExceptionListener(this.exceptionListenerDispatcher);
        return jnaBlob;
    }

    @Override
    public FbBlob createBlobForInput(FbTransaction transaction, BlobParameterBuffer blobParameterBuffer, long blobId) throws SQLException {
        JnaBlob jnaBlob = new JnaBlob(this, (JnaTransaction)transaction, blobParameterBuffer, blobId);
        jnaBlob.addExceptionListener(this.exceptionListenerDispatcher);
        return jnaBlob;
    }

    @Override
    public byte[] getDatabaseInfo(byte[] requestItems, int maxBufferLength) throws SQLException {
        try {
            ByteBuffer responseBuffer = ByteBuffer.allocateDirect(maxBufferLength);
            try (LockCloseable ignored = this.withLock();){
                this.clientLibrary.isc_database_info(this.statusVector, this.handle, (short)requestItems.length, requestItems, (short)maxBufferLength, responseBuffer);
                this.processStatusVector();
            }
            byte[] responseArray = new byte[maxBufferLength];
            responseBuffer.get(responseArray);
            return responseArray;
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public void executeImmediate(String statementText, FbTransaction transaction) throws SQLException {
        try {
            if (this.isAttached()) {
                if (transaction == null) {
                    throw FbExceptionBuilder.forException(337248270).toSQLException();
                }
                if (!(transaction instanceof JnaTransaction)) {
                    throw new SQLNonTransientException(String.format("Invalid transaction handle type: %s, expected: %s", transaction.getClass(), JnaTransaction.class));
                }
                TransactionHelper.checkTransactionActive(transaction);
            } else if (transaction != null) {
                throw FbExceptionBuilder.forException(337248271).toSQLException();
            }
            byte[] statementArray = this.getEncoding().encodeToCharset(statementText);
            try (LockCloseable ignored = this.withLock();){
                this.clientLibrary.isc_dsql_execute_immediate(this.statusVector, this.handle, transaction != null ? ((JnaTransaction)transaction).getJnaHandle() : new IntByReference(), (short)statementArray.length, statementArray, this.getConnectionDialect(), null);
                this.processStatusVector();
                if (!this.isAttached()) {
                    this.setAttached();
                    this.afterAttachActions();
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public int getHandle() {
        return this.handle.getValue();
    }

    @Override
    public void setNetworkTimeout(int milliseconds) throws SQLException {
        throw new FBDriverNotCapableException("Setting network timeout not supported in native implementation");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new FBDriverNotCapableException("Getting network timeout not supported in native implementation");
    }

    public IntByReference getJnaHandle() {
        return this.handle;
    }

    public final EncodingDefinition getEncodingDefinition() {
        return ((JnaDatabaseConnection)this.connection).getEncodingDefinition();
    }

    protected JnaEventHandle validateEventHandle(EventHandle eventHandle) throws SQLException {
        if (!(eventHandle instanceof JnaEventHandle)) {
            throw new SQLNonTransientException(String.format("Invalid event handle type: %s, expected: %s", eventHandle.getClass(), JnaEventHandle.class));
        }
        JnaEventHandle jnaEventHandle = (JnaEventHandle)eventHandle;
        if (jnaEventHandle.getSize() == -1) {
            throw new SQLTransientException("Event handle hasn't been initialized");
        }
        return jnaEventHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JnaEventHandle createEventHandle(String eventName, EventHandler eventHandler) throws SQLException {
        JnaEventHandle eventHandle = new JnaEventHandle(eventName, eventHandler, this.getEncoding());
        try (LockCloseable ignored = this.withLock();){
            JnaEventHandle jnaEventHandle = eventHandle;
            synchronized (jnaEventHandle) {
                int size = this.clientLibrary.isc_event_block(eventHandle.getEventBuffer(), eventHandle.getResultBuffer(), (short)1, eventHandle.getEventNameMemory());
                eventHandle.setSize(size);
            }
        }
        return eventHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countEvents(EventHandle eventHandle) throws SQLException {
        try {
            JnaEventHandle jnaEventHandle = this.validateEventHandle(eventHandle);
            try (LockCloseable ignored = this.withLock();){
                JnaEventHandle jnaEventHandle2 = jnaEventHandle;
                synchronized (jnaEventHandle2) {
                    this.clientLibrary.isc_event_counts(this.statusVector, (short)jnaEventHandle.getSize(), jnaEventHandle.getEventBuffer().getValue(), jnaEventHandle.getResultBuffer().getValue());
                }
            }
            jnaEventHandle.setEventCount(this.statusVector[0].intValue());
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueEvent(EventHandle eventHandle) throws SQLException {
        try {
            this.checkConnected();
            JnaEventHandle jnaEventHandle = this.validateEventHandle(eventHandle);
            try (LockCloseable ignored = this.withLock();){
                JnaEventHandle jnaEventHandle2 = jnaEventHandle;
                synchronized (jnaEventHandle2) {
                    if (Platform.isWindows()) {
                        ((WinFbClientLibrary)this.clientLibrary).isc_que_events(this.statusVector, this.getJnaHandle(), jnaEventHandle.getJnaEventId(), (short)jnaEventHandle.getSize(), jnaEventHandle.getEventBuffer().getValue(), (WinFbClientLibrary.IscEventStdCallback)jnaEventHandle.getCallback(), jnaEventHandle.getResultBuffer().getValue());
                    } else {
                        this.clientLibrary.isc_que_events(this.statusVector, this.getJnaHandle(), jnaEventHandle.getJnaEventId(), (short)jnaEventHandle.getSize(), jnaEventHandle.getEventBuffer().getValue(), jnaEventHandle.getCallback(), jnaEventHandle.getResultBuffer().getValue());
                    }
                }
                this.processStatusVector();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelEvent(EventHandle eventHandle) throws SQLException {
        try {
            this.checkConnected();
            JnaEventHandle jnaEventHandle = this.validateEventHandle(eventHandle);
            try (LockCloseable ignored = this.withLock();){
                JnaEventHandle jnaEventHandle2 = jnaEventHandle;
                synchronized (jnaEventHandle2) {
                    try {
                        this.clientLibrary.isc_cancel_events(this.statusVector, this.getJnaHandle(), jnaEventHandle.getJnaEventId());
                        this.processStatusVector();
                    }
                    finally {
                        jnaEventHandle.releaseMemory(this.clientLibrary);
                    }
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void processStatusVector() throws SQLException {
        this.processStatusVector(this.statusVector, this.getDatabaseWarningCallback());
    }

    public void processStatusVector(ISC_STATUS[] statusVector, WarningMessageCallback warningMessageCallback) throws SQLException {
        if (warningMessageCallback == null) {
            warningMessageCallback = this.getDatabaseWarningCallback();
        }
        ((JnaDatabaseConnection)this.connection).processStatusVector(statusVector, warningMessageCallback);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.isAttached()) {
                this.safelyDetach();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public boolean hasFeature(FbClientFeature clientFeature) {
        return this.clientFeatures.contains((Object)clientFeature);
    }

    @Override
    public Set<FbClientFeature> getFeatures() {
        return this.clientFeatures;
    }
}

