/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version11;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Optional;
import java.util.function.Function;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ClumpletReader;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractFbBlob;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.wire.AbstractFbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.version10.V10InputBlob;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.ByteArrayHelper;

public class V11InputBlob
extends V10InputBlob {
    private byte[] cachedBlobInfo = ByteArrayHelper.emptyByteArray();

    public V11InputBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer, long blobId) throws SQLException {
        super(database, transaction, blobParameterBuffer, blobId);
    }

    @Override
    public void open() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobClosed();
            this.clearDeferredException();
            this.setHandle(65535);
            this.setState(AbstractFbBlob.BlobState.DELAYED_OPEN);
            this.resetEof();
        }
    }

    @Override
    protected void checkBlobOpen() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            super.checkBlobOpen();
            if (this.getState() == AbstractFbBlob.BlobState.DELAYED_OPEN) {
                this.setState(AbstractFbBlob.BlobState.PENDING_OPEN);
                this.deferredOpen();
                this.getBlobInfoOnDeferredOpen();
            }
        }
    }

    private void deferredOpen() throws SQLException {
        this.sendOpen(AbstractFbWireBlob.BlobOpenOperation.INPUT_BLOB, false);
        this.getDatabase().enqueueDeferredAction(this.wrapDeferredResponse(new DeferredResponse<Response>(){

            @Override
            public void onResponse(Response response) {
                if (response instanceof GenericResponse) {
                    try {
                        V11InputBlob.this.processOpenResponse((GenericResponse)response);
                    }
                    catch (SQLException e) {
                        V11InputBlob.this.registerDeferredException(e);
                    }
                } else {
                    LoggerFactory.getLogger(this.getClass()).debugf("Expected response of type GenericResponse for blob open, but received a %s", (Object)(response != null ? response.getClass().getName() : "(null)"));
                }
            }
        }, Function.identity()));
    }

    private void getBlobInfoOnDeferredOpen() throws SQLException {
        byte[] knownBlobInfoItems = this.getKnownBlobInfoItems();
        if (knownBlobInfoItems.length == 0) {
            return;
        }
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            xdrOut.writeInt(43);
            xdrOut.writeInt(this.getHandle());
            xdrOut.writeInt(0);
            xdrOut.writeBuffer(knownBlobInfoItems);
            xdrOut.writeInt(512);
        }
        catch (IOException e) {
            throw new FbExceptionBuilder().exception(335544727).cause(e).toSQLException();
        }
        this.getDatabase().enqueueDeferredAction(this.wrapDeferredResponse(new DeferredResponse<Response>(){

            @Override
            public void onResponse(Response response) {
                if (response instanceof GenericResponse) {
                    V11InputBlob.this.processBlobInfoOnDeferredOpenResponse((GenericResponse)response);
                } else {
                    LoggerFactory.getLogger(this.getClass()).debugf("Expected response of type GenericResponse for blob info on deferred open, but received a %s", (Object)(response != null ? response.getClass().getName() : "(null)"));
                }
            }
        }, Function.identity()));
    }

    private void processBlobInfoOnDeferredOpenResponse(GenericResponse genericResponse) {
        this.cachedBlobInfo = genericResponse.getData();
    }

    @Override
    public byte[] getBlobInfo(byte[] requestItems, int bufferLength) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkDatabaseAttached();
            this.checkTransactionActive();
            this.checkBlobOpen();
            this.completePendingOpen();
            Optional<byte[]> fromCache = this.blobInfoFromCache(requestItems);
            byte[] byArray = fromCache.isPresent() ? fromCache.get() : super.getBlobInfo(requestItems, bufferLength);
            return byArray;
        }
    }

    private void completePendingOpen() throws SQLException {
        if (this.getState() != AbstractFbBlob.BlobState.PENDING_OPEN) {
            return;
        }
        this.completePendingOpen0();
    }

    private void completePendingOpen0() throws SQLException {
        try {
            try {
                this.getXdrOut().flush();
            }
            catch (IOException e) {
                throw new FbExceptionBuilder().exception(335544727).cause(e).toSQLException();
            }
            this.getDatabase().getWireOperations().processDeferredActions();
            this.throwAndClearDeferredException();
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    private Optional<byte[]> blobInfoFromCache(byte[] requestItems) {
        if (this.cachedBlobInfo.length == 0) {
            return Optional.empty();
        }
        try {
            ClumpletReader requested = new ClumpletReader(ClumpletReader.Kind.InfoItems, requestItems);
            ClumpletReader cached = new ClumpletReader(ClumpletReader.Kind.InfoResponse, this.cachedBlobInfo);
            ByteArrayOutputStream response = new ByteArrayOutputStream();
            requested.rewind();
            while (!requested.isEof()) {
                int requestItem = requested.getClumpTag();
                if (!cached.find(requestItem)) {
                    LoggerFactory.getLogger(this.getClass()).debugf("Requested blob info item %s not in cache, deferring to server", (Object)requestItem);
                    return Optional.empty();
                }
                byte[] data = cached.getBytes();
                response.write(requestItem);
                VaxEncoding.encodeVaxInteger2WithoutLength(response, data.length);
                response.write(data);
                requested.moveNext();
            }
            response.write(1);
            return Optional.of(response.toByteArray());
        }
        catch (IOException | SQLException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error in blobInfoFromCache, deferring to server", e);
            return Optional.empty();
        }
    }
}

