/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.firebirdsql.extern.decimal.Decimal;
import org.firebirdsql.extern.decimal.Decimal128;
import org.firebirdsql.extern.decimal.Decimal32;
import org.firebirdsql.extern.decimal.Decimal64;
import org.firebirdsql.extern.decimal.OverflowHandling;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.field.FBBigDecimalField;
import org.firebirdsql.jdbc.field.FBBinaryField;
import org.firebirdsql.jdbc.field.FBBlobField;
import org.firebirdsql.jdbc.field.FBBooleanField;
import org.firebirdsql.jdbc.field.FBCachedBlobField;
import org.firebirdsql.jdbc.field.FBCachedLongVarCharField;
import org.firebirdsql.jdbc.field.FBDateField;
import org.firebirdsql.jdbc.field.FBDecfloatField;
import org.firebirdsql.jdbc.field.FBDoubleField;
import org.firebirdsql.jdbc.field.FBFloatField;
import org.firebirdsql.jdbc.field.FBIntegerField;
import org.firebirdsql.jdbc.field.FBLongField;
import org.firebirdsql.jdbc.field.FBLongVarCharField;
import org.firebirdsql.jdbc.field.FBNullField;
import org.firebirdsql.jdbc.field.FBRowIdField;
import org.firebirdsql.jdbc.field.FBShortField;
import org.firebirdsql.jdbc.field.FBStringField;
import org.firebirdsql.jdbc.field.FBTimeField;
import org.firebirdsql.jdbc.field.FBTimeTzField;
import org.firebirdsql.jdbc.field.FBTimestampField;
import org.firebirdsql.jdbc.field.FBTimestampTzField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;
import org.firebirdsql.jdbc.field.TypeConversionException;

public abstract class FBField {
    static final String SQL_TYPE_NOT_SUPPORTED = "SQL type for this field is not yet supported.";
    static final String SQL_ARRAY_NOT_SUPPORTED = "Types.ARRAY: SQL type for this field is not yet supported.";
    static final byte BYTE_NULL_VALUE = 0;
    static final short SHORT_NULL_VALUE = 0;
    static final int INT_NULL_VALUE = 0;
    static final long LONG_NULL_VALUE = 0L;
    static final float FLOAT_NULL_VALUE = 0.0f;
    static final double DOUBLE_NULL_VALUE = 0.0;
    static final boolean BOOLEAN_NULL_VALUE = false;
    static final byte MAX_BYTE_VALUE = 127;
    static final byte MIN_BYTE_VALUE = -128;
    static final short MAX_SHORT_VALUE = Short.MAX_VALUE;
    static final short MIN_SHORT_VALUE = Short.MIN_VALUE;
    static final int MAX_INT_VALUE = Integer.MAX_VALUE;
    static final int MIN_INT_VALUE = Integer.MIN_VALUE;
    static final long MAX_LONG_VALUE = Long.MAX_VALUE;
    static final long MIN_LONG_VALUE = Long.MIN_VALUE;
    static final float MAX_FLOAT_VALUE = Float.MAX_VALUE;
    static final float MIN_FLOAT_VALUE = -3.4028235E38f;
    static final double MAX_DOUBLE_VALUE = Double.MAX_VALUE;
    static final double MIN_DOUBLE_VALUE = -1.7976931348623157E308;
    protected final FieldDescriptor fieldDescriptor;
    private final FieldDataProvider dataProvider;
    protected GDSHelper gdsHelper;
    protected int requiredType;

    FBField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        if (fieldDescriptor == null) {
            throw new FBSQLException("Cannot create FBField instance with fieldDescriptor null.", "HY009");
        }
        this.fieldDescriptor = fieldDescriptor;
        this.dataProvider = dataProvider;
        this.requiredType = requiredType;
    }

    protected final byte[] getFieldData() {
        return this.dataProvider.getFieldData();
    }

    protected final void setFieldData(byte[] data) {
        this.dataProvider.setFieldData(data);
    }

    protected final DatatypeCoder getDatatypeCoder() {
        return this.fieldDescriptor.getDatatypeCoder();
    }

    public final boolean isNull() throws SQLException {
        return this.getFieldData() == null;
    }

    public void setNull() {
        this.setFieldData(null);
    }

    public void setConnection(GDSHelper gdsHelper) {
        this.gdsHelper = gdsHelper;
    }

    public void setRequiredType(int requiredType) {
        this.requiredType = requiredType;
    }

    public static FBField createField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, GDSHelper gdsHelper, boolean cached) throws SQLException {
        int jdbcType = JdbcTypeConverter.toJdbcType(fieldDescriptor);
        switch (jdbcType) {
            case -1: {
                if (cached) {
                    return new FBCachedLongVarCharField(fieldDescriptor, dataProvider, jdbcType, gdsHelper);
                }
                return new FBLongVarCharField(fieldDescriptor, dataProvider, jdbcType, gdsHelper);
            }
            case -4: 
            case 2004: {
                if (cached) {
                    return new FBCachedBlobField(fieldDescriptor, dataProvider, jdbcType, gdsHelper);
                }
                return new FBBlobField(fieldDescriptor, dataProvider, jdbcType, gdsHelper);
            }
        }
        FBField result = FBField.createField(jdbcType, fieldDescriptor, dataProvider);
        result.setConnection(gdsHelper);
        return result;
    }

    private static FBField createField(int jdbcType, FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider) throws SQLException {
        switch (jdbcType) {
            case 5: {
                return new FBShortField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 4: {
                return new FBIntegerField(fieldDescriptor, dataProvider, jdbcType);
            }
            case -5: {
                return new FBLongField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 2: 
            case 3: {
                return new FBBigDecimalField(fieldDescriptor, dataProvider, jdbcType);
            }
            case -6001: {
                switch (fieldDescriptor.getType() & 0xFFFFFFFE) {
                    case 32760: {
                        return new FBDecfloatField<Decimal64>(fieldDescriptor, dataProvider, jdbcType, Decimal64.class);
                    }
                    case 32762: {
                        return new FBDecfloatField<Decimal128>(fieldDescriptor, dataProvider, jdbcType, Decimal128.class);
                    }
                }
            }
            case 6: {
                return new FBFloatField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 8: {
                return new FBDoubleField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 92: {
                return new FBTimeField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 91: {
                return new FBDateField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 93: {
                return new FBTimestampField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 2014: {
                return new FBTimestampTzField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 2013: {
                return new FBTimeTzField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 1: 
            case 12: {
                return new FBStringField(fieldDescriptor, dataProvider, jdbcType);
            }
            case -3: 
            case -2: {
                return new FBBinaryField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 16: {
                return new FBBooleanField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 0: {
                return new FBNullField(fieldDescriptor, dataProvider, jdbcType);
            }
            case -8: {
                return new FBRowIdField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 2003: {
                throw new FBDriverNotCapableException(SQL_ARRAY_NOT_SUPPORTED);
            }
        }
        throw new FBDriverNotCapableException(SQL_TYPE_NOT_SUPPORTED);
    }

    public String getName() {
        return this.fieldDescriptor.getOriginalName();
    }

    public String getAlias() {
        return this.fieldDescriptor.getFieldName();
    }

    public String getRelationName() {
        return this.fieldDescriptor.getOriginalTableName();
    }

    public byte getByte() throws SQLException {
        throw this.invalidGetConversion("byte");
    }

    public short getShort() throws SQLException {
        throw this.invalidGetConversion("short");
    }

    public int getInt() throws SQLException {
        throw this.invalidGetConversion("int");
    }

    public long getLong() throws SQLException {
        throw this.invalidGetConversion("long");
    }

    public float getFloat() throws SQLException {
        throw this.invalidGetConversion("float");
    }

    public double getDouble() throws SQLException {
        throw this.invalidGetConversion("double");
    }

    public BigDecimal getBigDecimal() throws SQLException {
        throw this.invalidGetConversion(BigDecimal.class);
    }

    public final BigDecimal getBigDecimal(int scale) throws SQLException {
        return this.getBigDecimal();
    }

    public boolean getBoolean() throws SQLException {
        throw this.invalidGetConversion("boolean");
    }

    public String getString() throws SQLException {
        throw this.invalidGetConversion(String.class);
    }

    public Object getObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        throw this.invalidGetConversion(Object.class);
    }

    public Object getObject(Map<String, Class<?>> map) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public <T> T getObject(Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLNonTransientException("getObject called with type null");
        }
        switch (type.getName()) {
            case "java.lang.Boolean": {
                return (T)(this.isNull() ? null : Boolean.valueOf(this.getBoolean()));
            }
            case "java.lang.Byte": {
                return (T)(this.isNull() ? null : Byte.valueOf(this.getByte()));
            }
            case "java.lang.Short": {
                return (T)(this.isNull() ? null : Short.valueOf(this.getShort()));
            }
            case "java.lang.Integer": {
                return (T)(this.isNull() ? null : Integer.valueOf(this.getInt()));
            }
            case "java.lang.Long": {
                return (T)(this.isNull() ? null : Long.valueOf(this.getLong()));
            }
            case "java.lang.Float": {
                return (T)(this.isNull() ? null : Float.valueOf(this.getFloat()));
            }
            case "java.lang.Double": {
                return (T)(this.isNull() ? null : Double.valueOf(this.getDouble()));
            }
            case "java.math.BigDecimal": {
                return (T)this.getBigDecimal();
            }
            case "java.math.BigInteger": {
                return (T)this.getBigInteger();
            }
            case "java.lang.String": {
                return (T)this.getString();
            }
            case "[B": {
                return (T)this.getBytes();
            }
            case "java.sql.Date": {
                return (T)this.getDate();
            }
            case "java.time.LocalDate": {
                return (T)this.getLocalDate();
            }
            case "java.util.Date": 
            case "java.sql.Timestamp": {
                return (T)this.getTimestamp();
            }
            case "java.time.LocalDateTime": {
                return (T)this.getLocalDateTime();
            }
            case "java.sql.Time": {
                return (T)this.getTime();
            }
            case "java.time.LocalTime": {
                return (T)this.getLocalTime();
            }
            case "java.util.Calendar": {
                if (this.isNull()) {
                    return null;
                }
                Timestamp timestamp = this.getTimestamp();
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTimeInMillis(timestamp.getTime());
                return (T)calendar;
            }
            case "java.time.OffsetTime": {
                return (T)this.getOffsetTime();
            }
            case "java.time.OffsetDateTime": {
                return (T)this.getOffsetDateTime();
            }
            case "java.time.ZonedDateTime": {
                return (T)this.getZonedDateTime();
            }
            case "java.sql.Clob": 
            case "java.sql.NClob": {
                return (T)this.getClob();
            }
            case "java.sql.Blob": 
            case "org.firebirdsql.jdbc.FirebirdBlob": {
                return (T)this.getBlob();
            }
            case "java.io.InputStream": {
                return (T)this.getBinaryStream();
            }
            case "java.io.Reader": {
                return (T)this.getCharacterStream();
            }
            case "java.sql.RowId": 
            case "org.firebirdsql.jdbc.FBRowId": {
                return (T)this.getRowId();
            }
            case "org.firebirdsql.gds.ng.DatatypeCoder$RawDateTimeStruct": {
                return (T)this.getRawDateTimeStruct();
            }
            case "org.firebirdsql.extern.decimal.Decimal": {
                return (T)this.getDecimal();
            }
            case "org.firebirdsql.extern.decimal.Decimal32": {
                return (T)this.getDecimal(Decimal32.class);
            }
            case "org.firebirdsql.extern.decimal.Decimal64": {
                return (T)this.getDecimal(Decimal64.class);
            }
            case "org.firebirdsql.extern.decimal.Decimal128": {
                return (T)this.getDecimal(Decimal128.class);
            }
        }
        throw this.invalidGetConversion(type);
    }

    private String getJdbcTypeName() {
        return FBField.getJdbcTypeName(this.requiredType);
    }

    static String getJdbcTypeName(int jdbcType) {
        if (jdbcType == -6001) {
            return "DECFLOAT";
        }
        try {
            return JDBCType.valueOf(jdbcType).name();
        }
        catch (IllegalArgumentException e) {
            return String.valueOf(jdbcType);
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        throw this.invalidGetConversion(InputStream.class);
    }

    public Reader getCharacterStream() throws SQLException {
        InputStream is = this.getBinaryStream();
        if (is == null) {
            return null;
        }
        return this.getDatatypeCoder().createReader(is);
    }

    public byte[] getBytes() throws SQLException {
        throw this.invalidGetConversion("byte[]");
    }

    public Blob getBlob() throws SQLException {
        throw this.invalidGetConversion(Blob.class);
    }

    public Date getDate() throws SQLException {
        throw this.invalidGetConversion(Date.class);
    }

    public Date getDate(Calendar cal) throws SQLException {
        throw this.invalidGetConversion(Date.class);
    }

    LocalDate getLocalDate() throws SQLException {
        throw this.invalidGetConversion(LocalDate.class);
    }

    public Time getTime() throws SQLException {
        throw this.invalidGetConversion(Time.class);
    }

    public Time getTime(Calendar cal) throws SQLException {
        throw this.invalidGetConversion(Time.class);
    }

    LocalTime getLocalTime() throws SQLException {
        throw this.invalidGetConversion(LocalTime.class);
    }

    public Timestamp getTimestamp() throws SQLException {
        throw this.invalidGetConversion(Timestamp.class);
    }

    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        throw this.invalidGetConversion(Timestamp.class);
    }

    LocalDateTime getLocalDateTime() throws SQLException {
        throw this.invalidGetConversion(LocalDateTime.class);
    }

    OffsetTime getOffsetTime() throws SQLException {
        throw this.invalidGetConversion(OffsetTime.class);
    }

    OffsetDateTime getOffsetDateTime() throws SQLException {
        throw this.invalidGetConversion(OffsetDateTime.class);
    }

    ZonedDateTime getZonedDateTime() throws SQLException {
        throw this.invalidGetConversion(ZonedDateTime.class);
    }

    public Ref getRef() throws SQLException {
        throw new FBDriverNotCapableException("Type REF not supported");
    }

    public Clob getClob() throws SQLException {
        throw this.invalidGetConversion(Clob.class);
    }

    public Array getArray() throws SQLException {
        throw new FBDriverNotCapableException("Type ARRAY not yet supported");
    }

    public BigInteger getBigInteger() throws SQLException {
        throw this.invalidGetConversion(BigInteger.class);
    }

    public RowId getRowId() throws SQLException {
        throw this.invalidGetConversion(RowId.class);
    }

    public void setByte(byte value) throws SQLException {
        throw this.invalidSetConversion("byte");
    }

    public void setShort(short value) throws SQLException {
        throw this.invalidSetConversion("short");
    }

    public void setInteger(int value) throws SQLException {
        throw this.invalidSetConversion("int");
    }

    public void setLong(long value) throws SQLException {
        throw this.invalidSetConversion("long");
    }

    public void setFloat(float value) throws SQLException {
        throw this.invalidSetConversion("float");
    }

    public void setDouble(double value) throws SQLException {
        throw this.invalidSetConversion("double");
    }

    public void setBigDecimal(BigDecimal value) throws SQLException {
        throw this.invalidSetConversion(BigDecimal.class);
    }

    public void setBoolean(boolean value) throws SQLException {
        throw this.invalidSetConversion("boolean");
    }

    public void setString(String value) throws SQLException {
        throw this.invalidSetConversion(String.class);
    }

    public void setBigInteger(BigInteger value) throws SQLException {
        throw this.invalidSetConversion(BigInteger.class);
    }

    public void setObject(Object value) throws SQLException {
        String typeName;
        if (value == null) {
            this.setNull();
            return;
        }
        switch (typeName = value.getClass().getName()) {
            case "java.math.BigDecimal": {
                this.setBigDecimal((BigDecimal)value);
                return;
            }
            case "org.firebirdsql.jdbc.FBBlob": {
                this.setBlob((FBBlob)value);
                return;
            }
            case "org.firebirdsql.jdbc.FBClob": {
                this.setClob((FBClob)value);
                return;
            }
            case "java.lang.Boolean": {
                this.setBoolean((Boolean)value);
                return;
            }
            case "java.lang.Byte": {
                this.setByte((Byte)value);
                return;
            }
            case "[B": {
                this.setBytes((byte[])value);
                return;
            }
            case "java.sql.Date": {
                this.setDate((Date)value);
                return;
            }
            case "java.time.LocalDate": {
                this.setLocalDate((LocalDate)value);
                return;
            }
            case "java.lang.Double": {
                this.setDouble((Double)value);
                return;
            }
            case "java.lang.Float": {
                this.setFloat(((Float)value).floatValue());
                return;
            }
            case "java.lang.Integer": {
                this.setInteger((Integer)value);
                return;
            }
            case "java.lang.Long": {
                this.setLong((Long)value);
                return;
            }
            case "java.lang.Short": {
                this.setShort((Short)value);
                return;
            }
            case "java.lang.String": {
                this.setString((String)value);
                return;
            }
            case "java.sql.Time": {
                this.setTime((Time)value);
                return;
            }
            case "java.time.LocalTime": {
                this.setLocalTime((LocalTime)value);
                return;
            }
            case "java.sql.Timestamp": {
                this.setTimestamp((Timestamp)value);
                return;
            }
            case "java.time.LocalDateTime": {
                this.setLocalDateTime((LocalDateTime)value);
                return;
            }
            case "java.time.OffsetTime": {
                this.setOffsetTime((OffsetTime)value);
                return;
            }
            case "java.time.OffsetDateTime": {
                this.setOffsetDateTime((OffsetDateTime)value);
                return;
            }
            case "java.time.ZonedDateTime": {
                this.setZonedDateTime((ZonedDateTime)value);
                return;
            }
            case "java.util.Date": {
                this.setTimestamp(new Timestamp(((java.util.Date)value).getTime()));
                return;
            }
            case "org.firebirdsql.gds.ng.DatatypeCoder$RawDateTimeStruct": {
                this.setRawDateTimeStruct((DatatypeCoder.RawDateTimeStruct)value);
                return;
            }
            case "java.math.BigInteger": {
                this.setBigInteger((BigInteger)value);
                return;
            }
            case "org.firebirdsql.jdbc.FBRowId": {
                this.setRowId((RowId)value);
                return;
            }
            case "org.firebirdsql.extern.decimal.Decimal32": 
            case "org.firebirdsql.extern.decimal.Decimal64": 
            case "org.firebirdsql.extern.decimal.Decimal128": {
                this.setDecimal((Decimal)value);
                return;
            }
        }
        if (value instanceof BigDecimal) {
            this.setBigDecimal((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            this.setBigInteger((BigInteger)value);
        } else if (value instanceof RowId) {
            this.setRowId((RowId)value);
        } else if (value instanceof InputStream) {
            this.setBinaryStream((InputStream)value);
        } else if (value instanceof Reader) {
            this.setCharacterStream((Reader)value);
        } else if (value instanceof Clob) {
            if (value instanceof FBClob) {
                this.setClob((FBClob)value);
            } else {
                this.setCharacterStream(((Clob)value).getCharacterStream());
            }
        } else if (value instanceof Blob) {
            if (value instanceof FBBlob) {
                this.setBlob((FBBlob)value);
            } else {
                this.setBinaryStream(((Blob)value).getBinaryStream());
            }
        } else if (value instanceof Date) {
            this.setDate((Date)value);
        } else if (value instanceof Time) {
            this.setTime((Time)value);
        } else if (value instanceof Timestamp) {
            this.setTimestamp((Timestamp)value);
        } else if (value instanceof java.util.Date) {
            this.setTimestamp(new Timestamp(((java.util.Date)value).getTime()));
        } else if (value instanceof Decimal) {
            this.setDecimal((Decimal)value);
        } else {
            throw this.invalidSetConversion(value.getClass());
        }
    }

    protected void setBinaryStreamInternal(InputStream in, long length) throws SQLException {
        throw this.invalidSetConversion(InputStream.class);
    }

    public final void setBinaryStream(InputStream in, long length) throws SQLException {
        if (length < 0L) {
            throw new SQLNonTransientException("Length needs to be >= 0, was: " + length);
        }
        this.setBinaryStreamInternal(in, length);
    }

    public final void setBinaryStream(InputStream in) throws SQLException {
        this.setBinaryStreamInternal(in, -1L);
    }

    public final void setBinaryStream(InputStream in, int length) throws SQLException {
        this.setBinaryStream(in, (long)length);
    }

    protected void setCharacterStreamInternal(Reader in, long length) throws SQLException {
        throw this.invalidSetConversion(Reader.class);
    }

    public final void setCharacterStream(Reader in, long length) throws SQLException {
        if (length < 0L) {
            throw new SQLNonTransientException("Length needs to be >= 0, was: " + length);
        }
        this.setCharacterStreamInternal(in, length);
    }

    public final void setCharacterStream(Reader in) throws SQLException {
        this.setCharacterStreamInternal(in, -1L);
    }

    public final void setCharacterStream(Reader in, int length) throws SQLException {
        this.setCharacterStream(in, (long)length);
    }

    public void setBytes(byte[] value) throws SQLException {
        throw this.invalidSetConversion("byte[]");
    }

    public void setDate(Date value, Calendar cal) throws SQLException {
        throw this.invalidSetConversion(Date.class);
    }

    public void setDate(Date value) throws SQLException {
        throw this.invalidSetConversion(Date.class);
    }

    void setLocalDate(LocalDate value) throws SQLException {
        throw this.invalidSetConversion(LocalDate.class);
    }

    public void setTime(Time value, Calendar cal) throws SQLException {
        throw this.invalidSetConversion(Time.class);
    }

    public void setTime(Time value) throws SQLException {
        throw this.invalidSetConversion(Time.class);
    }

    void setLocalTime(LocalTime value) throws SQLException {
        throw this.invalidSetConversion(LocalTime.class);
    }

    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        throw this.invalidSetConversion(Timestamp.class);
    }

    public void setTimestamp(Timestamp value) throws SQLException {
        throw this.invalidSetConversion(Timestamp.class);
    }

    void setLocalDateTime(LocalDateTime value) throws SQLException {
        throw this.invalidSetConversion(LocalDateTime.class);
    }

    void setOffsetTime(OffsetTime value) throws SQLException {
        throw this.invalidSetConversion(OffsetTime.class);
    }

    void setOffsetDateTime(OffsetDateTime value) throws SQLException {
        throw this.invalidSetConversion(OffsetDateTime.class);
    }

    void setZonedDateTime(ZonedDateTime value) throws SQLException {
        throw this.invalidSetConversion(ZonedDateTime.class);
    }

    public void setBlob(FBBlob blob) throws SQLException {
        throw this.invalidSetConversion(Blob.class);
    }

    public void setBlob(Blob blob) throws SQLException {
        throw this.invalidSetConversion(Blob.class);
    }

    FBBlob createBlob() throws SQLException {
        throw this.invalidSetConversion(Blob.class);
    }

    public void setClob(FBClob clob) throws SQLException {
        throw this.invalidSetConversion(Clob.class);
    }

    public void setClob(Clob clob) throws SQLException {
        throw this.invalidSetConversion(Clob.class);
    }

    final FBClob createClob() throws SQLException {
        return new FBClob(this.createBlob());
    }

    public void setRowId(RowId rowId) throws SQLException {
        throw this.invalidSetConversion(RowId.class);
    }

    @Deprecated
    public DatatypeCoder.RawDateTimeStruct getRawDateTimeStruct() throws SQLException {
        throw this.invalidGetConversion(DatatypeCoder.RawDateTimeStruct.class);
    }

    @Deprecated
    public void setRawDateTimeStruct(DatatypeCoder.RawDateTimeStruct raw) throws SQLException {
        throw this.invalidSetConversion(DatatypeCoder.RawDateTimeStruct.class);
    }

    final boolean setWhenNull(Object value) {
        if (value == null) {
            this.setNull();
            return true;
        }
        return false;
    }

    public Decimal<?> getDecimal() throws SQLException {
        BigDecimal bdValue = this.getBigDecimal();
        try {
            return bdValue != null ? Decimal128.valueOf(bdValue, OverflowHandling.THROW_EXCEPTION) : null;
        }
        catch (ArithmeticException e) {
            SQLException conversionException = this.invalidGetConversion(Decimal128.class, String.format("value %s out of range", bdValue));
            conversionException.initCause(e);
            throw conversionException;
        }
    }

    public final <D extends Decimal<D>> D getDecimal(Class<D> targetType) throws SQLException {
        Decimal<?> value = this.getDecimal();
        try {
            return value != null ? (D)value.toDecimal(targetType, OverflowHandling.THROW_EXCEPTION) : null;
        }
        catch (ArithmeticException e) {
            SQLException conversionException = this.invalidGetConversion(targetType, String.format("value %s out of range", value));
            conversionException.initCause(e);
            throw conversionException;
        }
    }

    public void setDecimal(Decimal<?> decimal) throws SQLException {
        try {
            this.setBigDecimal(decimal != null ? decimal.toBigDecimal() : null);
        }
        catch (ArithmeticException e) {
            SQLException conversionException = this.invalidSetConversion(Objects.requireNonNull(decimal).getClass(), String.format("value %s out of range", decimal));
            conversionException.initCause(e);
            throw conversionException;
        }
    }

    protected boolean isInvertTimeZone() {
        if (this.gdsHelper == null) {
            return false;
        }
        IConnectionProperties props = this.gdsHelper.getConnectionProperties();
        return props.isTimestampUsesLocalTimezone();
    }

    final SQLException invalidGetConversion(Class<?> requestedType) {
        return this.invalidGetConversion(requestedType.getName(), null);
    }

    final SQLException invalidGetConversion(Class<?> requestedType, String reason) {
        return this.invalidGetConversion(requestedType.getName(), reason);
    }

    final SQLException invalidGetConversion(String requestedTypeName) {
        return this.invalidGetConversion(requestedTypeName, null);
    }

    final SQLException invalidGetConversion(String requestedTypeName, String reason) {
        Object message = String.format("Unsupported get conversion requested for field %s at index %d (JDBC type %s), target type: %s", this.getAlias(), this.fieldDescriptor.getPosition() + 1, this.getJdbcTypeName(), requestedTypeName);
        if (reason != null) {
            message = (String)message + ", reason: " + reason;
        }
        return new TypeConversionException((String)message);
    }

    final SQLException invalidSetConversion(Class<?> sourceType) {
        return this.invalidSetConversion(sourceType.getName(), null);
    }

    final SQLException invalidSetConversion(Class<?> sourceType, String reason) {
        return this.invalidSetConversion(sourceType.getName(), reason);
    }

    final SQLException invalidSetConversion(String sourceTypeName) {
        return this.invalidSetConversion(sourceTypeName, null);
    }

    final SQLException invalidSetConversion(String sourceTypeName, String reason) {
        Object message = String.format("Unsupported set conversion requested for field %s at index %d (JDBC type %s), source type: %s", this.getAlias(), this.fieldDescriptor.getPosition() + 1, this.getJdbcTypeName(), sourceTypeName);
        if (reason != null) {
            message = (String)message + ", reason: " + reason;
        }
        return new TypeConversionException((String)message);
    }

    final <T> T fromString(String value, Function<String, T> converter) throws SQLException {
        if (value == null) {
            return null;
        }
        String string = value.trim();
        try {
            return converter.apply(value);
        }
        catch (RuntimeException e) {
            SQLException conversionException = this.invalidSetConversion(String.class, string);
            conversionException.initCause(e);
            throw conversionException;
        }
    }
}

