/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLWarning;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.firebirdsql.gds.ng.AbstractFbDatabase;
import org.firebirdsql.gds.ng.ExecutionPlanProcessor;
import org.firebirdsql.gds.ng.FbDatabaseOperation;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.FetchType;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.OperationCloseHandle;
import org.firebirdsql.gds.ng.SqlCountHolder;
import org.firebirdsql.gds.ng.SqlCountProcessor;
import org.firebirdsql.gds.ng.StatementInfoProcessor;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.gds.ng.listeners.StatementListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractFbStatement
implements FbStatement {
    private static final long MAX_STATEMENT_TIMEOUT = 0xFFFFFFFFL;
    private static final Set<StatementState> RESET_TO_PREPARED = Collections.unmodifiableSet(EnumSet.of(StatementState.EXECUTING, StatementState.CURSOR_OPEN));
    private static final Logger log = LoggerFactory.getLogger(AbstractFbStatement.class);
    private static final int BEFORE_FIRST = -1;
    private static final int IN_CURSOR = 0;
    private static final int AFTER_LAST = 1;
    private final WarningMessageCallback warningCallback = new WarningMessageCallback(){

        @Override
        public void processWarning(SQLWarning warning) {
            AbstractFbStatement.this.statementListenerDispatcher.warningReceived(AbstractFbStatement.this, warning);
        }
    };
    protected final StatementListenerDispatcher statementListenerDispatcher = new StatementListenerDispatcher();
    protected final ExceptionListenerDispatcher exceptionListenerDispatcher = new ExceptionListenerDispatcher(this);
    private volatile int cursorPosition = -1;
    private boolean fetched;
    private volatile StatementState state = StatementState.NEW;
    private volatile StatementType type = StatementType.NONE;
    private volatile RowDescriptor parameterDescriptor;
    private volatile RowDescriptor fieldDescriptor;
    private volatile FbTransaction transaction;
    private long timeout;
    private final TransactionListener transactionListener = new TransactionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transactionStateChanged(FbTransaction transaction, TransactionState newState, TransactionState previousState) {
            if (AbstractFbStatement.this.getTransaction() != transaction) {
                transaction.removeTransactionListener(this);
                return;
            }
            switch (newState) {
                case COMMITTED: 
                case ROLLED_BACK: {
                    LockCloseable ignored = AbstractFbStatement.this.withLock();
                    try {
                        try {
                            if (RESET_TO_PREPARED.contains((Object)AbstractFbStatement.this.getState())) {
                                try {
                                    AbstractFbStatement.this.switchState(StatementState.PREPARED);
                                }
                                catch (SQLException e) {
                                    throw new IllegalStateException("Received an SQLException when none was expected", e);
                                }
                                AbstractFbStatement.this.reset(false);
                            }
                        }
                        finally {
                            transaction.removeTransactionListener(this);
                            try {
                                AbstractFbStatement.this.setTransaction(null);
                            }
                            catch (SQLException e) {
                                throw new IllegalStateException("Received an SQLException when none was expected", e);
                            }
                        }
                        if (ignored == null) break;
                        ignored.close();
                        break;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
    };
    private static final Set<StatementState> PREPARE_ALLOWED_STATES = Collections.unmodifiableSet(EnumSet.of(StatementState.NEW, StatementState.ALLOCATED, StatementState.PREPARED));

    protected AbstractFbStatement() {
        this.exceptionListenerDispatcher.addListener(new StatementCancelledListener());
        this.statementListenerDispatcher.addListener(new SelfListener());
    }

    protected final TransactionListener getTransactionListener() {
        return this.transactionListener;
    }

    protected final WarningMessageCallback getStatementWarningCallback() {
        return this.warningCallback;
    }

    @Override
    public final boolean hasFetched() {
        return this.fetched;
    }

    @Override
    public void close() throws SQLException {
        if (this.getState() == StatementState.CLOSED) {
            return;
        }
        try (LockCloseable ignored = this.withLock();){
            try {
                StatementState currentState = this.getState();
                this.forceState(StatementState.CLOSING);
                if (currentState != StatementState.NEW) {
                    this.free(2);
                }
            }
            finally {
                this.forceState(StatementState.CLOSED);
                this.setType(StatementType.NONE);
                this.statementListenerDispatcher.shutdown();
                this.setTransaction(null);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    @Override
    public final void closeCursor() throws SQLException {
        this.closeCursor(false);
    }

    @Override
    public final void closeCursor(boolean transactionEnd) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (!this.getState().isCursorOpen()) {
                return;
            }
            try {
                if (!transactionEnd && this.getType().isTypeWithCursor()) {
                    this.free(1);
                }
                this.switchState(StatementState.PREPARED);
            }
            catch (SQLException e) {
                this.switchState(StatementState.ERROR);
                throw e;
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public final void ensureClosedCursor(boolean transactionEnd) throws SQLException {
        if (this.getState().isCursorOpen()) {
            this.closeCursor(transactionEnd);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unprepare() throws SQLException {
        if (this.getDatabase().getServerVersion().isEqualOrAbove(2, 5)) {
            try (LockCloseable ignored = this.withLock();){
                StatementState currentState = this.getState();
                if (currentState == StatementState.NEW || currentState == StatementState.ALLOCATED) return;
                this.switchState(StatementState.ALLOCATED);
                this.free(4);
                return;
            }
            catch (SQLException e) {
                this.exceptionListenerDispatcher.errorOccurred(e);
                throw e;
            }
        } else {
            this.closeCursor();
        }
    }

    @Override
    public final StatementState getState() {
        return this.state;
    }

    protected final void switchState(StatementState newState) throws SQLException {
        block9: {
            try (LockCloseable ignored = this.withLock();){
                StatementState currentState = this.state;
                if (currentState == newState || currentState == StatementState.CLOSED) {
                    return;
                }
                if (currentState.isValidTransition(newState)) {
                    this.state = newState;
                    this.statementListenerDispatcher.statementStateChanged(this, newState, currentState);
                    break block9;
                }
                throw new SQLNonTransientException(String.format("Statement state %s only allows next states %s, received %s", new Object[]{currentState, currentState.validTransitionSet(), newState}));
            }
        }
    }

    protected void forceState(StatementState newState) {
        try (LockCloseable ignored = this.withLock();){
            StatementState currentState = this.state;
            if (currentState == newState || currentState == StatementState.CLOSED) {
                return;
            }
            if (log.isDebugEnabled() && !currentState.isValidTransition(newState)) {
                log.debugfe("Forced statement transition is invalid; state %s only allows next states %s, forced to set %s", (Object)currentState, currentState.validTransitionSet(), (Object)newState, new IllegalStateException("debugging stacktrace"));
            }
            this.state = newState;
            this.statementListenerDispatcher.statementStateChanged(this, newState, currentState);
        }
    }

    @Override
    public final StatementType getType() {
        return this.type;
    }

    protected void setType(StatementType type) {
        this.type = type;
    }

    protected final void queueRowData(RowValue rowData) {
        this.cursorPosition = 0;
        this.statementListenerDispatcher.receivedRow(this, rowData);
    }

    protected final void setBeforeFirst() {
        this.setBeforeFirst(true);
    }

    private void setBeforeFirst(boolean notify) {
        this.cursorPosition = -1;
        if (notify) {
            this.statementListenerDispatcher.beforeFirst(this);
        }
    }

    protected final boolean isBeforeFirst() {
        return this.cursorPosition == -1;
    }

    protected final void setAfterLast() {
        this.cursorPosition = 1;
        this.statementListenerDispatcher.afterLast(this);
    }

    protected final boolean isAfterLast() {
        return this.cursorPosition == 1;
    }

    protected final void reset() {
        this.reset(false);
    }

    protected final void resetAll() {
        this.reset(true);
    }

    protected void reset(boolean resetAll) {
        try (LockCloseable ignored = this.withLock();){
            StatementType statementType = this.getType();
            this.setBeforeFirst(statementType.isTypeWithCursor() || statementType.isTypeWithSingletonResult());
            if (resetAll) {
                this.setParameterDescriptor(null);
                this.setRowDescriptor(null);
                this.setType(StatementType.NONE);
            }
        }
    }

    protected boolean isPrepareAllowed(StatementState state) {
        return PREPARE_ALLOWED_STATES.contains((Object)state);
    }

    @Override
    public final RowDescriptor getParameterDescriptor() {
        return this.parameterDescriptor;
    }

    protected void setParameterDescriptor(RowDescriptor parameterDescriptor) {
        this.parameterDescriptor = parameterDescriptor;
    }

    @Override
    public final RowDescriptor getRowDescriptor() {
        return this.fieldDescriptor;
    }

    protected void setRowDescriptor(RowDescriptor rowDescriptor) {
        this.fieldDescriptor = rowDescriptor;
    }

    public byte[] getStatementInfoRequestItems() {
        return ((AbstractFbDatabase)this.getDatabase()).getStatementInfoRequestItems();
    }

    public byte[] getParameterDescriptionInfoRequestItems() {
        return ((AbstractFbDatabase)this.getDatabase()).getParameterDescriptionInfoRequestItems();
    }

    @Override
    public final void fetchScroll(FetchType fetchType, int fetchSize, int position) throws SQLException {
        if (fetchType == FetchType.NEXT) {
            this.fetchRows(fetchSize);
            return;
        }
        try {
            this.fetchScrollImpl(fetchType, fetchSize, position);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected void fetchScrollImpl(FetchType fetchType, int fetchSize, int position) throws SQLException {
        throw new FBDriverNotCapableException("implementation does not support fetchScroll");
    }

    @Override
    public final <T> T getSqlInfo(byte[] requestItems, int bufferLength, InfoProcessor<T> infoProcessor) throws SQLException {
        byte[] sqlInfo = this.getSqlInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(sqlInfo);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public final <T> T getCursorInfo(byte[] requestItems, int bufferLength, InfoProcessor<T> infoProcessor) throws SQLException {
        byte[] sqlInfo = this.getCursorInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(sqlInfo);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public final byte[] getCursorInfo(byte[] requestItems, int bufferLength) throws SQLException {
        try {
            this.checkStatementValid();
            return this.getCursorInfoImpl(requestItems, bufferLength);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected byte[] getCursorInfoImpl(byte[] requestItems, int bufferLength) throws SQLException {
        throw new FBDriverNotCapableException("implementation does not support getCursorInfo: " + String.valueOf(this.getClass()));
    }

    @Override
    public final String getExecutionPlan() throws SQLException {
        ExecutionPlanProcessor processor = this.createExecutionPlanProcessor();
        return this.getSqlInfo(processor.getDescribePlanInfoItems(), this.getDefaultSqlInfoSize(), processor);
    }

    @Override
    public final String getExplainedExecutionPlan() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkExplainedExecutionPlanSupport();
            ExecutionPlanProcessor processor = this.createExecutionPlanProcessor();
            String string = this.getSqlInfo(processor.getDescribeExplainedPlanInfoItems(), this.getDefaultSqlInfoSize(), processor);
            return string;
        }
    }

    private void checkExplainedExecutionPlanSupport() throws SQLException {
        try {
            this.checkStatementValid();
            if (!this.getDatabase().getServerVersion().isEqualOrAbove(3, 0)) {
                throw FbExceptionBuilder.forException(337248293).toSQLException();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected ExecutionPlanProcessor createExecutionPlanProcessor() {
        return new ExecutionPlanProcessor(this);
    }

    @Override
    public SqlCountHolder getSqlCounts() throws SQLException {
        try {
            this.checkStatementValid();
            if (this.getState() == StatementState.CURSOR_OPEN && !this.isAfterLast()) {
                throw new FbExceptionBuilder().nonTransientException(337248299).toSQLException();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        SqlCountProcessor countProcessor = this.createSqlCountProcessor();
        SqlCountHolder sqlCounts = this.getSqlInfo(countProcessor.getRecordCountInfoItems(), 64, countProcessor);
        this.statementListenerDispatcher.sqlCounts(this, sqlCounts);
        return sqlCounts;
    }

    protected SqlCountProcessor createSqlCountProcessor() {
        return new SqlCountProcessor();
    }

    protected abstract void free(int var1) throws SQLException;

    @Override
    public final void validateParameters(RowValue parameters) throws SQLException {
        RowDescriptor parameterDescriptor = this.getParameterDescriptor();
        int expectedSize = parameterDescriptor != null ? parameterDescriptor.getCount() : 0;
        int actualSize = parameters.getCount();
        if (actualSize != expectedSize) {
            throw new FbExceptionBuilder().nonTransientException(337248300).messageParameter(expectedSize, actualSize).toSQLException();
        }
        for (int fieldIndex = 0; fieldIndex < actualSize; ++fieldIndex) {
            if (parameters.isInitialized(fieldIndex)) continue;
            throw new FbExceptionBuilder().transientException(337248301).messageParameter(fieldIndex + 1).toSQLException();
        }
    }

    @Override
    public final void addStatementListener(StatementListener statementListener) {
        if (this.getState() == StatementState.CLOSED) {
            return;
        }
        this.statementListenerDispatcher.addListener(statementListener);
    }

    @Override
    public final void removeStatementListener(StatementListener statementListener) {
        this.statementListenerDispatcher.removeListener(statementListener);
    }

    @Override
    public final void addExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.addListener(listener);
    }

    @Override
    public final void removeExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.removeListener(listener);
    }

    protected final void checkStatementValid() throws SQLException {
        switch (this.getState()) {
            case NEW: {
                throw new FbExceptionBuilder().nonTransientException(337248302).toSQLException();
            }
            case CLOSING: 
            case CLOSED: {
                throw new FbExceptionBuilder().nonTransientException(337248303).toSQLException();
            }
            case ERROR: {
                throw new FbExceptionBuilder().nonTransientException(337248304).toSQLException();
            }
        }
    }

    protected final void checkStatementValid(StatementState ignoreState) throws SQLException {
        if (ignoreState == this.getState()) {
            return;
        }
        this.checkStatementValid();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.getState() != StatementState.CLOSED) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public FbTransaction getTransaction() {
        return this.transaction;
    }

    protected abstract boolean isValidTransactionClass(Class<? extends FbTransaction> var1);

    @Override
    public final void setTransaction(FbTransaction newTransaction) throws SQLException {
        block13: {
            try {
                if (newTransaction == null || this.isValidTransactionClass(newTransaction.getClass())) {
                    try (LockCloseable ignored = this.withLock();){
                        if (newTransaction == this.transaction) {
                            return;
                        }
                        if (this.transaction != null) {
                            this.transaction.removeTransactionListener(this.getTransactionListener());
                        }
                        this.transaction = newTransaction;
                        if (newTransaction != null) {
                            newTransaction.addTransactionListener(this.getTransactionListener());
                        }
                        break block13;
                    }
                }
                throw new SQLNonTransientException(String.format("Invalid transaction handle type, got \"%s\"", newTransaction.getClass().getName()), "HY000");
            }
            catch (SQLNonTransientException e) {
                this.exceptionListenerDispatcher.errorOccurred(e);
                throw e;
            }
        }
    }

    @Override
    public void setTimeout(long statementTimeout) throws SQLException {
        try {
            if (statementTimeout < 0L) {
                throw new FbExceptionBuilder().nonTransientException(337248296).toSQLException();
            }
            try (LockCloseable ignored = this.withLock();){
                this.checkStatementValid(StatementState.NEW);
                this.timeout = statementTimeout;
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public long getTimeout() throws SQLException {
        LockCloseable ignored = this.withLock();
        try {
            this.checkStatementValid(StatementState.NEW);
            long l = this.timeout;
            if (ignored != null) {
                ignored.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.exceptionListenerDispatcher.errorOccurred(e);
                throw e;
            }
        }
    }

    protected long getAllowedTimeout() throws SQLException {
        long timeout = this.getTimeout();
        if (timeout > 0xFFFFFFFFL) {
            return 0L;
        }
        return timeout;
    }

    protected void parseStatementInfo(byte[] statementInfoResponse) throws SQLException {
        StatementInfoProcessor infoProcessor = new StatementInfoProcessor(this, this.getDatabase());
        InfoProcessor.StatementInfo statementInfo = infoProcessor.process(statementInfoResponse);
        this.setType(statementInfo.getStatementType());
        this.setRowDescriptor(statementInfo.getFields());
        this.setParameterDescriptor(statementInfo.getParameters());
    }

    protected final boolean hasSingletonResult() {
        return this.getType().isTypeWithSingletonResult() && this.hasFields();
    }

    protected final boolean hasFields() {
        RowDescriptor fieldDescriptor = this.getRowDescriptor();
        return fieldDescriptor != null && fieldDescriptor.getCount() > 0;
    }

    protected final OperationCloseHandle signalExecute() {
        return FbDatabaseOperation.signalExecute(this.getDatabase());
    }

    protected final OperationCloseHandle signalFetch() {
        return FbDatabaseOperation.signalFetch(this.getDatabase(), this::fetchExecuted);
    }

    private void fetchExecuted() {
        this.fetched = true;
    }

    private final class SelfListener
    implements StatementListener {
        private SelfListener() {
        }

        @Override
        public void statementStateChanged(FbStatement sender, StatementState newState, StatementState previousState) {
            AbstractFbStatement.this.fetched = false;
        }
    }

    private final class StatementCancelledListener
    implements ExceptionListener {
        private StatementCancelledListener() {
        }

        @Override
        public void errorOccurred(Object source, SQLException ex) {
            if (source != AbstractFbStatement.this) {
                return;
            }
            switch (ex.getErrorCode()) {
                case 335545127: 
                case 335545128: 
                case 335545129: {
                    try {
                        AbstractFbStatement.this.closeCursor();
                        break;
                    }
                    catch (SQLException e) {
                        log.error("Unable to close cursor after statement timeout", e);
                    }
                }
            }
        }
    }
}

