/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.jna.AbstractNativeDatabaseFactory;
import org.firebirdsql.gds.ng.jna.NativeLibraryLoadException;
import org.firebirdsql.gds.ng.jna.NativeResourceTracker;
import org.firebirdsql.jna.embedded.FirebirdEmbeddedLookup;
import org.firebirdsql.jna.embedded.spi.DisposableFirebirdEmbeddedLibrary;
import org.firebirdsql.jna.embedded.spi.FirebirdEmbeddedLibrary;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.WinFbClientLibrary;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FbEmbeddedDatabaseFactory
extends AbstractNativeDatabaseFactory {
    private static final Logger log = LoggerFactory.getLogger(FbEmbeddedDatabaseFactory.class);
    private static final List<String> LIBRARIES_TO_TRY = Collections.unmodifiableList(Arrays.asList("fbembed", "fbclient"));
    private static final FbEmbeddedDatabaseFactory INSTANCE = new FbEmbeddedDatabaseFactory();

    @Override
    protected <T extends IAttachProperties<T>> T filterProperties(T attachProperties) {
        T attachPropertiesCopy = attachProperties.asNewMutable();
        attachPropertiesCopy.setServerName(null);
        return attachPropertiesCopy;
    }

    public static FbEmbeddedDatabaseFactory getInstance() {
        return INSTANCE;
    }

    @Override
    protected FbClientLibrary createClientLibrary() {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        List<String> librariesToTry = this.findLibrariesToTry();
        for (String libraryName : librariesToTry) {
            try {
                if (Platform.isWindows()) {
                    return (FbClientLibrary)Native.load((String)libraryName, WinFbClientLibrary.class);
                }
                return (FbClientLibrary)Native.load((String)libraryName, FbClientLibrary.class);
            }
            catch (RuntimeException | UnsatisfiedLinkError e) {
                throwables.add(e);
                log.debugfe("Attempt to load %s failed", libraryName, e);
            }
        }
        assert (throwables.size() == librariesToTry.size());
        if (log.isErrorEnabled()) {
            log.errorf("Could not load any of the libraries in %s:", (Object)librariesToTry);
            for (int idx = 0; idx < librariesToTry.size(); ++idx) {
                log.errorfe("Loading %s failed", librariesToTry.get(idx), (Throwable)throwables.get(idx));
            }
        }
        throw new NativeLibraryLoadException("Could not load any of " + String.valueOf(librariesToTry) + "; linking first exception", (Throwable)throwables.get(0));
    }

    private List<String> findLibrariesToTry() {
        Optional<FirebirdEmbeddedLibrary> optionalFbEmbeddedInstance = FirebirdEmbeddedLookup.findFirebirdEmbedded();
        if (optionalFbEmbeddedInstance.isPresent()) {
            FirebirdEmbeddedLibrary firebirdEmbeddedLibrary = optionalFbEmbeddedInstance.get();
            log.infof("Found Firebird Embedded %s on classpath", (Object)firebirdEmbeddedLibrary.getVersion());
            if (firebirdEmbeddedLibrary instanceof DisposableFirebirdEmbeddedLibrary) {
                NativeResourceTracker.strongRegisterNativeResource(new FirebirdEmbeddedLibraryNativeResource((DisposableFirebirdEmbeddedLibrary)firebirdEmbeddedLibrary));
            }
            Path entryPointPath = firebirdEmbeddedLibrary.getEntryPointPath().toAbsolutePath();
            ArrayList<String> librariesToTry = new ArrayList<String>(LIBRARIES_TO_TRY.size() + 1);
            librariesToTry.add(entryPointPath.toString());
            librariesToTry.addAll(LIBRARIES_TO_TRY);
            return librariesToTry;
        }
        return LIBRARIES_TO_TRY;
    }

    private static class FirebirdEmbeddedLibraryNativeResource
    extends NativeResourceTracker.NativeResource {
        private final DisposableFirebirdEmbeddedLibrary firebirdEmbeddedLibrary;

        private FirebirdEmbeddedLibraryNativeResource(DisposableFirebirdEmbeddedLibrary firebirdEmbeddedLibrary) {
            this.firebirdEmbeddedLibrary = Objects.requireNonNull(firebirdEmbeddedLibrary, "firebirdEmbeddedLibrary");
        }

        @Override
        void dispose() {
            this.firebirdEmbeddedLibrary.dispose();
        }
    }
}

