/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.ptr.IntByReference;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.AbstractFbTransaction;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.jna.JnaDatabase;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.ISC_STATUS;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class JnaTransaction
extends AbstractFbTransaction {
    private static final Logger log = LoggerFactory.getLogger(JnaTransaction.class);
    private final IntByReference handle;
    private final ISC_STATUS[] statusVector = new ISC_STATUS[20];
    private final FbClientLibrary clientLibrary;

    public JnaTransaction(JnaDatabase database, IntByReference transactionHandle, TransactionState initialState) {
        super(initialState, database);
        this.handle = transactionHandle;
        this.clientLibrary = database.getClientLibrary();
    }

    @Override
    public JnaDatabase getDatabase() {
        return (JnaDatabase)super.getDatabase();
    }

    @Override
    public int getHandle() {
        return this.handle.getValue();
    }

    public IntByReference getJnaHandle() {
        return this.handle;
    }

    @Override
    public void commit() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            JnaDatabase db = this.getDatabase();
            db.checkConnected();
            this.switchState(TransactionState.COMMITTING);
            this.clientLibrary.isc_commit_transaction(this.statusVector, this.handle);
            this.processStatusVector();
            this.switchState(TransactionState.COMMITTED);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            TransactionState transactionState = this.getState();
            if (transactionState != TransactionState.COMMITTED && log.isWarnEnabled()) {
                String message = "Commit not completed, state was " + String.valueOf((Object)transactionState);
                if (log.isDebugEnabled()) {
                    log.warnDebug(message, new RuntimeException("Commit not completed"));
                } else {
                    log.warn(message + "; see debug level for stacktrace");
                }
            }
        }
    }

    @Override
    public void rollback() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            JnaDatabase db = this.getDatabase();
            db.checkConnected();
            this.switchState(TransactionState.ROLLING_BACK);
            this.clientLibrary.isc_rollback_transaction(this.statusVector, this.handle);
            this.processStatusVector();
            this.switchState(TransactionState.ROLLED_BACK);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            TransactionState transactionState = this.getState();
            if (transactionState != TransactionState.ROLLED_BACK && log.isWarnEnabled()) {
                String message = "Rollback not completed, state was " + String.valueOf((Object)transactionState);
                if (log.isDebugEnabled()) {
                    log.warnDebug(message, new RuntimeException("Rollback not completed"));
                } else {
                    log.warn(message + "; see debug level for stacktrace");
                }
            }
        }
    }

    @Override
    public void prepare(byte[] recoveryInformation) throws SQLException {
        boolean noRecoveryInfo = recoveryInformation == null || recoveryInformation.length == 0;
        try (LockCloseable ignored = this.withLock();){
            JnaDatabase db = this.getDatabase();
            db.checkConnected();
            this.switchState(TransactionState.PREPARING);
            if (noRecoveryInfo) {
                this.clientLibrary.isc_prepare_transaction(this.statusVector, this.handle);
            } else {
                this.clientLibrary.isc_prepare_transaction2(this.statusVector, this.handle, (short)recoveryInformation.length, recoveryInformation);
            }
            this.processStatusVector();
            this.switchState(TransactionState.PREPARED);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            TransactionState transactionState = this.getState();
            if (transactionState != TransactionState.PREPARED && log.isWarnEnabled()) {
                String message = "Prepare not completed, state was " + String.valueOf((Object)transactionState);
                if (log.isDebugEnabled()) {
                    log.warnDebug(message, new RuntimeException("Prepare not completed"));
                } else {
                    log.warn(message + "; see debug level for stacktrace");
                }
            }
        }
    }

    @Override
    public byte[] getTransactionInfo(byte[] requestItems, int maxBufferLength) throws SQLException {
        try {
            ByteBuffer responseBuffer = ByteBuffer.allocateDirect(maxBufferLength);
            try (LockCloseable ignored = this.withLock();){
                JnaDatabase db = this.getDatabase();
                db.checkConnected();
                this.clientLibrary.isc_transaction_info(this.statusVector, this.handle, (short)requestItems.length, requestItems, (short)maxBufferLength, responseBuffer);
                this.processStatusVector();
            }
            byte[] responseArray = new byte[maxBufferLength];
            responseBuffer.get(responseArray);
            return responseArray;
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void processStatusVector() throws SQLException {
        this.getDatabase().processStatusVector(this.statusVector, null);
    }
}

