/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.firebirdsql.gds.ng.BlobHelper;
import org.firebirdsql.gds.ng.CachedInfoResponse;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListenerDispatcher;
import org.firebirdsql.util.ByteArrayHelper;

public final class InlineBlob
implements FbBlob {
    private static final int LAST_REAL_HANDLE_ID = 65535;
    private static final AtomicInteger localHandleIdGenerator = new AtomicInteger(65535);
    private final int localHandleId = InlineBlob.nextLocalHandleId();
    private final FbDatabase database;
    private final long blobId;
    private final int transactionHandle;
    private final CachedInfoResponse info;
    private final byte[] data;
    private final ExceptionListenerDispatcher exceptionListenerDispatcher = new ExceptionListenerDispatcher(this);
    private int position = -1;

    public InlineBlob(FbDatabase database, long blobId, int transactionHandle, byte[] info, byte[] data) {
        this(database, blobId, transactionHandle, Objects.requireNonNull(info, "info").length != 0 ? new CachedInfoResponse(info) : CachedInfoResponse.empty(), data);
    }

    private InlineBlob(FbDatabase database, long blobId, int transactionHandle, CachedInfoResponse info, byte[] data) {
        this.database = database;
        this.blobId = blobId;
        this.transactionHandle = transactionHandle;
        this.info = info;
        this.data = Objects.requireNonNull(data, "data");
    }

    @Override
    public long getBlobId() {
        return this.blobId;
    }

    public int getTransactionHandle() {
        return this.transactionHandle;
    }

    @Override
    public int getHandle() {
        return this.localHandleId;
    }

    @Override
    public FbDatabase getDatabase() {
        try (LockCloseable ignored = this.withLock();){
            FbDatabase fbDatabase = this.database;
            return fbDatabase;
        }
    }

    @Override
    public void open() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkBlobClosed();
            this.position = 0;
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean isOpen() {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.position >= 0;
            return bl;
        }
    }

    @Override
    public boolean isEof() {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.position >= this.data.length || this.position < 0;
            return bl;
        }
    }

    @Override
    public void close() {
        try (LockCloseable ignored = this.withLock();){
            this.position = -1;
        }
    }

    @Override
    public void cancel() {
        this.close();
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getSegment(int sizeRequested) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (sizeRequested <= 0) {
                throw FbExceptionBuilder.forException(337248257).messageParameter(sizeRequested).toSQLException();
            }
            this.checkBlobOpen();
            int dataLength = this.data.length;
            int originalPosition = this.position;
            if (originalPosition >= dataLength) {
                byte[] byArray = ByteArrayHelper.emptyByteArray();
                return byArray;
            }
            if (originalPosition == 0 && sizeRequested >= dataLength) {
                this.position = dataLength;
                byte[] byArray = (byte[])this.data.clone();
                return byArray;
            }
            int newPosition = this.position = Math.min(dataLength, Math.addExact(originalPosition, sizeRequested));
            byte[] byArray = Arrays.copyOfRange(this.data, originalPosition, newPosition);
            return byArray;
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int get(byte[] b, int off, int len) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            ByteArrayHelper.validateBufferLength(b, off, len);
            this.checkBlobOpen();
            if (this.isEof() || len == 0) {
                int n = 0;
                return n;
            }
            int originalPosition = this.position;
            int size = Math.min(len, this.data.length - originalPosition);
            System.arraycopy(this.data, originalPosition, b, off, size);
            this.position += size;
            int n = size;
            return n;
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public int get(byte[] b, int off, int len, float minFillFactor) throws SQLException {
        return this.get(b, off, len);
    }

    @Override
    public void putSegment(byte[] segment) throws SQLException {
        throw this.writeNotSupported();
    }

    @Override
    public void put(byte[] b, int off, int len) throws SQLException {
        throw this.writeNotSupported();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void seek(int offset, FbBlob.SeekMode seekMode) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkBlobOpen();
            switch (seekMode) {
                case ABSOLUTE: {
                    this.position = Math.min(Math.max(0, offset), this.data.length);
                    return;
                }
                case ABSOLUTE_FROM_END: {
                    this.position = Math.max(0, Math.min(this.data.length + offset, this.data.length));
                    return;
                }
                case RELATIVE: {
                    this.position = Math.max(0, Math.min(this.position + offset, this.data.length));
                    return;
                }
            }
            return;
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public int getMaximumSegmentSize() {
        return 65535;
    }

    @Override
    public <T> T getBlobInfo(byte[] requestItems, int bufferLength, InfoProcessor<T> infoProcessor) throws SQLException {
        byte[] blobInfo = this.getBlobInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(blobInfo);
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public long length() {
        return this.data.length;
    }

    @Override
    public byte[] getBlobInfo(byte[] requestItems, int bufferLength) throws SQLException {
        LockCloseable ignored = this.withLock();
        try {
            this.checkBlobOpen();
            byte[] byArray = this.info.filtered(requestItems);
            if (ignored != null) {
                ignored.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.errorOccurred(e);
                throw e;
            }
        }
    }

    @Override
    public void addExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.addListener(listener);
    }

    @Override
    public void removeExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.removeListener(listener);
    }

    public InlineBlob copy() {
        return new InlineBlob(this.database, this.blobId, this.transactionHandle, this.info, this.data);
    }

    private LockCloseable withLock() {
        FbDatabase database = this.database;
        if (database != null) {
            return database.withLock();
        }
        return LockCloseable.NO_OP;
    }

    private void checkBlobOpen() throws SQLException {
        BlobHelper.checkBlobOpen(this);
    }

    private void checkBlobClosed() throws SQLException {
        BlobHelper.checkBlobClosed(this);
    }

    private void errorOccurred(SQLException e) {
        this.exceptionListenerDispatcher.errorOccurred(e);
    }

    private SQLException writeNotSupported() {
        SQLException e = new FbExceptionBuilder().nonTransientException(335544371).toSQLException();
        this.errorOccurred(e);
        return e;
    }

    private static int nextLocalHandleId() {
        int handleId = localHandleIdGenerator.incrementAndGet();
        while (handleId < 0) {
            localHandleIdGenerator.compareAndSet(handleId, 65535);
            handleId = localHandleIdGenerator.incrementAndGet();
        }
        return handleId;
    }
}

