/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.props.def;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.firebirdsql.jaybird.props.DpbType;
import org.firebirdsql.jaybird.props.InvalidPropertyValueException;
import org.firebirdsql.jaybird.props.def.ConnectionPropertyType;
import org.firebirdsql.util.StringUtils;

public final class ConnectionProperty {
    public static final int NO_DPB_ITEM = -1;
    public static final int NO_SPB_ITEM = -1;
    private final String name;
    private final List<String> aliases;
    private final ConnectionPropertyType type;
    private final List<String> choices;
    private final DpbType pbType;
    private final int dpbItem;
    private final int spbItem;

    private ConnectionProperty(Builder builder) {
        this.name = Objects.requireNonNull(StringUtils.trimToNull(builder.name), "name");
        this.aliases = ConnectionProperty.normalizeValues(builder.aliases);
        this.type = Objects.requireNonNull(builder.type, "type");
        this.choices = ConnectionProperty.normalizeValues(builder.choices);
        this.pbType = Objects.requireNonNull(builder.pbType, "pbType");
        this.dpbItem = builder.dpbItem;
        this.spbItem = builder.spbItem;
        if (this.dpbItem != -1 || this.spbItem != -1) {
            if (this.pbType == DpbType.NONE) {
                throw new IllegalArgumentException("dpbType set to NONE while dpbItem is set to " + this.dpbItem + " and spbItem to " + this.spbItem);
            }
        } else if (this.pbType != DpbType.NONE) {
            throw new IllegalArgumentException("dpbType set to " + String.valueOf((Object)this.pbType) + " while dpbItem and spbItem not set");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name) {
        return ConnectionProperty.builder().name(name);
    }

    public static ConnectionProperty unknown(String name) {
        return ConnectionProperty.builder().name(name).build();
    }

    public String name() {
        return this.name;
    }

    public List<String> aliases() {
        return this.aliases;
    }

    public ConnectionPropertyType type() {
        return this.type;
    }

    public List<String> choices() {
        return this.choices;
    }

    public <T> T validate(T value) {
        this.defaultValidate(value);
        return value;
    }

    private void defaultValidate(Object value) {
        if (value == null || this.choices.isEmpty()) {
            return;
        }
        String valueString = Objects.requireNonNull(this.type.asString(value), "value as string");
        if (this.choices.stream().noneMatch(valueString::equalsIgnoreCase)) {
            throw InvalidPropertyValueException.invalidProperty(this.name(), valueString, "valid values are " + String.valueOf(this.choices()));
        }
    }

    public DpbType pbType() {
        return this.pbType;
    }

    public int dpbItem() {
        return this.dpbItem;
    }

    public boolean hasDpbItem() {
        return this.dpbItem != -1;
    }

    public int spbItem() {
        return this.spbItem;
    }

    public boolean hasSpbItem() {
        return this.spbItem != -1;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionProperty)) {
            return false;
        }
        ConnectionProperty that = (ConnectionProperty)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isIdenticalTo(ConnectionProperty other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.name.equals(other.name) && this.aliases.equals(other.aliases) && this.type == other.type && this.choices.equals(other.choices) && this.pbType == other.pbType && this.dpbItem == other.dpbItem && this.spbItem == other.spbItem;
    }

    private static List<String> normalizeValues(List<String> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        List normalizedValues = values.stream().map(StringUtils::trimToNull).filter(Objects::nonNull).collect(Collectors.toList());
        return normalizedValues.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(normalizedValues);
    }

    public static final class Builder {
        private String name;
        private List<String> aliases;
        private ConnectionPropertyType type = ConnectionPropertyType.STRING;
        private List<String> choices;
        private DpbType pbType = DpbType.NONE;
        private int dpbItem = -1;
        private int spbItem = -1;

        public ConnectionProperty build() {
            return new ConnectionProperty(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder aliases(Collection<String> aliases) {
            this.aliases = aliases != null ? new ArrayList<String>(aliases) : null;
            return this;
        }

        public Builder aliases(String ... aliases) {
            return this.aliases(aliases != null ? Arrays.asList(aliases) : null);
        }

        public Builder aliases(String alias) {
            this.aliases = new ArrayList<String>(1);
            this.aliases.add(alias);
            return this;
        }

        public Builder type(ConnectionPropertyType type) {
            this.type = type;
            if ((this.dpbItem != -1 || this.spbItem != -1) && this.pbType != DpbType.NONE) {
                this.pbType = type.getDefaultParameterType();
            }
            return this;
        }

        public Builder choices(Collection<String> choices) {
            this.choices = choices != null ? new ArrayList<String>(choices) : null;
            return this;
        }

        public Builder choices(String ... choices) {
            return this.choices(choices != null ? Arrays.asList(choices) : null);
        }

        public Builder pbType(DpbType pbType) {
            if (pbType == DpbType.NONE) {
                if (this.dpbItem != -1) {
                    throw new IllegalArgumentException("Not allowed to set pbType NONE when dpbItem is set to " + this.dpbItem);
                }
                if (this.spbItem != -1) {
                    throw new IllegalArgumentException("Not allowed to set pbType NONE when spbItem is set to " + this.spbItem);
                }
            } else if (this.dpbItem == -1 && this.spbItem == -1) {
                throw new IllegalArgumentException("Usage error, set pbType after setting dpbItem or spbItem");
            }
            this.pbType = pbType;
            return this;
        }

        public Builder dpbItem(int dpbItem) {
            this.dpbItem = dpbItem;
            if (dpbItem == -1) {
                if (this.spbItem == -1) {
                    this.pbType = DpbType.NONE;
                }
            } else if (this.pbType == DpbType.NONE) {
                this.pbType = this.type.getDefaultParameterType();
            }
            return this;
        }

        public Builder spbItem(int spbItem) {
            this.spbItem = spbItem;
            if (spbItem == -1) {
                if (this.dpbItem == -1) {
                    this.pbType = DpbType.NONE;
                }
            } else if (this.pbType == DpbType.NONE) {
                this.pbType = this.type.getDefaultParameterType();
            }
            return this;
        }
    }
}

